/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.io;

import com.spatial4j.core.context.jts.JtsSpatialContext;
import com.spatial4j.core.distance.DistanceUtils;
import com.spatial4j.core.exception.InvalidShapeException;
import com.spatial4j.core.io.ShapeReadWriter;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.impl.RectangleImpl;
import com.spatial4j.core.shape.jts.JtsGeometry;
import com.spatial4j.core.shape.jts.JtsPoint;
import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.io.InStream;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import com.vividsolutions.jts.io.WKTReader;
import java.io.IOException;
import java.nio.ByteBuffer;

public class JtsShapeReadWriter
extends ShapeReadWriter<JtsSpatialContext> {
    private static final byte TYPE_POINT = 0;
    private static final byte TYPE_BBOX = 1;
    private static final byte TYPE_GEOM = 2;
    private boolean normalizeGeomCoords = true;

    public JtsShapeReadWriter(JtsSpatialContext ctx) {
        super(ctx);
    }

    private void checkCoordinates(Geometry geom) {
        geom.apply(new CoordinateSequenceFilter(){
            boolean changed = false;

            @Override
            public void filter(CoordinateSequence seq, int i2) {
                double x = seq.getX(i2);
                double y = seq.getY(i2);
                if (((JtsSpatialContext)JtsShapeReadWriter.this.ctx).isGeo() && JtsShapeReadWriter.this.normalizeGeomCoords) {
                    double yNorm;
                    double xNorm = DistanceUtils.normLonDEG(x);
                    if (x != xNorm) {
                        this.changed = true;
                        seq.setOrdinate(i2, 0, xNorm);
                    }
                    if (y != (yNorm = DistanceUtils.normLatDEG(y))) {
                        this.changed = true;
                        seq.setOrdinate(i2, 1, yNorm);
                    }
                } else {
                    ((JtsSpatialContext)JtsShapeReadWriter.this.ctx).verifyX(x);
                    ((JtsSpatialContext)JtsShapeReadWriter.this.ctx).verifyY(y);
                }
            }

            @Override
            public boolean isDone() {
                return false;
            }

            @Override
            public boolean isGeometryChanged() {
                return this.changed;
            }
        });
    }

    @Override
    public Shape readShape(String str) throws InvalidShapeException {
        Shape shape = super.readStandardShape(str);
        if (shape == null) {
            try {
                WKTReader reader = new WKTReader(((JtsSpatialContext)this.ctx).getGeometryFactory());
                Geometry geom = reader.read(str);
                this.checkCoordinates(geom);
                if (geom instanceof Point) {
                    return new JtsPoint((Point)geom, this.ctx);
                }
                if (geom.isRectangle()) {
                    boolean crossesDateline = false;
                    if (((JtsSpatialContext)this.ctx).isGeo()) {
                        crossesDateline = !CGAlgorithms.isCCW(geom.getCoordinates());
                    }
                    Envelope env = geom.getEnvelopeInternal();
                    if (crossesDateline) {
                        return new RectangleImpl(env.getMaxX(), env.getMinX(), env.getMinY(), env.getMaxY(), this.ctx);
                    }
                    return new RectangleImpl(env.getMinX(), env.getMaxX(), env.getMinY(), env.getMaxY(), this.ctx);
                }
                return new JtsGeometry(geom, (JtsSpatialContext)this.ctx, true);
            }
            catch (ParseException ex) {
                throw new InvalidShapeException("error reading WKT", ex);
            }
        }
        return shape;
    }

    @Override
    public String writeShape(Shape shape) {
        if (shape instanceof JtsGeometry) {
            JtsGeometry jtsGeom = (JtsGeometry)shape;
            return jtsGeom.getGeom().toText();
        }
        return super.writeShape(shape);
    }

    public Shape readShapeFromBytes(final byte[] array, final int offset2, final int length2) throws InvalidShapeException {
        ByteBuffer bytes2 = ByteBuffer.wrap(array, offset2, length2);
        byte type2 = bytes2.get();
        if (type2 == 0) {
            return new JtsPoint(((JtsSpatialContext)this.ctx).getGeometryFactory().createPoint(new Coordinate(bytes2.getDouble(), bytes2.getDouble())), this.ctx);
        }
        if (type2 == 1) {
            return new RectangleImpl(bytes2.getDouble(), bytes2.getDouble(), bytes2.getDouble(), bytes2.getDouble(), this.ctx);
        }
        if (type2 == 2) {
            WKBReader reader = new WKBReader(((JtsSpatialContext)this.ctx).getGeometryFactory());
            try {
                Geometry geom = reader.read(new InStream(){
                    int off;
                    {
                        this.off = offset2 + 1;
                    }

                    @Override
                    public void read(byte[] buf) throws IOException {
                        if (this.off + buf.length > length2) {
                            throw new InvalidShapeException("Asking for too many bytes");
                        }
                        System.arraycopy(array, this.off, buf, 0, buf.length);
                        this.off += buf.length;
                    }
                });
                this.checkCoordinates(geom);
                return new JtsGeometry(geom, (JtsSpatialContext)this.ctx, true);
            }
            catch (ParseException ex) {
                throw new InvalidShapeException("error reading WKT", ex);
            }
            catch (IOException ex) {
                throw new InvalidShapeException("error reading WKT", ex);
            }
        }
        throw new InvalidShapeException("shape not handled: " + type2);
    }

    public byte[] writeShapeToBytes(Shape shape) throws IOException {
        if (com.spatial4j.core.shape.Point.class.isInstance(shape)) {
            ByteBuffer bytes2 = ByteBuffer.wrap(new byte[17]);
            com.spatial4j.core.shape.Point p2 = (com.spatial4j.core.shape.Point)shape;
            bytes2.put((byte)0);
            bytes2.putDouble(p2.getX());
            bytes2.putDouble(p2.getY());
            return bytes2.array();
        }
        if (Rectangle.class.isInstance(shape)) {
            Rectangle rect2 = (Rectangle)shape;
            ByteBuffer bytes3 = ByteBuffer.wrap(new byte[33]);
            bytes3.put((byte)1);
            bytes3.putDouble(rect2.getMinX());
            bytes3.putDouble(rect2.getMaxX());
            bytes3.putDouble(rect2.getMinY());
            bytes3.putDouble(rect2.getMaxY());
            return bytes3.array();
        }
        if (JtsGeometry.class.isInstance(shape)) {
            WKBWriter writer = new WKBWriter();
            byte[] bb = writer.write(((JtsGeometry)shape).getGeom());
            ByteBuffer bytes4 = ByteBuffer.wrap(new byte[1 + bb.length]);
            bytes4.put((byte)2);
            bytes4.put(bb);
            return bytes4.array();
        }
        throw new IllegalArgumentException("unsuported shape:" + shape);
    }
}

