/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.shape;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.SpatialRelation;
import java.util.Collection;

public class MultiShape
implements Shape {
    private final Collection<? extends Shape> geoms;
    private final Rectangle bbox;

    public MultiShape(Collection<? extends Shape> geoms, SpatialContext ctx) {
        if (geoms.isEmpty()) {
            throw new IllegalArgumentException("must be given at least 1 shape");
        }
        this.geoms = geoms;
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (Shape shape : geoms) {
            Rectangle r = shape.getBoundingBox();
            minX = Math.min(minX, r.getMinX());
            minY = Math.min(minY, r.getMinY());
            maxX = Math.max(maxX, r.getMaxX());
            maxY = Math.max(maxY, r.getMaxY());
        }
        this.bbox = ctx.makeRectangle(minX, maxX, minY, maxY);
    }

    @Override
    public Rectangle getBoundingBox() {
        return this.bbox;
    }

    @Override
    public Point getCenter() {
        return this.bbox.getCenter();
    }

    @Override
    public boolean hasArea() {
        for (Shape shape : this.geoms) {
            if (!shape.hasArea()) continue;
            return true;
        }
        return false;
    }

    @Override
    public SpatialRelation relate(Shape other) {
        boolean allOutside = true;
        boolean allContains = true;
        for (Shape shape : this.geoms) {
            SpatialRelation sect = shape.relate(other);
            if (sect != SpatialRelation.DISJOINT) {
                allOutside = false;
            }
            if (sect != SpatialRelation.CONTAINS) {
                allContains = false;
            }
            if (allContains || allOutside) continue;
            return SpatialRelation.INTERSECTS;
        }
        if (allOutside) {
            return SpatialRelation.DISJOINT;
        }
        if (allContains) {
            return SpatialRelation.CONTAINS;
        }
        return SpatialRelation.INTERSECTS;
    }

    @Override
    public double getArea(SpatialContext ctx) {
        double sum2 = 0.0;
        for (Shape shape : this.geoms) {
            sum2 += shape.getArea(ctx);
        }
        return sum2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiShape that = (MultiShape)o;
        return !(this.geoms != null ? !this.geoms.equals(that.geoms) : that.geoms != null);
    }

    public int hashCode() {
        return this.geoms != null ? this.geoms.hashCode() : 0;
    }
}

