/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Callback;
import com.sun.jna.CallbackReference;
import com.sun.jna.FromNativeContext;
import com.sun.jna.Function;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.Structure;
import com.sun.jna.ToNativeContext;
import com.sun.jna.WString;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

public class Pointer {
    public static final int SIZE = Native.POINTER_SIZE;
    public static final Pointer NULL;
    protected long peer;

    public static final Pointer createConstant(long peer) {
        return new Opaque(peer);
    }

    public static final Pointer createConstant(int peer) {
        return new Opaque((long)peer & 0xFFFFFFFFFFFFFFFFL);
    }

    Pointer() {
    }

    public Pointer(long peer) {
        this.peer = peer;
    }

    public Pointer share(long offset2) {
        return this.share(offset2, 0L);
    }

    public Pointer share(long offset2, long sz) {
        if (offset2 == 0L) {
            return this;
        }
        return new Pointer(this.peer + offset2);
    }

    public void clear(long size2) {
        this.setMemory(0L, size2, (byte)0);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        return o instanceof Pointer && ((Pointer)o).peer == this.peer;
    }

    public int hashCode() {
        return (int)((this.peer >>> 32) + (this.peer & 0xFFFFFFFFFFFFFFFFL));
    }

    public long indexOf(long offset2, byte value2) {
        return Native.indexOf(this.peer + offset2, value2);
    }

    public void read(long offset2, byte[] buf, int index2, int length2) {
        Native.read(this.peer + offset2, buf, index2, length2);
    }

    public void read(long offset2, short[] buf, int index2, int length2) {
        Native.read(this.peer + offset2, buf, index2, length2);
    }

    public void read(long offset2, char[] buf, int index2, int length2) {
        Native.read(this.peer + offset2, buf, index2, length2);
    }

    public void read(long offset2, int[] buf, int index2, int length2) {
        Native.read(this.peer + offset2, buf, index2, length2);
    }

    public void read(long offset2, long[] buf, int index2, int length2) {
        Native.read(this.peer + offset2, buf, index2, length2);
    }

    public void read(long offset2, float[] buf, int index2, int length2) {
        Native.read(this.peer + offset2, buf, index2, length2);
    }

    public void read(long offset2, double[] buf, int index2, int length2) {
        Native.read(this.peer + offset2, buf, index2, length2);
    }

    public void read(long offset2, Pointer[] buf, int index2, int length2) {
        for (int i2 = 0; i2 < length2; ++i2) {
            Pointer p2 = this.getPointer(offset2 + (long)(i2 * SIZE));
            Pointer oldp = buf[i2 + index2];
            if (oldp != null && p2 != null && p2.peer == oldp.peer) continue;
            buf[i2 + index2] = p2;
        }
    }

    public void write(long offset2, byte[] buf, int index2, int length2) {
        Native.write(this.peer + offset2, buf, index2, length2);
    }

    public void write(long offset2, short[] buf, int index2, int length2) {
        Native.write(this.peer + offset2, buf, index2, length2);
    }

    public void write(long offset2, char[] buf, int index2, int length2) {
        Native.write(this.peer + offset2, buf, index2, length2);
    }

    public void write(long offset2, int[] buf, int index2, int length2) {
        Native.write(this.peer + offset2, buf, index2, length2);
    }

    public void write(long offset2, long[] buf, int index2, int length2) {
        Native.write(this.peer + offset2, buf, index2, length2);
    }

    public void write(long offset2, float[] buf, int index2, int length2) {
        Native.write(this.peer + offset2, buf, index2, length2);
    }

    public void write(long offset2, double[] buf, int index2, int length2) {
        Native.write(this.peer + offset2, buf, index2, length2);
    }

    public void write(long bOff, Pointer[] buf, int index2, int length2) {
        for (int i2 = 0; i2 < length2; ++i2) {
            this.setPointer(bOff + (long)(i2 * SIZE), buf[index2 + i2]);
        }
    }

    Object getValue(long offset2, Class type2, Object currentValue) {
        Object result2 = null;
        if (Structure.class.isAssignableFrom(type2)) {
            Structure s2 = (Structure)currentValue;
            if (Structure.ByReference.class.isAssignableFrom(type2)) {
                s2 = Structure.updateStructureByReference(type2, s2, this.getPointer(offset2));
            } else {
                s2.useMemory(this, (int)offset2);
                s2.read();
            }
            result2 = s2;
        } else if (type2 == Boolean.TYPE || type2 == Boolean.class) {
            result2 = Function.valueOf(this.getInt(offset2) != 0);
        } else if (type2 == Byte.TYPE || type2 == Byte.class) {
            result2 = new Byte(this.getByte(offset2));
        } else if (type2 == Short.TYPE || type2 == Short.class) {
            result2 = new Short(this.getShort(offset2));
        } else if (type2 == Character.TYPE || type2 == Character.class) {
            result2 = new Character(this.getChar(offset2));
        } else if (type2 == Integer.TYPE || type2 == Integer.class) {
            result2 = new Integer(this.getInt(offset2));
        } else if (type2 == Long.TYPE || type2 == Long.class) {
            result2 = new Long(this.getLong(offset2));
        } else if (type2 == Float.TYPE || type2 == Float.class) {
            result2 = new Float(this.getFloat(offset2));
        } else if (type2 == Double.TYPE || type2 == Double.class) {
            result2 = new Double(this.getDouble(offset2));
        } else if (Pointer.class.isAssignableFrom(type2)) {
            Pointer p2 = this.getPointer(offset2);
            if (p2 != null) {
                Pointer oldp;
                Pointer pointer2 = oldp = currentValue instanceof Pointer ? (Pointer)currentValue : null;
                result2 = oldp == null || p2.peer != oldp.peer ? p2 : oldp;
            }
        } else if (type2 == String.class) {
            Pointer p3 = this.getPointer(offset2);
            result2 = p3 != null ? p3.getString(0L) : null;
        } else if (type2 == WString.class) {
            Pointer p4 = this.getPointer(offset2);
            result2 = p4 != null ? new WString(p4.getString(0L, true)) : null;
        } else if (Callback.class.isAssignableFrom(type2)) {
            Pointer fp = this.getPointer(offset2);
            if (fp == null) {
                result2 = null;
            } else {
                Callback cb = (Callback)currentValue;
                Pointer oldfp = CallbackReference.getFunctionPointer(cb);
                if (!fp.equals(oldfp)) {
                    cb = CallbackReference.getCallback(type2, fp);
                }
                result2 = cb;
            }
        } else if (Buffer.class.isAssignableFrom(type2)) {
            Pointer bp = this.getPointer(offset2);
            if (bp == null) {
                result2 = null;
            } else {
                Pointer oldbp;
                Pointer pointer3 = oldbp = currentValue == null ? null : Native.getDirectBufferPointer((Buffer)currentValue);
                if (oldbp == null || !oldbp.equals(bp)) {
                    throw new IllegalStateException("Can't autogenerate a direct buffer on memory read");
                }
                result2 = currentValue;
            }
        } else if (NativeMapped.class.isAssignableFrom(type2)) {
            NativeMapped nm = (NativeMapped)currentValue;
            if (nm != null) {
                Object value2 = this.getValue(offset2, nm.nativeType(), null);
                result2 = nm.fromNative(value2, new FromNativeContext(type2));
            } else {
                NativeMappedConverter tc = NativeMappedConverter.getInstance(type2);
                Object value3 = this.getValue(offset2, tc.nativeType(), null);
                result2 = tc.fromNative(value3, new FromNativeContext(type2));
            }
        } else if (type2.isArray()) {
            result2 = currentValue;
            if (result2 == null) {
                throw new IllegalStateException("Need an initialized array");
            }
            this.getArrayValue(offset2, result2, type2.getComponentType());
        } else {
            throw new IllegalArgumentException("Reading \"" + type2 + "\" from memory is not supported");
        }
        return result2;
    }

    private void getArrayValue(long offset2, Object o, Class cls) {
        int length2 = 0;
        length2 = Array.getLength(o);
        Object result2 = o;
        if (cls == Byte.TYPE) {
            this.read(offset2, (byte[])result2, 0, length2);
        } else if (cls == Short.TYPE) {
            this.read(offset2, (short[])result2, 0, length2);
        } else if (cls == Character.TYPE) {
            this.read(offset2, (char[])result2, 0, length2);
        } else if (cls == Integer.TYPE) {
            this.read(offset2, (int[])result2, 0, length2);
        } else if (cls == Long.TYPE) {
            this.read(offset2, (long[])result2, 0, length2);
        } else if (cls == Float.TYPE) {
            this.read(offset2, (float[])result2, 0, length2);
        } else if (cls == Double.TYPE) {
            this.read(offset2, (double[])result2, 0, length2);
        } else if (Pointer.class.isAssignableFrom(cls)) {
            this.read(offset2, (Pointer[])result2, 0, length2);
        } else if (Structure.class.isAssignableFrom(cls)) {
            Structure[] sarray = (Structure[])result2;
            if (Structure.ByReference.class.isAssignableFrom(cls)) {
                Pointer[] parray = this.getPointerArray(offset2, sarray.length);
                for (int i2 = 0; i2 < sarray.length; ++i2) {
                    sarray[i2] = Structure.updateStructureByReference(cls, sarray[i2], parray[i2]);
                }
            } else {
                for (int i3 = 0; i3 < sarray.length; ++i3) {
                    if (sarray[i3] == null) {
                        sarray[i3] = Structure.newInstance(cls);
                    }
                    sarray[i3].useMemory(this, (int)(offset2 + (long)(i3 * sarray[i3].size())));
                    sarray[i3].read();
                }
            }
        } else if (NativeMapped.class.isAssignableFrom(cls)) {
            NativeMapped[] array = (NativeMapped[])result2;
            NativeMappedConverter tc = NativeMappedConverter.getInstance(cls);
            int size2 = Native.getNativeSize(result2.getClass(), result2) / array.length;
            for (int i4 = 0; i4 < array.length; ++i4) {
                Object value2 = this.getValue(offset2 + (long)(size2 * i4), tc.nativeType(), array[i4]);
                array[i4] = (NativeMapped)tc.fromNative(value2, new FromNativeContext(cls));
            }
        } else {
            throw new IllegalArgumentException("Reading array of " + cls + " from memory not supported");
        }
    }

    public byte getByte(long offset2) {
        return Native.getByte(this.peer + offset2);
    }

    public char getChar(long offset2) {
        return Native.getChar(this.peer + offset2);
    }

    public short getShort(long offset2) {
        return Native.getShort(this.peer + offset2);
    }

    public int getInt(long offset2) {
        return Native.getInt(this.peer + offset2);
    }

    public long getLong(long offset2) {
        return Native.getLong(this.peer + offset2);
    }

    public NativeLong getNativeLong(long offset2) {
        return new NativeLong(NativeLong.SIZE == 8 ? this.getLong(offset2) : (long)this.getInt(offset2));
    }

    public float getFloat(long offset2) {
        return Native.getFloat(this.peer + offset2);
    }

    public double getDouble(long offset2) {
        return Native.getDouble(this.peer + offset2);
    }

    public Pointer getPointer(long offset2) {
        return Native.getPointer(this.peer + offset2);
    }

    public ByteBuffer getByteBuffer(long offset2, long length2) {
        return Native.getDirectByteBuffer(this.peer + offset2, length2).order(ByteOrder.nativeOrder());
    }

    public String getString(long offset2, boolean wide) {
        return Native.getString(this.peer + offset2, wide);
    }

    public String getString(long offset2) {
        long len;
        String encoding2 = System.getProperty("jna.encoding");
        if (encoding2 != null && (len = this.indexOf(offset2, (byte)0)) != -1L) {
            if (len > Integer.MAX_VALUE) {
                throw new OutOfMemoryError("String exceeds maximum length: " + len);
            }
            byte[] data2 = this.getByteArray(offset2, (int)len);
            try {
                return new String(data2, encoding2);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        return this.getString(offset2, false);
    }

    public byte[] getByteArray(long offset2, int arraySize) {
        byte[] buf = new byte[arraySize];
        this.read(offset2, buf, 0, arraySize);
        return buf;
    }

    public char[] getCharArray(long offset2, int arraySize) {
        char[] buf = new char[arraySize];
        this.read(offset2, buf, 0, arraySize);
        return buf;
    }

    public short[] getShortArray(long offset2, int arraySize) {
        short[] buf = new short[arraySize];
        this.read(offset2, buf, 0, arraySize);
        return buf;
    }

    public int[] getIntArray(long offset2, int arraySize) {
        int[] buf = new int[arraySize];
        this.read(offset2, buf, 0, arraySize);
        return buf;
    }

    public long[] getLongArray(long offset2, int arraySize) {
        long[] buf = new long[arraySize];
        this.read(offset2, buf, 0, arraySize);
        return buf;
    }

    public float[] getFloatArray(long offset2, int arraySize) {
        float[] buf = new float[arraySize];
        this.read(offset2, buf, 0, arraySize);
        return buf;
    }

    public double[] getDoubleArray(long offset2, int arraySize) {
        double[] buf = new double[arraySize];
        this.read(offset2, buf, 0, arraySize);
        return buf;
    }

    public Pointer[] getPointerArray(long base) {
        ArrayList<Pointer> array = new ArrayList<Pointer>();
        int offset2 = 0;
        Pointer p2 = this.getPointer(base);
        while (p2 != null) {
            array.add(p2);
            p2 = this.getPointer(base + (long)(offset2 += SIZE));
        }
        return array.toArray(new Pointer[array.size()]);
    }

    public Pointer[] getPointerArray(long offset2, int arraySize) {
        Pointer[] buf = new Pointer[arraySize];
        this.read(offset2, buf, 0, arraySize);
        return buf;
    }

    public String[] getStringArray(long base) {
        return this.getStringArray(base, -1, false);
    }

    public String[] getStringArray(long base, int length2) {
        return this.getStringArray(base, length2, false);
    }

    public String[] getStringArray(long base, boolean wide) {
        return this.getStringArray(base, -1, wide);
    }

    public String[] getStringArray(long base, int length2, boolean wide) {
        ArrayList<String> strings = new ArrayList<String>();
        int offset2 = 0;
        if (length2 != -1) {
            Pointer p2 = this.getPointer(base + (long)offset2);
            int count2 = 0;
            while (count2++ < length2) {
                String s2 = p2 == null ? null : p2.getString(0L, wide);
                strings.add(s2);
                if (count2 >= length2) continue;
                p2 = this.getPointer(base + (long)(offset2 += SIZE));
            }
        } else {
            Pointer p3;
            while ((p3 = this.getPointer(base + (long)offset2)) != null) {
                String s3 = p3 == null ? null : p3.getString(0L, wide);
                strings.add(s3);
                offset2 += SIZE;
            }
        }
        return strings.toArray(new String[strings.size()]);
    }

    void setValue(long offset2, Object value2, Class type2) {
        if (type2 == Boolean.TYPE || type2 == Boolean.class) {
            this.setInt(offset2, Boolean.TRUE.equals(value2) ? -1 : 0);
        } else if (type2 == Byte.TYPE || type2 == Byte.class) {
            this.setByte(offset2, value2 == null ? (byte)0 : (Byte)value2);
        } else if (type2 == Short.TYPE || type2 == Short.class) {
            this.setShort(offset2, value2 == null ? (short)0 : (Short)value2);
        } else if (type2 == Character.TYPE || type2 == Character.class) {
            this.setChar(offset2, value2 == null ? (char)'\u0000' : ((Character)value2).charValue());
        } else if (type2 == Integer.TYPE || type2 == Integer.class) {
            this.setInt(offset2, value2 == null ? 0 : (Integer)value2);
        } else if (type2 == Long.TYPE || type2 == Long.class) {
            this.setLong(offset2, value2 == null ? 0L : (Long)value2);
        } else if (type2 == Float.TYPE || type2 == Float.class) {
            this.setFloat(offset2, value2 == null ? 0.0f : ((Float)value2).floatValue());
        } else if (type2 == Double.TYPE || type2 == Double.class) {
            this.setDouble(offset2, value2 == null ? 0.0 : (Double)value2);
        } else if (type2 == Pointer.class) {
            this.setPointer(offset2, (Pointer)value2);
        } else if (type2 == String.class) {
            this.setPointer(offset2, (Pointer)value2);
        } else if (type2 == WString.class) {
            this.setPointer(offset2, (Pointer)value2);
        } else if (Structure.class.isAssignableFrom(type2)) {
            Structure s2 = (Structure)value2;
            if (Structure.ByReference.class.isAssignableFrom(type2)) {
                this.setPointer(offset2, s2 == null ? null : s2.getPointer());
                if (s2 != null) {
                    s2.autoWrite();
                }
            } else {
                s2.useMemory(this, (int)offset2);
                s2.write();
            }
        } else if (Callback.class.isAssignableFrom(type2)) {
            this.setPointer(offset2, CallbackReference.getFunctionPointer((Callback)value2));
        } else if (Buffer.class.isAssignableFrom(type2)) {
            Pointer p2 = value2 == null ? null : Native.getDirectBufferPointer((Buffer)value2);
            this.setPointer(offset2, p2);
        } else if (NativeMapped.class.isAssignableFrom(type2)) {
            NativeMappedConverter tc = NativeMappedConverter.getInstance(type2);
            Class nativeType = tc.nativeType();
            this.setValue(offset2, tc.toNative(value2, new ToNativeContext()), nativeType);
        } else if (type2.isArray()) {
            this.setArrayValue(offset2, value2, type2.getComponentType());
        } else {
            throw new IllegalArgumentException("Writing " + type2 + " to memory is not supported");
        }
    }

    private void setArrayValue(long offset2, Object value2, Class cls) {
        if (cls == Byte.TYPE) {
            byte[] buf = (byte[])value2;
            this.write(offset2, buf, 0, buf.length);
        } else if (cls == Short.TYPE) {
            short[] buf = (short[])value2;
            this.write(offset2, buf, 0, buf.length);
        } else if (cls == Character.TYPE) {
            char[] buf = (char[])value2;
            this.write(offset2, buf, 0, buf.length);
        } else if (cls == Integer.TYPE) {
            int[] buf = (int[])value2;
            this.write(offset2, buf, 0, buf.length);
        } else if (cls == Long.TYPE) {
            long[] buf = (long[])value2;
            this.write(offset2, buf, 0, buf.length);
        } else if (cls == Float.TYPE) {
            float[] buf = (float[])value2;
            this.write(offset2, buf, 0, buf.length);
        } else if (cls == Double.TYPE) {
            double[] buf = (double[])value2;
            this.write(offset2, buf, 0, buf.length);
        } else if (Pointer.class.isAssignableFrom(cls)) {
            Pointer[] buf = (Pointer[])value2;
            this.write(offset2, buf, 0, buf.length);
        } else if (Structure.class.isAssignableFrom(cls)) {
            Structure[] sbuf = (Structure[])value2;
            if (Structure.ByReference.class.isAssignableFrom(cls)) {
                Pointer[] buf = new Pointer[sbuf.length];
                for (int i2 = 0; i2 < sbuf.length; ++i2) {
                    if (sbuf[i2] == null) {
                        buf[i2] = null;
                        continue;
                    }
                    buf[i2] = sbuf[i2].getPointer();
                    sbuf[i2].write();
                }
                this.write(offset2, buf, 0, buf.length);
            } else {
                for (int i3 = 0; i3 < sbuf.length; ++i3) {
                    if (sbuf[i3] == null) {
                        sbuf[i3] = Structure.newInstance(cls);
                    }
                    sbuf[i3].useMemory(this, (int)(offset2 + (long)(i3 * sbuf[i3].size())));
                    sbuf[i3].write();
                }
            }
        } else if (NativeMapped.class.isAssignableFrom(cls)) {
            NativeMapped[] buf = (NativeMapped[])value2;
            NativeMappedConverter tc = NativeMappedConverter.getInstance(cls);
            Class nativeType = tc.nativeType();
            int size2 = Native.getNativeSize(value2.getClass(), value2) / buf.length;
            for (int i4 = 0; i4 < buf.length; ++i4) {
                Object element = tc.toNative(buf[i4], new ToNativeContext());
                this.setValue(offset2 + (long)(i4 * size2), element, nativeType);
            }
        } else {
            throw new IllegalArgumentException("Writing array of " + cls + " to memory not supported");
        }
    }

    public void setMemory(long offset2, long length2, byte value2) {
        Native.setMemory(this.peer + offset2, length2, value2);
    }

    public void setByte(long offset2, byte value2) {
        Native.setByte(this.peer + offset2, value2);
    }

    public void setShort(long offset2, short value2) {
        Native.setShort(this.peer + offset2, value2);
    }

    public void setChar(long offset2, char value2) {
        Native.setChar(this.peer + offset2, value2);
    }

    public void setInt(long offset2, int value2) {
        Native.setInt(this.peer + offset2, value2);
    }

    public void setLong(long offset2, long value2) {
        Native.setLong(this.peer + offset2, value2);
    }

    public void setNativeLong(long offset2, NativeLong value2) {
        if (NativeLong.SIZE == 8) {
            this.setLong(offset2, value2.longValue());
        } else {
            this.setInt(offset2, value2.intValue());
        }
    }

    public void setFloat(long offset2, float value2) {
        Native.setFloat(this.peer + offset2, value2);
    }

    public void setDouble(long offset2, double value2) {
        Native.setDouble(this.peer + offset2, value2);
    }

    public void setPointer(long offset2, Pointer value2) {
        Native.setPointer(this.peer + offset2, value2 != null ? value2.peer : 0L);
    }

    public void setString(long offset2, String value2, boolean wide) {
        Native.setString(this.peer + offset2, value2, wide);
    }

    public void setString(long offset2, String value2) {
        byte[] data2 = Native.getBytes(value2);
        this.write(offset2, data2, 0, data2.length);
        this.setByte(offset2 + (long)data2.length, (byte)0);
    }

    public String toString() {
        return "native@0x" + Long.toHexString(this.peer);
    }

    public static long nativeValue(Pointer p2) {
        return p2.peer;
    }

    public static void nativeValue(Pointer p2, long value2) {
        p2.peer = value2;
    }

    static {
        if (SIZE == 0) {
            throw new Error("Native library not initialized");
        }
        NULL = null;
    }

    private static class Opaque
    extends Pointer {
        private final String MSG = "This pointer is opaque: " + this;

        private Opaque(long peer) {
            super(peer);
        }

        public long indexOf(long offset2, byte value2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void read(long bOff, byte[] buf, int index2, int length2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void read(long bOff, char[] buf, int index2, int length2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void read(long bOff, short[] buf, int index2, int length2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void read(long bOff, int[] buf, int index2, int length2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void read(long bOff, long[] buf, int index2, int length2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void read(long bOff, float[] buf, int index2, int length2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void read(long bOff, double[] buf, int index2, int length2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void write(long bOff, byte[] buf, int index2, int length2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void write(long bOff, char[] buf, int index2, int length2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void write(long bOff, short[] buf, int index2, int length2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void write(long bOff, int[] buf, int index2, int length2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void write(long bOff, long[] buf, int index2, int length2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void write(long bOff, float[] buf, int index2, int length2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void write(long bOff, double[] buf, int index2, int length2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public byte getByte(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public char getChar(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public short getShort(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public int getInt(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public long getLong(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public float getFloat(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public double getDouble(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public Pointer getPointer(long bOff) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public String getString(long bOff, boolean wide) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void setByte(long bOff, byte value2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void setChar(long bOff, char value2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void setShort(long bOff, short value2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void setInt(long bOff, int value2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void setLong(long bOff, long value2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void setFloat(long bOff, float value2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void setDouble(long bOff, double value2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void setPointer(long offset2, Pointer value2) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public void setString(long offset2, String value2, boolean wide) {
            throw new UnsupportedOperationException(this.MSG);
        }

        public String toString() {
            return "opaque@0x" + Long.toHexString(this.peer);
        }
    }
}

