/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Callback;
import com.sun.jna.FromNativeContext;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.IntegerType;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.NativeString;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.StructureReadContext;
import com.sun.jna.StructureWriteContext;
import com.sun.jna.ToNativeContext;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.Union;
import com.sun.jna.WString;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public abstract class Structure {
    private static final boolean REVERSE_FIELDS;
    private static final boolean REQUIRES_FIELD_ORDER;
    static final boolean isPPC;
    static final boolean isSPARC;
    public static final int ALIGN_DEFAULT = 0;
    public static final int ALIGN_NONE = 1;
    public static final int ALIGN_GNUC = 2;
    public static final int ALIGN_MSVC = 3;
    private static final int MAX_GNUC_ALIGNMENT;
    protected static final int CALCULATE_SIZE = -1;
    private Pointer memory;
    private int size = -1;
    private int alignType;
    private int structAlignment;
    private final Map structFields = new LinkedHashMap();
    private final Map nativeStrings = new HashMap();
    private TypeMapper typeMapper;
    private long typeInfo;
    private List fieldOrder;
    private boolean autoRead = true;
    private boolean autoWrite = true;
    private Structure[] array;
    private static final ThreadLocal reads;
    private static final ThreadLocal busy;
    static /* synthetic */ Class class$java$lang$Void;

    protected Structure() {
        this((Pointer)null);
    }

    protected Structure(TypeMapper mapper) {
        this(null, 0, mapper);
    }

    protected Structure(Pointer p2) {
        this(p2, 0);
    }

    protected Structure(Pointer p2, int alignment2) {
        this(p2, alignment2, null);
    }

    protected Structure(Pointer p2, int alignment2, TypeMapper mapper) {
        this.setAlignType(alignment2);
        this.setTypeMapper(mapper);
        if (p2 != null) {
            this.useMemory(p2);
        } else {
            this.allocateMemory(-1);
        }
    }

    Map fields() {
        return this.structFields;
    }

    protected void setTypeMapper(TypeMapper mapper) {
        Class<?> declaring;
        if (mapper == null && (declaring = this.getClass().getDeclaringClass()) != null) {
            mapper = Native.getTypeMapper(declaring);
        }
        this.typeMapper = mapper;
        this.size = -1;
        if (this.memory instanceof AutoAllocated) {
            this.memory = null;
        }
    }

    protected void setAlignType(int alignType) {
        if (alignType == 0) {
            Class<?> declaring = this.getClass().getDeclaringClass();
            if (declaring != null) {
                alignType = Native.getStructureAlignment(declaring);
            }
            if (alignType == 0) {
                alignType = Platform.isWindows() ? 3 : 2;
            }
        }
        this.alignType = alignType;
        this.size = -1;
        if (this.memory instanceof AutoAllocated) {
            this.memory = null;
        }
    }

    protected Memory autoAllocate(int size2) {
        return new AutoAllocated(size2);
    }

    protected void useMemory(Pointer m) {
        this.useMemory(m, 0);
    }

    protected void useMemory(Pointer m, int offset2) {
        try {
            this.memory = m;
            if (this.size == -1) {
                this.size = this.calculateSize(false);
            }
            if (this.size != -1) {
                this.memory = m.share(offset2, this.size);
            }
            this.array = null;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Structure exceeds provided memory bounds");
        }
    }

    protected void ensureAllocated() {
        if (this.memory == null) {
            this.allocateMemory();
        } else if (this.size == -1) {
            this.size = this.calculateSize(true);
        }
    }

    protected void allocateMemory() {
        this.allocateMemory(this.calculateSize(true));
    }

    protected void allocateMemory(int size2) {
        if (size2 == -1) {
            size2 = this.calculateSize(false);
        } else if (size2 <= 0) {
            throw new IllegalArgumentException("Structure size must be greater than zero: " + size2);
        }
        if (size2 != -1) {
            if (this.memory == null || this.memory instanceof AutoAllocated) {
                this.memory = this.autoAllocate(size2);
            }
            this.size = size2;
        }
    }

    public int size() {
        this.ensureAllocated();
        if (this.size == -1) {
            this.size = this.calculateSize(true);
        }
        return this.size;
    }

    public void clear() {
        this.memory.clear(this.size());
    }

    public Pointer getPointer() {
        this.ensureAllocated();
        return this.memory;
    }

    static Set busy() {
        return (Set)busy.get();
    }

    static Map reading() {
        return (Map)reads.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read() {
        this.ensureAllocated();
        if (Structure.busy().contains(this)) {
            return;
        }
        Structure.busy().add(this);
        if (this instanceof ByReference) {
            Structure.reading().put(this.getPointer(), this);
        }
        try {
            Iterator i2 = this.structFields.values().iterator();
            while (i2.hasNext()) {
                this.readField((StructField)i2.next());
            }
        }
        finally {
            Structure.busy().remove(this);
            if (Structure.reading().get(this.getPointer()) == this) {
                Structure.reading().remove(this.getPointer());
            }
        }
    }

    public Object readField(String name2) {
        this.ensureAllocated();
        StructField f = (StructField)this.structFields.get(name2);
        if (f == null) {
            throw new IllegalArgumentException("No such field: " + name2);
        }
        return this.readField(f);
    }

    Object getField(StructField structField) {
        try {
            return structField.field.get(this);
        }
        catch (Exception e) {
            throw new Error("Exception reading field '" + structField.name + "' in " + this.getClass() + ": " + e);
        }
    }

    void setField(StructField structField, Object value2) {
        try {
            structField.field.set(this, value2);
        }
        catch (IllegalAccessException e) {
            throw new Error("Unexpectedly unable to write to field '" + structField.name + "' within " + this.getClass() + ": " + e);
        }
    }

    static Structure updateStructureByReference(Class type2, Structure s2, Pointer address2) {
        if (address2 == null) {
            s2 = null;
        } else {
            if (s2 == null || !address2.equals(s2.getPointer())) {
                Structure s1 = (Structure)Structure.reading().get(address2);
                if (s1 != null && type2.equals(s1.getClass())) {
                    s2 = s1;
                } else {
                    s2 = Structure.newInstance(type2);
                    s2.useMemory(address2);
                }
            }
            s2.autoRead();
        }
        return s2;
    }

    Object readField(StructField structField) {
        int offset2 = structField.offset;
        Class fieldType = structField.type;
        FromNativeConverter readConverter = structField.readConverter;
        if (readConverter != null) {
            fieldType = readConverter.nativeType();
        }
        Object currentValue = Structure.class.isAssignableFrom(fieldType) || Callback.class.isAssignableFrom(fieldType) || Buffer.class.isAssignableFrom(fieldType) || Pointer.class.isAssignableFrom(fieldType) || NativeMapped.class.isAssignableFrom(fieldType) || fieldType.isArray() ? this.getField(structField) : null;
        Object result2 = this.memory.getValue(offset2, fieldType, currentValue);
        if (readConverter != null) {
            result2 = readConverter.fromNative(result2, structField.context);
        }
        this.setField(structField, result2);
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() {
        this.ensureAllocated();
        if (this instanceof ByValue) {
            this.getTypeInfo();
        }
        if (Structure.busy().contains(this)) {
            return;
        }
        Structure.busy().add(this);
        try {
            Iterator i2 = this.structFields.values().iterator();
            while (i2.hasNext()) {
                StructField sf = (StructField)i2.next();
                if (sf.isVolatile) continue;
                this.writeField(sf);
            }
        }
        finally {
            Structure.busy().remove(this);
        }
    }

    public void writeField(String name2) {
        this.ensureAllocated();
        StructField f = (StructField)this.structFields.get(name2);
        if (f == null) {
            throw new IllegalArgumentException("No such field: " + name2);
        }
        this.writeField(f);
    }

    public void writeField(String name2, Object value2) {
        this.ensureAllocated();
        StructField f = (StructField)this.structFields.get(name2);
        if (f == null) {
            throw new IllegalArgumentException("No such field: " + name2);
        }
        this.setField(f, value2);
        this.writeField(f);
    }

    void writeField(StructField structField) {
        if (structField.isReadOnly) {
            return;
        }
        int offset2 = structField.offset;
        Object value2 = this.getField(structField);
        Class fieldType = structField.type;
        ToNativeConverter converter = structField.writeConverter;
        if (converter != null) {
            value2 = converter.toNative(value2, new StructureWriteContext(this, structField.field));
            fieldType = converter.nativeType();
        }
        if (String.class == fieldType || WString.class == fieldType) {
            boolean wide;
            boolean bl = wide = fieldType == WString.class;
            if (value2 != null) {
                NativeString nativeString = new NativeString(value2.toString(), wide);
                this.nativeStrings.put(structField.name, nativeString);
                value2 = nativeString.getPointer();
            } else {
                value2 = null;
                this.nativeStrings.remove(structField.name);
            }
        }
        try {
            this.memory.setValue(offset2, value2, fieldType);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            String msg = "Structure field \"" + structField.name + "\" was declared as " + structField.type + (structField.type == fieldType ? "" : " (native type " + fieldType + ")") + ", which is not supported within a Structure";
            throw new IllegalArgumentException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasFieldOrder() {
        Structure structure = this;
        synchronized (structure) {
            return this.fieldOrder != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getFieldOrder() {
        Structure structure = this;
        synchronized (structure) {
            if (this.fieldOrder == null) {
                this.fieldOrder = new ArrayList();
            }
            return this.fieldOrder;
        }
    }

    protected void setFieldOrder(String[] fields2) {
        this.getFieldOrder().addAll(Arrays.asList(fields2));
        this.size = -1;
        if (this.memory instanceof AutoAllocated) {
            this.memory = null;
        }
    }

    protected void sortFields(List fields2, List names2) {
        block0: for (int i2 = 0; i2 < names2.size(); ++i2) {
            String name2 = (String)names2.get(i2);
            for (int f = 0; f < fields2.size(); ++f) {
                Field field2 = (Field)fields2.get(f);
                if (!name2.equals(field2.getName())) continue;
                Collections.swap(fields2, i2, f);
                continue block0;
            }
        }
    }

    protected List getFields(boolean force) {
        ArrayList flist = new ArrayList();
        Class<?> cls = this.getClass();
        while (!cls.equals(class$com$sun$jna$Structure == null ? Structure.class$("com.sun.jna.Structure") : class$com$sun$jna$Structure)) {
            ArrayList<Field> classFields = new ArrayList<Field>();
            Field[] fields2 = cls.getDeclaredFields();
            for (int i2 = 0; i2 < fields2.length; ++i2) {
                int modifiers2 = fields2[i2].getModifiers();
                if (Modifier.isStatic(modifiers2) || !Modifier.isPublic(modifiers2)) continue;
                classFields.add(fields2[i2]);
            }
            if (REVERSE_FIELDS) {
                Collections.reverse(classFields);
            }
            flist.addAll(0, classFields);
            cls = cls.getSuperclass();
        }
        if (REQUIRES_FIELD_ORDER || this.hasFieldOrder()) {
            List fieldOrder = this.getFieldOrder();
            if (fieldOrder.size() < flist.size()) {
                if (force) {
                    throw new Error("This VM does not store fields in a predictable order; you must use Structure.setFieldOrder to explicitly indicate the field order: " + System.getProperty("java.vendor") + ", " + System.getProperty("java.version"));
                }
                return null;
            }
            this.sortFields(flist, fieldOrder);
        }
        return flist;
    }

    int calculateSize(boolean force) {
        this.structAlignment = 1;
        int calculatedSize = 0;
        List fields2 = this.getFields(force);
        if (fields2 == null) {
            return -1;
        }
        boolean firstField = true;
        Iterator i2 = fields2.iterator();
        while (i2.hasNext()) {
            Field field2 = (Field)i2.next();
            int modifiers2 = field2.getModifiers();
            Class type2 = field2.getType();
            StructField structField = new StructField();
            structField.isVolatile = Modifier.isVolatile(modifiers2);
            structField.isReadOnly = Modifier.isFinal(modifiers2);
            if (Modifier.isFinal(modifiers2)) {
                field2.setAccessible(true);
            }
            structField.field = field2;
            structField.name = field2.getName();
            structField.type = type2;
            if ((class$com$sun$jna$Callback == null ? Structure.class$("com.sun.jna.Callback") : class$com$sun$jna$Callback).isAssignableFrom(type2) && !type2.isInterface()) {
                throw new IllegalArgumentException("Structure Callback field '" + field2.getName() + "' must be an interface");
            }
            if (type2.isArray() && (class$com$sun$jna$Structure == null ? Structure.class$("com.sun.jna.Structure") : class$com$sun$jna$Structure).equals(type2.getComponentType())) {
                String msg = "Nested Structure arrays must use a derived Structure type so that the size of the elements can be determined";
                throw new IllegalArgumentException(msg);
            }
            int fieldAlignment = 1;
            if (Modifier.isPublic(field2.getModifiers())) {
                Object value2 = this.getField(structField);
                if (value2 == null) {
                    if ((class$com$sun$jna$Structure == null ? Structure.class$("com.sun.jna.Structure") : class$com$sun$jna$Structure).isAssignableFrom(type2) && !(class$com$sun$jna$Structure$ByReference == null ? Structure.class$("com.sun.jna.Structure$ByReference") : class$com$sun$jna$Structure$ByReference).isAssignableFrom(type2)) {
                        try {
                            value2 = Structure.newInstance(type2);
                            this.setField(structField, value2);
                        }
                        catch (IllegalArgumentException e) {
                            String msg = "Can't determine size of nested structure: " + e.getMessage();
                            throw new IllegalArgumentException(msg);
                        }
                    } else if (type2.isArray()) {
                        if (force) {
                            throw new IllegalStateException("Array fields must be initialized");
                        }
                        return -1;
                    }
                }
                Class nativeType = type2;
                if ((class$com$sun$jna$NativeMapped == null ? Structure.class$("com.sun.jna.NativeMapped") : class$com$sun$jna$NativeMapped).isAssignableFrom(type2)) {
                    NativeMappedConverter tc = NativeMappedConverter.getInstance(type2);
                    if (value2 == null) {
                        value2 = tc.defaultValue();
                        this.setField(structField, value2);
                    }
                    nativeType = tc.nativeType();
                    structField.writeConverter = tc;
                    structField.readConverter = tc;
                    structField.context = new StructureReadContext(this, field2);
                } else if (this.typeMapper != null) {
                    ToNativeConverter writeConverter = this.typeMapper.getToNativeConverter(type2);
                    FromNativeConverter readConverter = this.typeMapper.getFromNativeConverter(type2);
                    if (writeConverter != null && readConverter != null) {
                        nativeType = (value2 = writeConverter.toNative(value2, new StructureWriteContext(this, structField.field))) != null ? value2.getClass() : (class$com$sun$jna$Pointer == null ? Structure.class$("com.sun.jna.Pointer") : class$com$sun$jna$Pointer);
                        structField.writeConverter = writeConverter;
                        structField.readConverter = readConverter;
                        structField.context = new StructureReadContext(this, field2);
                    } else if (writeConverter != null || readConverter != null) {
                        String msg = "Structures require bidirectional type conversion for " + type2;
                        throw new IllegalArgumentException(msg);
                    }
                }
                try {
                    structField.size = Native.getNativeSize(nativeType, value2);
                    fieldAlignment = this.getNativeAlignment(nativeType, value2, firstField);
                }
                catch (IllegalArgumentException e) {
                    if (!force && this.typeMapper == null) {
                        return -1;
                    }
                    String msg = "Invalid Structure field in " + this.getClass() + ", field name '" + structField.name + "', " + structField.type + ": " + e.getMessage();
                    throw new IllegalArgumentException(msg);
                }
                this.structAlignment = Math.max(this.structAlignment, fieldAlignment);
                if (calculatedSize % fieldAlignment != 0) {
                    calculatedSize += fieldAlignment - calculatedSize % fieldAlignment;
                }
                structField.offset = calculatedSize;
                calculatedSize += structField.size;
                this.structFields.put(structField.name, structField);
            }
            firstField = false;
        }
        if (calculatedSize > 0) {
            int size2 = this.calculateAlignedSize(calculatedSize);
            if (this instanceof ByValue) {
                this.getTypeInfo();
            }
            if (this.memory != null && !(this.memory instanceof AutoAllocated)) {
                this.memory = this.memory.share(0L, size2);
            }
            return size2;
        }
        throw new IllegalArgumentException("Structure " + this.getClass() + " has unknown size (ensure " + "all fields are public)");
    }

    int calculateAlignedSize(int calculatedSize) {
        if (this.alignType != 1 && calculatedSize % this.structAlignment != 0) {
            calculatedSize += this.structAlignment - calculatedSize % this.structAlignment;
        }
        return calculatedSize;
    }

    protected int getStructAlignment() {
        if (this.size == -1) {
            this.calculateSize(true);
        }
        return this.structAlignment;
    }

    protected int getNativeAlignment(Class type2, Object value2, boolean isFirstElement) {
        int alignment2 = 1;
        if (NativeMapped.class.isAssignableFrom(type2)) {
            NativeMappedConverter tc = NativeMappedConverter.getInstance(type2);
            type2 = tc.nativeType();
            value2 = tc.toNative(value2, new ToNativeContext());
        }
        int size2 = Native.getNativeSize(type2, value2);
        if (type2.isPrimitive() || Long.class == type2 || Integer.class == type2 || Short.class == type2 || Character.class == type2 || Byte.class == type2 || Boolean.class == type2 || Float.class == type2 || Double.class == type2) {
            alignment2 = size2;
        } else if (Pointer.class == type2 || Buffer.class.isAssignableFrom(type2) || Callback.class.isAssignableFrom(type2) || WString.class == type2 || String.class == type2) {
            alignment2 = Pointer.SIZE;
        } else if (Structure.class.isAssignableFrom(type2)) {
            if (ByReference.class.isAssignableFrom(type2)) {
                alignment2 = Pointer.SIZE;
            } else {
                if (value2 == null) {
                    value2 = Structure.newInstance(type2);
                }
                alignment2 = ((Structure)value2).getStructAlignment();
            }
        } else if (type2.isArray()) {
            alignment2 = this.getNativeAlignment(type2.getComponentType(), null, isFirstElement);
        } else {
            throw new IllegalArgumentException("Type " + type2 + " has unknown " + "native alignment");
        }
        if (this.alignType == 1) {
            alignment2 = 1;
        } else if (this.alignType == 3) {
            alignment2 = Math.min(8, alignment2);
        } else if (!(this.alignType != 2 || isFirstElement && Platform.isMac() && isPPC)) {
            alignment2 = Math.min(MAX_GNUC_ALIGNMENT, alignment2);
        }
        return alignment2;
    }

    public String toString() {
        return this.toString(0, true);
    }

    private String format(Class type2) {
        String s2 = type2.getName();
        int dot = s2.lastIndexOf(".");
        return s2.substring(dot + 1);
    }

    private String toString(int indent, boolean showContents) {
        String LS = System.getProperty("line.separator");
        String name2 = this.format(this.getClass()) + "(" + this.getPointer() + ")";
        if (!(this.getPointer() instanceof Memory)) {
            name2 = name2 + " (" + this.size() + " bytes)";
        }
        String prefix = "";
        for (int idx = 0; idx < indent; ++idx) {
            prefix = prefix + "  ";
        }
        String contents = LS;
        if (!showContents) {
            contents = "...}";
        } else {
            Iterator i2 = this.structFields.values().iterator();
            while (i2.hasNext()) {
                StructField sf = (StructField)i2.next();
                Object value2 = this.getField(sf);
                String type2 = this.format(sf.type);
                String index2 = "";
                contents = contents + prefix;
                if (sf.type.isArray() && value2 != null) {
                    type2 = this.format(sf.type.getComponentType());
                    index2 = "[" + Array.getLength(value2) + "]";
                }
                contents = contents + "  " + type2 + " " + sf.name + index2 + "@" + Integer.toHexString(sf.offset);
                if (value2 instanceof Structure) {
                    value2 = ((Structure)value2).toString(indent + 1, !(value2 instanceof ByReference));
                }
                contents = contents + "=";
                contents = value2 instanceof Long ? contents + Long.toHexString((Long)value2) : (value2 instanceof Integer ? contents + Integer.toHexString((Integer)value2) : (value2 instanceof Short ? contents + Integer.toHexString(((Short)value2).shortValue()) : (value2 instanceof Byte ? contents + Integer.toHexString(((Byte)value2).byteValue()) : contents + String.valueOf(value2).trim())));
                contents = contents + LS;
                if (i2.hasNext()) continue;
                contents = contents + prefix + "}";
            }
        }
        if (indent == 0 && Boolean.getBoolean("jna.dump_memory")) {
            byte[] buf = this.getPointer().getByteArray(0L, this.size());
            int BYTES_PER_ROW = 4;
            contents = contents + LS + "memory dump" + LS;
            for (int i3 = 0; i3 < buf.length; ++i3) {
                if (i3 % 4 == 0) {
                    contents = contents + "[";
                }
                if (buf[i3] >= 0 && buf[i3] < 16) {
                    contents = contents + "0";
                }
                contents = contents + Integer.toHexString(buf[i3] & 0xFF);
                if (i3 % 4 != 3 || i3 >= buf.length - 1) continue;
                contents = contents + "]" + LS;
            }
            contents = contents + "]";
        }
        return name2 + " {" + contents;
    }

    public Structure[] toArray(Structure[] array) {
        this.ensureAllocated();
        if (this.memory instanceof AutoAllocated) {
            Memory m = (Memory)this.memory;
            int requiredSize = array.length * this.size();
            if (m.size() < (long)requiredSize) {
                this.useMemory(this.autoAllocate(requiredSize));
            }
        }
        array[0] = this;
        int size2 = this.size();
        for (int i2 = 1; i2 < array.length; ++i2) {
            array[i2] = Structure.newInstance(this.getClass());
            array[i2].useMemory(this.memory.share(i2 * size2, size2));
            array[i2].read();
        }
        if (!(this instanceof ByValue)) {
            this.array = array;
        }
        return array;
    }

    public Structure[] toArray(int size2) {
        return this.toArray((Structure[])Array.newInstance(this.getClass(), size2));
    }

    private Class baseClass() {
        if ((this instanceof ByReference || this instanceof ByValue) && Structure.class.isAssignableFrom(this.getClass().getSuperclass())) {
            return this.getClass().getSuperclass();
        }
        return this.getClass();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Structure)) {
            return false;
        }
        if (o.getClass() != this.getClass() && ((Structure)o).baseClass() != this.baseClass()) {
            return false;
        }
        Structure s2 = (Structure)o;
        if (s2.size() == this.size()) {
            this.clear();
            this.write();
            byte[] buf = this.getPointer().getByteArray(0L, this.size());
            s2.clear();
            s2.write();
            byte[] sbuf = s2.getPointer().getByteArray(0L, s2.size());
            return Arrays.equals(buf, sbuf);
        }
        return false;
    }

    public int hashCode() {
        this.clear();
        this.write();
        return Arrays.hashCode(this.getPointer().getByteArray(0L, this.size()));
    }

    protected void cacheTypeInfo(Pointer p2) {
        this.typeInfo = p2.peer;
    }

    Pointer getTypeInfo() {
        Pointer p2 = Structure.getTypeInfo(this);
        this.cacheTypeInfo(p2);
        return p2;
    }

    public void setAutoSynch(boolean auto) {
        this.setAutoRead(auto);
        this.setAutoWrite(auto);
    }

    public void setAutoRead(boolean auto) {
        this.autoRead = auto;
    }

    public boolean getAutoRead() {
        return this.autoRead;
    }

    public void setAutoWrite(boolean auto) {
        this.autoWrite = auto;
    }

    public boolean getAutoWrite() {
        return this.autoWrite;
    }

    static Pointer getTypeInfo(Object obj) {
        return FFIType.get(obj);
    }

    public static Structure newInstance(Class type2) throws IllegalArgumentException {
        try {
            Structure s2 = (Structure)type2.newInstance();
            if (s2 instanceof ByValue) {
                s2.allocateMemory();
            }
            return s2;
        }
        catch (InstantiationException e) {
            String msg = "Can't instantiate " + type2 + " (" + e + ")";
            throw new IllegalArgumentException(msg);
        }
        catch (IllegalAccessException e) {
            String msg = "Instantiation of " + type2 + " not allowed, is it public? (" + e + ")";
            throw new IllegalArgumentException(msg);
        }
    }

    private static void structureArrayCheck(Structure[] ss) {
        Pointer base = ss[0].getPointer();
        int size2 = ss[0].size();
        for (int si = 1; si < ss.length; ++si) {
            if (ss[si].getPointer().peer == base.peer + (long)(size2 * si)) continue;
            String msg = "Structure array elements must use contiguous memory (bad backing address at Structure array index " + si + ")";
            throw new IllegalArgumentException(msg);
        }
    }

    public static void autoRead(Structure[] ss) {
        Structure.structureArrayCheck(ss);
        if (ss[0].array == ss) {
            ss[0].autoRead();
        } else {
            for (int si = 0; si < ss.length; ++si) {
                ss[si].autoRead();
            }
        }
    }

    public void autoRead() {
        if (this.getAutoRead()) {
            this.read();
            if (this.array != null) {
                for (int i2 = 1; i2 < this.array.length; ++i2) {
                    this.array[i2].autoRead();
                }
            }
        }
    }

    public static void autoWrite(Structure[] ss) {
        Structure.structureArrayCheck(ss);
        if (ss[0].array == ss) {
            ss[0].autoWrite();
        } else {
            for (int si = 0; si < ss.length; ++si) {
                ss[si].autoWrite();
            }
        }
    }

    public void autoWrite() {
        if (this.getAutoWrite()) {
            this.write();
            if (this.array != null) {
                for (int i2 = 1; i2 < this.array.length; ++i2) {
                    this.array[i2].autoWrite();
                }
            }
        }
    }

    static {
        Field[] fields2 = MemberOrder.class.getFields();
        ArrayList<String> names2 = new ArrayList<String>();
        for (int i2 = 0; i2 < fields2.length; ++i2) {
            names2.add(fields2[i2].getName());
        }
        List<String> expected = Arrays.asList(MemberOrder.FIELDS);
        ArrayList<String> reversed = new ArrayList<String>(expected);
        Collections.reverse(reversed);
        REVERSE_FIELDS = ((Object)names2).equals(reversed);
        REQUIRES_FIELD_ORDER = !((Object)names2).equals(expected) && !REVERSE_FIELDS;
        String arch = System.getProperty("os.arch").toLowerCase();
        isPPC = "ppc".equals(arch) || "powerpc".equals(arch);
        isSPARC = "sparc".equals(arch);
        MAX_GNUC_ALIGNMENT = isSPARC ? 8 : Native.LONG_SIZE;
        reads = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return new HashMap();
            }
        };
        busy = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return new StructureSet();
            }

            class StructureSet
            extends AbstractCollection
            implements Set {
                private Structure[] elements;
                private int count;

                StructureSet() {
                }

                private void ensureCapacity(int size2) {
                    if (this.elements == null) {
                        this.elements = new Structure[size2 * 3 / 2];
                    } else if (this.elements.length < size2) {
                        Structure[] e = new Structure[size2 * 3 / 2];
                        System.arraycopy(this.elements, 0, e, 0, this.elements.length);
                        this.elements = e;
                    }
                }

                public int size() {
                    return this.count;
                }

                public boolean contains(Object o) {
                    return this.indexOf(o) != -1;
                }

                public boolean add(Object o) {
                    if (!this.contains(o)) {
                        this.ensureCapacity(this.count + 1);
                        this.elements[this.count++] = (Structure)o;
                    }
                    return true;
                }

                private int indexOf(Object o) {
                    Structure s1 = (Structure)o;
                    for (int i2 = 0; i2 < this.count; ++i2) {
                        Structure s2 = this.elements[i2];
                        if (s1 != s2 && (s1.getClass() != s2.getClass() || s1.size() != s2.size() || !s1.getPointer().equals(s2.getPointer()))) continue;
                        return i2;
                    }
                    return -1;
                }

                public boolean remove(Object o) {
                    int idx = this.indexOf(o);
                    if (idx != -1) {
                        if (--this.count > 0) {
                            this.elements[idx] = this.elements[this.count];
                            this.elements[this.count] = null;
                        }
                        return true;
                    }
                    return false;
                }

                public Iterator iterator() {
                    Structure[] e = new Structure[this.count];
                    System.arraycopy(this.elements, 0, e, 0, this.count);
                    return Arrays.asList(e).iterator();
                }
            }
        };
    }

    private class AutoAllocated
    extends Memory {
        public AutoAllocated(int size2) {
            super(size2);
            super.clear();
        }
    }

    static class FFIType
    extends Structure {
        private static Map typeInfoMap = new WeakHashMap();
        private static final int FFI_TYPE_STRUCT = 13;
        public size_t size;
        public short alignment;
        public short type = (short)13;
        public Pointer elements;

        private FFIType(Structure ref) {
            Pointer[] els;
            if (ref instanceof Union) {
                StructField sf = ((Union)ref).biggestField;
                els = new Pointer[]{FFIType.get(ref.getField(sf), sf.type), null};
            } else {
                els = new Pointer[ref.fields().size() + 1];
                int idx = 0;
                Iterator i2 = ref.fields().values().iterator();
                while (i2.hasNext()) {
                    StructField sf = (StructField)i2.next();
                    els[idx++] = FFIType.get(ref.getField(sf), sf.type);
                }
            }
            this.init(els);
        }

        private FFIType(Object array, Class type2) {
            int length2 = Array.getLength(array);
            Pointer[] els = new Pointer[length2 + 1];
            Pointer p2 = FFIType.get(null, type2.getComponentType());
            for (int i2 = 0; i2 < length2; ++i2) {
                els[i2] = p2;
            }
            this.init(els);
        }

        private void init(Pointer[] els) {
            this.elements = new Memory(Pointer.SIZE * els.length);
            this.elements.write(0L, els, 0, els.length);
            this.write();
        }

        static Pointer get(Object obj) {
            if (obj == null) {
                return FFITypes.ffi_type_pointer;
            }
            if (obj instanceof Class) {
                return FFIType.get(null, (Class)obj);
            }
            return FFIType.get(obj, obj.getClass());
        }

        private static Pointer get(Object obj, Class cls) {
            Map map = typeInfoMap;
            synchronized (map) {
                Object o = typeInfoMap.get(cls);
                if (o instanceof Pointer) {
                    return (Pointer)o;
                }
                if (o instanceof FFIType) {
                    return ((FFIType)o).getPointer();
                }
                if ((class$java$nio$Buffer == null ? (class$java$nio$Buffer = Structure.class$("java.nio.Buffer")) : class$java$nio$Buffer).isAssignableFrom(cls) || (class$com$sun$jna$Callback == null ? (class$com$sun$jna$Callback = Structure.class$("com.sun.jna.Callback")) : class$com$sun$jna$Callback).isAssignableFrom(cls)) {
                    typeInfoMap.put(cls, FFITypes.ffi_type_pointer);
                    return FFITypes.ffi_type_pointer;
                }
                if ((class$com$sun$jna$Structure == null ? (class$com$sun$jna$Structure = Structure.class$("com.sun.jna.Structure")) : class$com$sun$jna$Structure).isAssignableFrom(cls)) {
                    if (obj == null) {
                        obj = FFIType.newInstance(cls);
                    }
                    if ((class$com$sun$jna$Structure$ByReference == null ? (class$com$sun$jna$Structure$ByReference = Structure.class$("com.sun.jna.Structure$ByReference")) : class$com$sun$jna$Structure$ByReference).isAssignableFrom(cls)) {
                        typeInfoMap.put(cls, FFITypes.ffi_type_pointer);
                        return FFITypes.ffi_type_pointer;
                    }
                    FFIType type2 = new FFIType((Structure)obj);
                    typeInfoMap.put(cls, type2);
                    return type2.getPointer();
                }
                if ((class$com$sun$jna$NativeMapped == null ? (class$com$sun$jna$NativeMapped = Structure.class$("com.sun.jna.NativeMapped")) : class$com$sun$jna$NativeMapped).isAssignableFrom(cls)) {
                    NativeMappedConverter c = NativeMappedConverter.getInstance(cls);
                    return FFIType.get(c.toNative(obj, new ToNativeContext()), c.nativeType());
                }
                if (cls.isArray()) {
                    FFIType type3 = new FFIType(obj, cls);
                    typeInfoMap.put(obj, type3);
                    return type3.getPointer();
                }
                throw new IllegalArgumentException("Unsupported type " + cls);
            }
        }

        static {
            if (Native.POINTER_SIZE == 0) {
                throw new Error("Native library not initialized");
            }
            if (FFITypes.ffi_type_void == null) {
                throw new Error("FFI types not initialized");
            }
            typeInfoMap.put(Void.TYPE, FFITypes.ffi_type_void);
            typeInfoMap.put(class$java$lang$Void == null ? (class$java$lang$Void = Structure.class$("java.lang.Void")) : class$java$lang$Void, FFITypes.ffi_type_void);
            typeInfoMap.put(Float.TYPE, FFITypes.ffi_type_float);
            typeInfoMap.put(class$java$lang$Float == null ? (class$java$lang$Float = Structure.class$("java.lang.Float")) : class$java$lang$Float, FFITypes.ffi_type_float);
            typeInfoMap.put(Double.TYPE, FFITypes.ffi_type_double);
            typeInfoMap.put(class$java$lang$Double == null ? (class$java$lang$Double = Structure.class$("java.lang.Double")) : class$java$lang$Double, FFITypes.ffi_type_double);
            typeInfoMap.put(Long.TYPE, FFITypes.ffi_type_sint64);
            typeInfoMap.put(class$java$lang$Long == null ? (class$java$lang$Long = Structure.class$("java.lang.Long")) : class$java$lang$Long, FFITypes.ffi_type_sint64);
            typeInfoMap.put(Integer.TYPE, FFITypes.ffi_type_sint32);
            typeInfoMap.put(class$java$lang$Integer == null ? (class$java$lang$Integer = Structure.class$("java.lang.Integer")) : class$java$lang$Integer, FFITypes.ffi_type_sint32);
            typeInfoMap.put(Short.TYPE, FFITypes.ffi_type_sint16);
            typeInfoMap.put(class$java$lang$Short == null ? (class$java$lang$Short = Structure.class$("java.lang.Short")) : class$java$lang$Short, FFITypes.ffi_type_sint16);
            Pointer ctype = Native.WCHAR_SIZE == 2 ? FFITypes.ffi_type_uint16 : FFITypes.ffi_type_uint32;
            typeInfoMap.put(Character.TYPE, ctype);
            typeInfoMap.put(class$java$lang$Character == null ? (class$java$lang$Character = Structure.class$("java.lang.Character")) : class$java$lang$Character, ctype);
            typeInfoMap.put(Byte.TYPE, FFITypes.ffi_type_sint8);
            typeInfoMap.put(class$java$lang$Byte == null ? (class$java$lang$Byte = Structure.class$("java.lang.Byte")) : class$java$lang$Byte, FFITypes.ffi_type_sint8);
            typeInfoMap.put(Boolean.TYPE, FFITypes.ffi_type_uint32);
            typeInfoMap.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = Structure.class$("java.lang.Boolean")) : class$java$lang$Boolean, FFITypes.ffi_type_uint32);
            typeInfoMap.put(class$com$sun$jna$Pointer == null ? (class$com$sun$jna$Pointer = Structure.class$("com.sun.jna.Pointer")) : class$com$sun$jna$Pointer, FFITypes.ffi_type_pointer);
            typeInfoMap.put(class$java$lang$String == null ? (class$java$lang$String = Structure.class$("java.lang.String")) : class$java$lang$String, FFITypes.ffi_type_pointer);
            typeInfoMap.put(class$com$sun$jna$WString == null ? (class$com$sun$jna$WString = Structure.class$("com.sun.jna.WString")) : class$com$sun$jna$WString, FFITypes.ffi_type_pointer);
        }

        private static class FFITypes {
            private static Pointer ffi_type_void;
            private static Pointer ffi_type_float;
            private static Pointer ffi_type_double;
            private static Pointer ffi_type_longdouble;
            private static Pointer ffi_type_uint8;
            private static Pointer ffi_type_sint8;
            private static Pointer ffi_type_uint16;
            private static Pointer ffi_type_sint16;
            private static Pointer ffi_type_uint32;
            private static Pointer ffi_type_sint32;
            private static Pointer ffi_type_uint64;
            private static Pointer ffi_type_sint64;
            private static Pointer ffi_type_pointer;

            private FFITypes() {
            }
        }

        public static class size_t
        extends IntegerType {
            public size_t() {
                this(0L);
            }

            public size_t(long value2) {
                super(Native.POINTER_SIZE, value2);
            }
        }
    }

    class StructField {
        public String name;
        public Class type;
        public Field field;
        public int size = -1;
        public int offset = -1;
        public boolean isVolatile;
        public boolean isReadOnly;
        public FromNativeConverter readConverter;
        public ToNativeConverter writeConverter;
        public FromNativeContext context;

        StructField() {
        }
    }

    private static class MemberOrder {
        private static final String[] FIELDS = new String[]{"first", "second", "middle", "penultimate", "last"};
        public int first;
        public int second;
        public int middle;
        public int penultimate;
        public int last;

        private MemberOrder() {
        }
    }

    public static interface ByReference {
    }

    public static interface ByValue {
    }
}

