/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.datatype.xsd;

import com.thaiopensource.datatype.xsd.DatatypeBase;
import com.thaiopensource.datatype.xsd.DatatypeLibraryImpl;
import com.thaiopensource.datatype.xsd.DecimalDatatype;
import com.thaiopensource.datatype.xsd.LengthRestrictDatatype;
import com.thaiopensource.datatype.xsd.MaxExclusiveRestrictDatatype;
import com.thaiopensource.datatype.xsd.MaxInclusiveRestrictDatatype;
import com.thaiopensource.datatype.xsd.MaxLengthRestrictDatatype;
import com.thaiopensource.datatype.xsd.MinExclusiveRestrictDatatype;
import com.thaiopensource.datatype.xsd.MinInclusiveRestrictDatatype;
import com.thaiopensource.datatype.xsd.MinLengthRestrictDatatype;
import com.thaiopensource.datatype.xsd.PatternRestrictDatatype;
import com.thaiopensource.datatype.xsd.PrecisionRestrictDatatype;
import com.thaiopensource.datatype.xsd.ScaleRestrictDatatype;
import com.thaiopensource.datatype.xsd.regex.RegexSyntaxException;
import com.thaiopensource.util.Localizer;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeBuilder;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

class DatatypeBuilderImpl
implements DatatypeBuilder {
    static final Localizer localizer = new Localizer(class$com$thaiopensource$datatype$xsd$DatatypeBuilderImpl == null ? (class$com$thaiopensource$datatype$xsd$DatatypeBuilderImpl = DatatypeBuilderImpl.class$("com.thaiopensource.datatype.xsd.DatatypeBuilderImpl")) : class$com$thaiopensource$datatype$xsd$DatatypeBuilderImpl);
    private DatatypeBase base;
    private final DatatypeLibraryImpl library;
    static /* synthetic */ Class class$com$thaiopensource$datatype$xsd$DatatypeBuilderImpl;

    DatatypeBuilderImpl(DatatypeLibraryImpl datatypeLibraryImpl, DatatypeBase datatypeBase) throws DatatypeException {
        this.library = datatypeLibraryImpl;
        this.base = datatypeBase;
    }

    public void addParameter(String string2, String string3, ValidationContext validationContext) throws DatatypeException {
        if (string2.equals("pattern")) {
            this.addPatternParam(string3);
        } else if (string2.equals("minInclusive")) {
            this.addMinInclusiveParam(string3, validationContext);
        } else if (string2.equals("maxInclusive")) {
            this.addMaxInclusiveParam(string3, validationContext);
        } else if (string2.equals("minExclusive")) {
            this.addMinExclusiveParam(string3, validationContext);
        } else if (string2.equals("maxExclusive")) {
            this.addMaxExclusiveParam(string3, validationContext);
        } else if (string2.equals("length")) {
            this.addLengthParam(string3);
        } else if (string2.equals("minLength")) {
            this.addMinLengthParam(string3);
        } else if (string2.equals("maxLength")) {
            this.addMaxLengthParam(string3);
        } else if (string2.equals("fractionDigits")) {
            this.addScaleParam(string3);
        } else if (string2.equals("totalDigits")) {
            this.addPrecisionParam(string3);
        } else if (string2.equals("enumeration")) {
            DatatypeBuilderImpl.error("enumeration_param");
        } else if (string2.equals("whiteSpace")) {
            DatatypeBuilderImpl.error("whiteSpace_param");
        } else {
            DatatypeBuilderImpl.error("unrecognized_param", string2);
        }
    }

    private void addPatternParam(String string2) throws DatatypeException {
        try {
            this.base = new PatternRestrictDatatype(this.base, this.library.getRegexEngine().compile(string2));
        }
        catch (RegexSyntaxException regexSyntaxException) {
            int n = regexSyntaxException.getPosition();
            if (n == -1) {
                n = -1;
            }
            DatatypeBuilderImpl.error("invalid_regex", regexSyntaxException.getMessage(), n);
        }
    }

    private void addMinInclusiveParam(String string2, ValidationContext validationContext) throws DatatypeException {
        this.base = new MinInclusiveRestrictDatatype(this.base, this.getLimit(string2, validationContext));
    }

    private void addMaxInclusiveParam(String string2, ValidationContext validationContext) throws DatatypeException {
        this.base = new MaxInclusiveRestrictDatatype(this.base, this.getLimit(string2, validationContext));
    }

    private void addMinExclusiveParam(String string2, ValidationContext validationContext) throws DatatypeException {
        this.base = new MinExclusiveRestrictDatatype(this.base, this.getLimit(string2, validationContext));
    }

    private void addMaxExclusiveParam(String string2, ValidationContext validationContext) throws DatatypeException {
        this.base = new MaxExclusiveRestrictDatatype(this.base, this.getLimit(string2, validationContext));
    }

    private Object getLimit(String string2, ValidationContext validationContext) throws DatatypeException {
        Object object;
        if (this.base.getOrderRelation() == null) {
            DatatypeBuilderImpl.error("not_ordered");
        }
        if ((object = this.base.createValue(string2, validationContext)) == null) {
            DatatypeBuilderImpl.error("invalid_limit", string2);
        }
        return object;
    }

    private void addLengthParam(String string2) throws DatatypeException {
        this.base = new LengthRestrictDatatype(this.base, this.getLength(string2));
    }

    private void addMinLengthParam(String string2) throws DatatypeException {
        this.base = new MinLengthRestrictDatatype(this.base, this.getLength(string2));
    }

    private void addMaxLengthParam(String string2) throws DatatypeException {
        this.base = new MaxLengthRestrictDatatype(this.base, this.getLength(string2));
    }

    private int getLength(String string2) throws DatatypeException {
        int n;
        if (this.base.getMeasure() == null) {
            DatatypeBuilderImpl.error("no_length");
        }
        if ((n = this.convertNonNegativeInteger(string2)) < 0) {
            DatatypeBuilderImpl.error("value_not_non_negative_integer");
        }
        return n;
    }

    private void addScaleParam(String string2) throws DatatypeException {
        int n;
        if (!(this.base.getPrimitive() instanceof DecimalDatatype)) {
            DatatypeBuilderImpl.error("scale_not_derived_from_decimal");
        }
        if ((n = this.convertNonNegativeInteger(string2)) < 0) {
            DatatypeBuilderImpl.error("value_not_non_negative_integer");
        }
        this.base = new ScaleRestrictDatatype(this.base, n);
    }

    private void addPrecisionParam(String string2) throws DatatypeException {
        int n;
        if (!(this.base.getPrimitive() instanceof DecimalDatatype)) {
            DatatypeBuilderImpl.error("precision_not_derived_from_decimal");
        }
        if ((n = this.convertNonNegativeInteger(string2)) <= 0) {
            DatatypeBuilderImpl.error("value_not_positive_integer");
        }
        this.base = new PrecisionRestrictDatatype(this.base, n);
    }

    public Datatype createDatatype() {
        return this.base;
    }

    private static void error(String string2) throws DatatypeException {
        throw new DatatypeException(localizer.message(string2));
    }

    private static void error(String string2, String string3) throws DatatypeException {
        throw new DatatypeException(localizer.message(string2, string3));
    }

    private static void error(String string2, String string3, int n) throws DatatypeException {
        throw new DatatypeException(n, localizer.message(string2, string3));
    }

    private int convertNonNegativeInteger(String string2) {
        DecimalDatatype decimalDatatype = new DecimalDatatype();
        if (!decimalDatatype.lexicallyAllows(string2 = string2.trim())) {
            return -1;
        }
        if ((string2 = decimalDatatype.getValue(string2, null).toString()).charAt(0) == '-' || string2.indexOf(46) >= 0) {
            return -1;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.MAX_VALUE;
        }
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

