/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.AbstractPatternFunction;
import com.thaiopensource.relaxng.impl.AfterPattern;
import com.thaiopensource.relaxng.impl.ChoicePattern;
import com.thaiopensource.relaxng.impl.DataExceptPattern;
import com.thaiopensource.relaxng.impl.DataPattern;
import com.thaiopensource.relaxng.impl.GroupPattern;
import com.thaiopensource.relaxng.impl.InterleavePattern;
import com.thaiopensource.relaxng.impl.ListPattern;
import com.thaiopensource.relaxng.impl.OneOrMorePattern;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternMemo;
import com.thaiopensource.relaxng.impl.TextPattern;
import com.thaiopensource.relaxng.impl.ValidatorPatternBuilder;
import com.thaiopensource.relaxng.impl.ValuePattern;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.ValidationContext;

class DataDerivFunction
extends AbstractPatternFunction {
    private final ValidatorPatternBuilder builder;
    private final ValidationContext vc;
    private final String str;

    DataDerivFunction(String string2, ValidationContext validationContext, ValidatorPatternBuilder validatorPatternBuilder) {
        this.str = string2;
        this.vc = validationContext;
        this.builder = validatorPatternBuilder;
    }

    static boolean isBlank(String string2) {
        int n = string2.length();
        block3: for (int j = 0; j < n; ++j) {
            switch (string2.charAt(j)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public Object caseText(TextPattern textPattern) {
        return textPattern;
    }

    public Object caseList(ListPattern listPattern) {
        int n = this.str.length();
        int n2 = -1;
        PatternMemo patternMemo = this.builder.getPatternMemo(listPattern.getOperand());
        block3: for (int j = 0; j < n; ++j) {
            switch (this.str.charAt(j)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (n2 < 0) continue block3;
                    patternMemo = this.tokenDeriv(patternMemo, n2, j);
                    n2 = -1;
                    continue block3;
                }
                default: {
                    if (n2 >= 0) continue block3;
                    n2 = j;
                }
            }
        }
        if (n2 >= 0) {
            patternMemo = this.tokenDeriv(patternMemo, n2, n);
        }
        if (patternMemo.getPattern().isNullable()) {
            return this.builder.makeEmpty();
        }
        return this.builder.makeNotAllowed();
    }

    private PatternMemo tokenDeriv(PatternMemo patternMemo, int n, int n2) {
        return patternMemo.dataDeriv(this.str.substring(n, n2), this.vc);
    }

    public Object caseValue(ValuePattern valuePattern) {
        Datatype datatype = valuePattern.getDatatype();
        Object object = datatype.createValue(this.str, this.vc);
        if (object != null && datatype.sameValue(valuePattern.getValue(), object)) {
            return this.builder.makeEmpty();
        }
        return this.builder.makeNotAllowed();
    }

    public Object caseData(DataPattern dataPattern) {
        if (dataPattern.allowsAnyString()) {
            return this.builder.makeEmpty();
        }
        if (dataPattern.getDatatype().isValid(this.str, this.vc)) {
            return this.builder.makeEmpty();
        }
        return this.builder.makeNotAllowed();
    }

    public Object caseDataExcept(DataExceptPattern dataExceptPattern) {
        Pattern pattern = (Pattern)this.caseData(dataExceptPattern);
        if (pattern.isNullable() && this.memoApply(dataExceptPattern.getExcept()).isNullable()) {
            return this.builder.makeNotAllowed();
        }
        return pattern;
    }

    public Object caseAfter(AfterPattern afterPattern) {
        Pattern pattern = afterPattern.getOperand1();
        if (this.memoApply(pattern).isNullable() || pattern.isNullable() && DataDerivFunction.isBlank(this.str)) {
            return afterPattern.getOperand2();
        }
        return this.builder.makeNotAllowed();
    }

    public Object caseChoice(ChoicePattern choicePattern) {
        return this.builder.makeChoice(this.memoApply(choicePattern.getOperand1()), this.memoApply(choicePattern.getOperand2()));
    }

    public Object caseGroup(GroupPattern groupPattern) {
        Pattern pattern = groupPattern.getOperand1();
        Pattern pattern2 = groupPattern.getOperand2();
        Pattern pattern3 = this.builder.makeGroup(this.memoApply(pattern), pattern2);
        if (!pattern.isNullable()) {
            return pattern3;
        }
        return this.builder.makeChoice(pattern3, this.memoApply(pattern2));
    }

    public Object caseInterleave(InterleavePattern interleavePattern) {
        Pattern pattern = interleavePattern.getOperand1();
        Pattern pattern2 = interleavePattern.getOperand2();
        return this.builder.makeChoice(this.builder.makeInterleave(this.memoApply(pattern), pattern2), this.builder.makeInterleave(pattern, this.memoApply(pattern2)));
    }

    public Object caseOneOrMore(OneOrMorePattern oneOrMorePattern) {
        return this.builder.makeGroup(this.memoApply(oneOrMorePattern.getOperand()), this.builder.makeOptional(oneOrMorePattern));
    }

    public Object caseOther(Pattern pattern) {
        return this.builder.makeNotAllowed();
    }

    private Pattern memoApply(Pattern pattern) {
        return this.builder.getPatternMemo(pattern).dataDeriv(this.str, this.vc).getPattern();
    }
}

