/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.NameClass;
import com.thaiopensource.relaxng.impl.NameClassVisitor;
import com.thaiopensource.relaxng.impl.RestrictionViolationException;
import com.thaiopensource.relaxng.impl.SimpleNameClass;
import com.thaiopensource.xml.util.Name;

class OverlapDetector
implements NameClassVisitor {
    private final NameClass nc1;
    private final NameClass nc2;
    private Name overlapExample = null;
    private static final String IMPOSSIBLE = "\u0000";

    private OverlapDetector(NameClass nameClass, NameClass nameClass2) {
        this.nc1 = nameClass;
        this.nc2 = nameClass2;
        nameClass.accept(this);
        nameClass2.accept(this);
    }

    private void probe(Name name2) {
        if (this.nc1.contains(name2) && this.nc2.contains(name2)) {
            this.overlapExample = name2;
        }
    }

    public void visitChoice(NameClass nameClass, NameClass nameClass2) {
        nameClass.accept(this);
        nameClass2.accept(this);
    }

    public void visitNsName(String string2) {
        this.probe(new Name(string2, IMPOSSIBLE));
    }

    public void visitNsNameExcept(String string2, NameClass nameClass) {
        this.probe(new Name(string2, IMPOSSIBLE));
        nameClass.accept(this);
    }

    public void visitAnyName() {
        this.probe(new Name(IMPOSSIBLE, IMPOSSIBLE));
    }

    public void visitAnyNameExcept(NameClass nameClass) {
        this.probe(new Name(IMPOSSIBLE, IMPOSSIBLE));
        nameClass.accept(this);
    }

    public void visitName(Name name2) {
        this.probe(name2);
    }

    public void visitNull() {
    }

    public void visitError() {
    }

    static void checkOverlap(NameClass nameClass, NameClass nameClass2, String string2, String string3, String string4) throws RestrictionViolationException {
        if (nameClass2 instanceof SimpleNameClass) {
            SimpleNameClass simpleNameClass = (SimpleNameClass)nameClass2;
            if (nameClass.contains(simpleNameClass.getName())) {
                throw new RestrictionViolationException(string2, simpleNameClass.getName());
            }
        } else if (nameClass instanceof SimpleNameClass) {
            SimpleNameClass simpleNameClass = (SimpleNameClass)nameClass;
            if (nameClass2.contains(simpleNameClass.getName())) {
                throw new RestrictionViolationException(string2, simpleNameClass.getName());
            }
        } else {
            Name name2 = new OverlapDetector((NameClass)nameClass, (NameClass)nameClass2).overlapExample;
            if (name2 != null) {
                String string5 = name2.getLocalName();
                if (string5 == IMPOSSIBLE) {
                    String string6 = name2.getNamespaceUri();
                    if (string6 == IMPOSSIBLE) {
                        throw new RestrictionViolationException(string4);
                    }
                    throw new RestrictionViolationException(string3, string6);
                }
                throw new RestrictionViolationException(string2, name2);
            }
        }
    }
}

