/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.util;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;

public class Uri {
    private static String utf8 = "UTF-8";
    private static final String HEX_DIGITS = "0123456789abcdef";
    private static final String excluded = "<>\"{}|\\^`";

    public static boolean isValid(String string2) {
        return Uri.isValidPercent(string2) && Uri.isValidFragment(string2) && Uri.isValidScheme(string2);
    }

    public static String escapeDisallowedChars(String string2) {
        StringBuffer stringBuffer = null;
        int n = string2.length();
        int n2 = 0;
        while (true) {
            byte[] byArray;
            int n3 = n2;
            while (true) {
                if (n3 == n) {
                    if (n2 != 0) break;
                    return string2;
                }
                if (Uri.isExcluded(string2.charAt(n3))) break;
                ++n3;
            }
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            }
            if (n3 > n2) {
                stringBuffer.append(string2.substring(n2, n3));
                n2 = n3;
            }
            if (n3 == n) break;
            ++n3;
            while (n3 < n && Uri.isExcluded(string2.charAt(n3))) {
                ++n3;
            }
            String string3 = string2.substring(n2, n3);
            try {
                byArray = string3.getBytes(utf8);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                utf8 = "UTF8";
                try {
                    byArray = string3.getBytes(utf8);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    return string2;
                }
            }
            for (int j = 0; j < byArray.length; ++j) {
                stringBuffer.append('%');
                stringBuffer.append(HEX_DIGITS.charAt((byArray[j] & 0xFF) >> 4));
                stringBuffer.append(HEX_DIGITS.charAt(byArray[j] & 0xF));
            }
            n2 = n3;
        }
        return stringBuffer.toString();
    }

    private static boolean isExcluded(char c) {
        return c <= ' ' || c >= '\u007f' || excluded.indexOf(c) >= 0;
    }

    private static boolean isAlpha(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z';
    }

    private static boolean isHexDigit(char c) {
        return 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F' || Uri.isDigit(c);
    }

    private static boolean isDigit(char c) {
        return '0' <= c && c <= '9';
    }

    private static boolean isSchemeChar(char c) {
        return Uri.isAlpha(c) || Uri.isDigit(c) || c == '+' || c == '-' || c == '.';
    }

    private static boolean isValidPercent(String string2) {
        int n = string2.length();
        for (int j = 0; j < n; ++j) {
            if (string2.charAt(j) != '%') continue;
            if (j + 2 >= n) {
                return false;
            }
            if (Uri.isHexDigit(string2.charAt(j + 1)) && Uri.isHexDigit(string2.charAt(j + 2))) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidFragment(String string2) {
        int n = string2.indexOf(35);
        return n < 0 || string2.indexOf(35, n + 1) < 0;
    }

    private static boolean isValidScheme(String string2) {
        if (!Uri.isAbsolute(string2)) {
            return true;
        }
        int n = string2.indexOf(58);
        if (n == 0 || n + 1 == string2.length() || !Uri.isAlpha(string2.charAt(0))) {
            return false;
        }
        while (--n > 0) {
            if (Uri.isSchemeChar(string2.charAt(n))) continue;
            return false;
        }
        return true;
    }

    public static String resolve(String string2, String string3) {
        if (!Uri.isAbsolute(string3) && string2 != null && Uri.isAbsolute(string2)) {
            try {
                return new URL(new URL(string2), string3).toString();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return string3;
    }

    public static boolean hasFragmentId(String string2) {
        return string2.indexOf(35) >= 0;
    }

    public static boolean isAbsolute(String string2) {
        int n = string2.indexOf(58);
        if (n < 0) {
            return false;
        }
        while (--n >= 0) {
            switch (string2.charAt(n)) {
                case '#': 
                case '/': 
                case '?': {
                    return false;
                }
            }
        }
        return true;
    }
}

