/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.picl;

import com.thaiopensource.util.Localizer;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.validate.picl.Constraint;
import com.thaiopensource.validate.picl.ErrorContext;
import com.thaiopensource.validate.picl.Path;
import com.thaiopensource.validate.picl.Pattern;
import com.thaiopensource.validate.picl.PatternManager;
import com.thaiopensource.validate.picl.SelectionHandler;
import com.thaiopensource.validate.picl.ValueHandler;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.LocatorImpl;

class ValidatorImpl
extends DefaultHandler
implements Validator,
Path,
PatternManager,
ErrorContext {
    private final Constraint constraint;
    private final Stack openElements = new Stack();
    private final Stack valueHandlers = new Stack();
    private final Stack activePatterns = new Stack();
    private final AttributePath attributePath = new AttributePath();
    private Locator locator;
    private final ErrorHandler eh;
    private final Localizer localizer = new Localizer(class$com$thaiopensource$validate$picl$ValidatorImpl == null ? (class$com$thaiopensource$validate$picl$ValidatorImpl = ValidatorImpl.class$("com.thaiopensource.validate.picl.ValidatorImpl")) : class$com$thaiopensource$validate$picl$ValidatorImpl);
    static /* synthetic */ Class class$com$thaiopensource$validate$picl$ValidatorImpl;

    ValidatorImpl(Constraint constraint, PropertyMap propertyMap) {
        this.constraint = constraint;
        this.eh = ValidateProperty.ERROR_HANDLER.get(propertyMap);
    }

    public ContentHandler getContentHandler() {
        return this;
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void reset() {
        this.openElements.setSize(0);
        this.valueHandlers.setSize(0);
        this.activePatterns.setSize(0);
        this.locator = null;
    }

    public int length() {
        return this.openElements.size();
    }

    public String getLocalName(int n) {
        return ((OpenElement)this.openElements.elementAt((int)n)).localName;
    }

    public String getNamespaceUri(int n) {
        return ((OpenElement)this.openElements.elementAt((int)n)).namespaceUri;
    }

    public boolean isAttribute() {
        return false;
    }

    public void registerPattern(Pattern pattern, SelectionHandler selectionHandler) {
        this.activePatterns.push(new ActivePattern(this.openElements.size(), pattern, selectionHandler));
        ++((OpenElement)this.openElements.peek()).nActivePatterns;
    }

    public void registerValueHandler(ValueHandler valueHandler) {
        this.valueHandlers.push(valueHandler);
        ++((OpenElement)this.openElements.peek()).nValueHandlers;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
        if (this.locator == null) {
            LocatorImpl locatorImpl = new LocatorImpl();
            locatorImpl.setLineNumber(-1);
            locatorImpl.setColumnNumber(-1);
            this.locator = locatorImpl;
        }
        this.openElements.push(new OpenElement("", "#root"));
        try {
            this.constraint.activate(this);
        }
        catch (WrappedSAXException wrappedSAXException) {
            throw wrappedSAXException.exception;
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.popOpenElement();
        }
        catch (WrappedSAXException wrappedSAXException) {
            throw wrappedSAXException.exception;
        }
    }

    public void startElement(String string2, String string3, String string4, Attributes attributes) throws SAXException {
        try {
            int n;
            this.openElements.push(new OpenElement(string2, string3));
            int n2 = this.valueHandlers.size();
            for (n = 0; n < n2; ++n) {
                ((ValueHandler)this.valueHandlers.elementAt(n)).tag(this);
            }
            n2 = this.activePatterns.size();
            for (n = 0; n < n2; ++n) {
                ActivePattern activePattern = (ActivePattern)this.activePatterns.elementAt(n);
                if (!activePattern.pattern.matches(this, activePattern.rootDepth)) continue;
                activePattern.handler.selectElement(this, this, this);
            }
            n = this.activePatterns.size();
            int n3 = attributes.getLength();
            for (n2 = 0; n2 < n3; ++n2) {
                this.attributePath.set(attributes, n2);
                for (int j = 0; j < n; ++j) {
                    ActivePattern activePattern = (ActivePattern)this.activePatterns.elementAt(j);
                    if (!activePattern.pattern.matches(this.attributePath, activePattern.rootDepth)) continue;
                    activePattern.handler.selectAttribute(this, this.attributePath, attributes.getValue(n2));
                }
            }
        }
        catch (WrappedSAXException wrappedSAXException) {
            throw wrappedSAXException.exception;
        }
    }

    public void endElement(String string2, String string3, String string4) throws SAXException {
        try {
            this.popOpenElement();
        }
        catch (WrappedSAXException wrappedSAXException) {
            throw wrappedSAXException.exception;
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            int n3 = this.valueHandlers.size();
            for (int j = 0; j < n3; ++j) {
                ((ValueHandler)this.valueHandlers.elementAt(j)).characters(this, cArray, n, n2);
            }
        }
        catch (WrappedSAXException wrappedSAXException) {
            throw wrappedSAXException.exception;
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
    }

    private void popOpenElement() {
        Object object;
        int n;
        OpenElement openElement = (OpenElement)this.openElements.pop();
        for (n = 0; n < openElement.nValueHandlers; ++n) {
            object = (ValueHandler)this.valueHandlers.pop();
            object.valueComplete(this);
        }
        for (n = 0; n < openElement.nActivePatterns; ++n) {
            object = (ActivePattern)this.activePatterns.pop();
            ((ActivePattern)object).handler.selectComplete(this);
        }
    }

    public void error(Locator locator, String string2) {
        if (locator == null) {
            locator = this.locator;
        }
        try {
            this.eh.error(new SAXParseException(this.localizer.message(string2), locator));
        }
        catch (SAXException sAXException) {
            throw new WrappedSAXException(sAXException);
        }
    }

    public void error(Locator locator, String string2, String string3) {
        if (locator == null) {
            locator = this.locator;
        }
        try {
            this.eh.error(new SAXParseException(this.localizer.message(string2, string3), locator));
        }
        catch (SAXException sAXException) {
            throw new WrappedSAXException(sAXException);
        }
    }

    public Locator saveLocator() {
        return new LocatorImpl(this.locator);
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class AttributePath
    implements Path {
        private Attributes atts;
        private int attIndex;

        AttributePath() {
        }

        void set(Attributes attributes, int n) {
            this.atts = attributes;
            this.attIndex = n;
        }

        public boolean isAttribute() {
            return true;
        }

        public int length() {
            return ValidatorImpl.this.length() + 1;
        }

        public String getLocalName(int n) {
            if (n == ValidatorImpl.this.openElements.size()) {
                return this.atts.getLocalName(this.attIndex);
            }
            return ValidatorImpl.this.getLocalName(n);
        }

        public String getNamespaceUri(int n) {
            if (n == ValidatorImpl.this.openElements.size()) {
                return this.atts.getURI(this.attIndex);
            }
            return ValidatorImpl.this.getNamespaceUri(n);
        }
    }

    static class OpenElement {
        final String namespaceUri;
        final String localName;
        int nActivePatterns;
        int nValueHandlers;

        OpenElement(String string2, String string3) {
            this.namespaceUri = string2;
            this.localName = string3;
        }
    }

    static class ActivePattern {
        final int rootDepth;
        final Pattern pattern;
        final SelectionHandler handler;

        ActivePattern(int n, Pattern pattern, SelectionHandler selectionHandler) {
            this.rootDepth = n;
            this.pattern = pattern;
            this.handler = selectionHandler;
        }
    }

    private static class WrappedSAXException
    extends RuntimeException {
        final SAXException exception;

        WrappedSAXException(SAXException sAXException) {
            this.exception = sAXException;
        }
    }
}

