/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.xml.out;

import com.thaiopensource.util.Utf16;
import com.thaiopensource.xml.out.CharRepertoire;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.Writer;

public class XmlWriter {
    private static final String indentString = "  ";
    private final Writer writer;
    private final CharRepertoire cr;
    private static final int OTHER = 0;
    private static final int IN_START_TAG = 1;
    private static final int AFTER_DATA = 2;
    private int state = 0;
    private String[] stack = new String[20];
    private int level = 0;
    private String newline = "\n";

    public XmlWriter(Writer writer, CharRepertoire charRepertoire) {
        this.writer = writer;
        this.cr = charRepertoire;
    }

    public void setNewline(String string2) {
        this.newline = string2;
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void writeXmlDecl(String string2) throws IOException {
        this.writer.write("<?xml version=\"1.0\" encoding=\"");
        this.writer.write(string2);
        this.writer.write("\"?>");
        this.writer.write(this.newline);
    }

    public void startElement(String string2) throws IOException {
        switch (this.state) {
            case 1: {
                this.writer.write(62);
                this.writer.write(this.newline);
                this.indent();
                break;
            }
            case 0: {
                this.indent();
            }
            case 2: {
                this.state = 1;
            }
        }
        this.writer.write(60);
        this.outputMarkup(string2);
        this.push(string2);
    }

    public void endElement() throws IOException {
        String string2 = this.pop();
        switch (this.state) {
            case 1: {
                this.writer.write("/>");
                break;
            }
            case 0: {
                this.indent();
            }
            case 2: {
                this.writer.write("</");
                this.outputMarkup(string2);
                this.writer.write(62);
            }
        }
        this.writer.write(this.newline);
        this.state = 0;
    }

    public void attribute(String string2, String string3) throws IOException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        this.writer.write(32);
        this.outputMarkup(string2);
        this.writer.write(61);
        this.writer.write(34);
        this.outputData(string3, true, false);
        this.writer.write(34);
    }

    public void characters(String string2) throws IOException {
        this.characters(string2, false);
    }

    public void characters(String string2, boolean bl) throws IOException {
        if (this.state == 1) {
            this.writer.write(62);
        }
        this.state = 2;
        this.outputData(string2, false, bl);
    }

    public void comment(String string2) throws IOException {
        if (this.state == 1) {
            this.writer.write(62);
            this.state = 0;
            this.writer.write(this.newline);
        }
        this.writer.write("<!--");
        this.outputMarkup(string2);
        this.writer.write("-->");
        if (this.state != 2) {
            this.writer.write(this.newline);
        }
    }

    public void processingInstruction(String string2, String string3) throws IOException {
        if (this.state == 1) {
            this.writer.write(62);
            this.state = 0;
            this.writer.write(this.newline);
        }
        this.writer.write("<?");
        this.outputMarkup(string2);
        if (string3.length() != 0) {
            this.writer.write(32);
            this.outputMarkup(string3);
        }
        this.writer.write("?>");
        if (this.state != 2) {
            this.writer.write(this.newline);
        }
    }

    private void outputMarkup(String string2) throws IOException {
        int n = string2.length();
        for (int j = 0; j < n; ++j) {
            char c = string2.charAt(j);
            if (Utf16.isSurrogate1(c)) {
                if (j == n || !Utf16.isSurrogate2(string2.charAt(j))) {
                    throw new CharConversionException("surrogate pair integrity failure");
                }
                if (this.cr.contains(c, string2.charAt(j))) continue;
                throw new CharConversionException();
            }
            if (this.cr.contains(c)) continue;
            throw new CharConversionException();
        }
        this.outputLines(string2);
    }

    private void outputLines(String string2) throws IOException {
        while (string2.length() > 0) {
            int n = string2.indexOf(10);
            if (n < 0) {
                this.writer.write(string2);
                break;
            }
            if (n > 0) {
                this.writer.write(string2.substring(0, n));
            }
            this.writer.write(this.newline);
            string2 = string2.substring(n + 1);
        }
    }

    private void outputData(String string2, boolean bl, boolean bl2) throws IOException {
        int n = string2.length();
        block9: for (int j = 0; j < n; ++j) {
            char c = string2.charAt(j);
            switch (c) {
                case '<': {
                    this.writer.write("&lt;");
                    continue block9;
                }
                case '>': {
                    this.writer.write("&gt;");
                    continue block9;
                }
                case '&': {
                    this.writer.write("&amp;");
                    continue block9;
                }
                case '\"': {
                    this.writer.write("&quot;");
                    continue block9;
                }
                case '\r': {
                    this.writer.write("&#xD;");
                    continue block9;
                }
                case '\t': {
                    if (bl) {
                        this.writer.write("&#x9;");
                        continue block9;
                    }
                    this.writer.write(9);
                    continue block9;
                }
                case '\n': {
                    if (bl) {
                        this.writer.write("&#xA;");
                        continue block9;
                    }
                    this.writer.write(this.newline);
                    continue block9;
                }
                default: {
                    if (Utf16.isSurrogate1(c)) {
                        if (++j < n) {
                            char c2 = string2.charAt(j);
                            if (Utf16.isSurrogate2(c)) {
                                this.charRef(Utf16.scalarValue(c, c2));
                                continue block9;
                            }
                        }
                        throw new CharConversionException("surrogate pair integrity failure");
                    }
                    if (this.cr.contains(c) && !bl2) {
                        this.writer.write(c);
                        continue block9;
                    }
                    this.charRef(c);
                }
            }
        }
    }

    private void charRef(int n) throws IOException {
        this.writer.write("&#x");
        int n2 = n > 65535 ? 6 : 4;
        for (int j = 0; j < n2; ++j) {
            this.writer.write("0123456789ABCDEF".charAt(n >> 4 * (n2 - 1 - j) & 0xF));
        }
        this.writer.write(";");
    }

    private void indent() throws IOException {
        for (int j = 0; j < this.level; ++j) {
            this.writer.write(indentString);
        }
    }

    private final void push(String string2) {
        if (this.level == this.stack.length) {
            String[] stringArray = this.stack;
            this.stack = new String[this.stack.length * 2];
            System.arraycopy(stringArray, 0, this.stack, 0, stringArray.length);
        }
        this.stack[this.level++] = string2;
    }

    private final String pop() {
        return this.stack[--this.level];
    }
}

