/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.Polygon;

public class CentroidArea {
    private Coordinate basePt = null;
    private Coordinate triangleCent3 = new Coordinate();
    private double areasum2 = 0.0;
    private Coordinate cg3 = new Coordinate();
    private Coordinate centSum = new Coordinate();
    private double totalLength = 0.0;

    public void add(Geometry geom) {
        if (geom instanceof Polygon) {
            Polygon poly = (Polygon)geom;
            this.setBasePoint(poly.getExteriorRing().getCoordinateN(0));
            this.add(poly);
        } else if (geom instanceof GeometryCollection) {
            GeometryCollection gc2 = (GeometryCollection)geom;
            for (int i2 = 0; i2 < gc2.getNumGeometries(); ++i2) {
                this.add(gc2.getGeometryN(i2));
            }
        }
    }

    public void add(Coordinate[] ring) {
        this.setBasePoint(ring[0]);
        this.addShell(ring);
    }

    public Coordinate getCentroid() {
        Coordinate cent = new Coordinate();
        if (Math.abs(this.areasum2) > 0.0) {
            cent.x = this.cg3.x / 3.0 / this.areasum2;
            cent.y = this.cg3.y / 3.0 / this.areasum2;
        } else {
            cent.x = this.centSum.x / this.totalLength;
            cent.y = this.centSum.y / this.totalLength;
        }
        return cent;
    }

    private void setBasePoint(Coordinate basePt) {
        if (this.basePt == null) {
            this.basePt = basePt;
        }
    }

    private void add(Polygon poly) {
        this.addShell(poly.getExteriorRing().getCoordinates());
        for (int i2 = 0; i2 < poly.getNumInteriorRing(); ++i2) {
            this.addHole(poly.getInteriorRingN(i2).getCoordinates());
        }
    }

    private void addShell(Coordinate[] pts) {
        boolean isPositiveArea = !CGAlgorithms.isCCW(pts);
        for (int i2 = 0; i2 < pts.length - 1; ++i2) {
            this.addTriangle(this.basePt, pts[i2], pts[i2 + 1], isPositiveArea);
        }
        this.addLinearSegments(pts);
    }

    private void addHole(Coordinate[] pts) {
        boolean isPositiveArea = CGAlgorithms.isCCW(pts);
        for (int i2 = 0; i2 < pts.length - 1; ++i2) {
            this.addTriangle(this.basePt, pts[i2], pts[i2 + 1], isPositiveArea);
        }
        this.addLinearSegments(pts);
    }

    private void addTriangle(Coordinate p0, Coordinate p1, Coordinate p2, boolean isPositiveArea) {
        double sign2 = isPositiveArea ? 1.0 : -1.0;
        CentroidArea.centroid3(p0, p1, p2, this.triangleCent3);
        double area2 = CentroidArea.area2(p0, p1, p2);
        this.cg3.x += sign2 * area2 * this.triangleCent3.x;
        this.cg3.y += sign2 * area2 * this.triangleCent3.y;
        this.areasum2 += sign2 * area2;
    }

    private static void centroid3(Coordinate p1, Coordinate p2, Coordinate p3, Coordinate c) {
        c.x = p1.x + p2.x + p3.x;
        c.y = p1.y + p2.y + p3.y;
    }

    private static double area2(Coordinate p1, Coordinate p2, Coordinate p3) {
        return (p2.x - p1.x) * (p3.y - p1.y) - (p3.x - p1.x) * (p2.y - p1.y);
    }

    private void addLinearSegments(Coordinate[] pts) {
        for (int i2 = 0; i2 < pts.length - 1; ++i2) {
            double segmentLen = pts[i2].distance(pts[i2 + 1]);
            this.totalLength += segmentLen;
            double midx = (pts[i2].x + pts[i2 + 1].x) / 2.0;
            this.centSum.x += segmentLen * midx;
            double midy = (pts[i2].y + pts[i2 + 1].y) / 2.0;
            this.centSum.y += segmentLen * midy;
        }
    }
}

