/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.PointInRing;
import com.vividsolutions.jts.algorithm.RobustDeterminant;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.index.bintree.Bintree;
import com.vividsolutions.jts.index.bintree.Interval;
import com.vividsolutions.jts.index.chain.MonotoneChain;
import com.vividsolutions.jts.index.chain.MonotoneChainBuilder;
import com.vividsolutions.jts.index.chain.MonotoneChainSelectAction;
import java.util.List;

public class MCPointInRing
implements PointInRing {
    private LinearRing ring;
    private Bintree tree;
    private int crossings = 0;
    private Interval interval = new Interval();

    public MCPointInRing(LinearRing ring) {
        this.ring = ring;
        this.buildIndex();
    }

    private void buildIndex() {
        this.tree = new Bintree();
        Coordinate[] pts = CoordinateArrays.removeRepeatedPoints(this.ring.getCoordinates());
        List mcList = MonotoneChainBuilder.getChains(pts);
        for (int i2 = 0; i2 < mcList.size(); ++i2) {
            MonotoneChain mc = (MonotoneChain)mcList.get(i2);
            Envelope mcEnv = mc.getEnvelope();
            this.interval.min = mcEnv.getMinY();
            this.interval.max = mcEnv.getMaxY();
            this.tree.insert(this.interval, mc);
        }
    }

    public boolean isInside(Coordinate pt) {
        this.crossings = 0;
        Envelope rayEnv = new Envelope(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, pt.y, pt.y);
        this.interval.min = pt.y;
        this.interval.max = pt.y;
        List segs = this.tree.query(this.interval);
        MCSelecter mcSelecter = new MCSelecter(pt);
        for (MonotoneChain mc : segs) {
            this.testMonotoneChain(rayEnv, mcSelecter, mc);
        }
        return this.crossings % 2 == 1;
    }

    private void testMonotoneChain(Envelope rayEnv, MCSelecter mcSelecter, MonotoneChain mc) {
        mc.select(rayEnv, mcSelecter);
    }

    private void testLineSegment(Coordinate p2, LineSegment seg) {
        double xInt;
        Coordinate p1 = seg.p0;
        Coordinate p22 = seg.p1;
        double x1 = p1.x - p2.x;
        double y1 = p1.y - p2.y;
        double x2 = p22.x - p2.x;
        double y2 = p22.y - p2.y;
        if ((y1 > 0.0 && y2 <= 0.0 || y2 > 0.0 && y1 <= 0.0) && 0.0 < (xInt = (double)RobustDeterminant.signOfDet2x2(x1, y1, x2, y2) / (y2 - y1))) {
            ++this.crossings;
        }
    }

    class MCSelecter
    extends MonotoneChainSelectAction {
        Coordinate p;

        public MCSelecter(Coordinate p2) {
            this.p = p2;
        }

        public void select(LineSegment ls) {
            MCPointInRing.this.testLineSegment(this.p, ls);
        }
    }
}

