/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;

public class CoordinateSequences {
    public static void reverse(CoordinateSequence seq) {
        int last2 = seq.size() - 1;
        int mid = last2 / 2;
        for (int i2 = 0; i2 <= mid; ++i2) {
            CoordinateSequences.swap(seq, i2, last2 - i2);
        }
    }

    public static void swap(CoordinateSequence seq, int i2, int j) {
        if (i2 == j) {
            return;
        }
        for (int dim = 0; dim < seq.getDimension(); ++dim) {
            double tmp = seq.getOrdinate(i2, dim);
            seq.setOrdinate(i2, dim, seq.getOrdinate(j, dim));
            seq.setOrdinate(j, dim, tmp);
        }
    }

    public static void copy(CoordinateSequence src, int srcPos, CoordinateSequence dest, int destPos, int length2) {
        for (int i2 = 0; i2 < length2; ++i2) {
            CoordinateSequences.copyCoord(src, srcPos + i2, dest, destPos + i2);
        }
    }

    public static void copyCoord(CoordinateSequence src, int srcPos, CoordinateSequence dest, int destPos) {
        for (int dim = 0; dim < src.getDimension(); ++dim) {
            dest.setOrdinate(destPos, dim, src.getOrdinate(srcPos, dim));
        }
    }

    public static boolean isRing(CoordinateSequence seq) {
        int n = seq.size();
        if (n == 0) {
            return true;
        }
        if (n <= 3) {
            return false;
        }
        return seq.getOrdinate(0, 0) == seq.getOrdinate(n - 1, 0) && seq.getOrdinate(0, 1) == seq.getOrdinate(n - 1, 1);
    }

    public static CoordinateSequence ensureValidRing(CoordinateSequenceFactory fact, CoordinateSequence seq) {
        boolean isClosed;
        int n = seq.size();
        if (n == 0) {
            return seq;
        }
        if (n <= 3) {
            return CoordinateSequences.createClosedRing(fact, seq, 4);
        }
        boolean bl = isClosed = seq.getOrdinate(0, 0) == seq.getOrdinate(n - 1, 0) && seq.getOrdinate(0, 1) == seq.getOrdinate(n - 1, 1);
        if (isClosed) {
            return seq;
        }
        return CoordinateSequences.createClosedRing(fact, seq, n + 1);
    }

    private static CoordinateSequence createClosedRing(CoordinateSequenceFactory fact, CoordinateSequence seq, int size2) {
        CoordinateSequence newseq = fact.create(size2, seq.getDimension());
        int n = seq.size();
        CoordinateSequences.copy(seq, 0, newseq, 0, n);
        for (int i2 = n; i2 < size2; ++i2) {
            CoordinateSequences.copy(seq, 0, newseq, i2, 1);
        }
        return newseq;
    }
}

