/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.impl;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import java.io.Serializable;

public class CoordinateArraySequence
implements CoordinateSequence,
Serializable {
    private static final long serialVersionUID = -915438501601840650L;
    private Coordinate[] coordinates;

    public CoordinateArraySequence(Coordinate[] coordinates) {
        this.coordinates = coordinates;
        if (coordinates == null) {
            this.coordinates = new Coordinate[0];
        }
    }

    public CoordinateArraySequence(int size2) {
        this.coordinates = new Coordinate[size2];
        for (int i2 = 0; i2 < size2; ++i2) {
            this.coordinates[i2] = new Coordinate();
        }
    }

    public CoordinateArraySequence(CoordinateSequence coordSeq) {
        this.coordinates = coordSeq != null ? new Coordinate[coordSeq.size()] : new Coordinate[0];
        for (int i2 = 0; i2 < this.coordinates.length; ++i2) {
            this.coordinates[i2] = coordSeq.getCoordinateCopy(i2);
        }
    }

    public int getDimension() {
        return 3;
    }

    public Coordinate getCoordinate(int i2) {
        return this.coordinates[i2];
    }

    public Coordinate getCoordinateCopy(int i2) {
        return new Coordinate(this.coordinates[i2]);
    }

    public void getCoordinate(int index2, Coordinate coord) {
        coord.x = this.coordinates[index2].x;
        coord.y = this.coordinates[index2].y;
        coord.z = this.coordinates[index2].z;
    }

    public double getX(int index2) {
        return this.coordinates[index2].x;
    }

    public double getY(int index2) {
        return this.coordinates[index2].y;
    }

    public double getOrdinate(int index2, int ordinateIndex) {
        switch (ordinateIndex) {
            case 0: {
                return this.coordinates[index2].x;
            }
            case 1: {
                return this.coordinates[index2].y;
            }
            case 2: {
                return this.coordinates[index2].z;
            }
        }
        return Double.NaN;
    }

    public Object clone() {
        Coordinate[] cloneCoordinates = new Coordinate[this.size()];
        for (int i2 = 0; i2 < this.coordinates.length; ++i2) {
            cloneCoordinates[i2] = (Coordinate)this.coordinates[i2].clone();
        }
        return new CoordinateArraySequence(cloneCoordinates);
    }

    public int size() {
        return this.coordinates.length;
    }

    public void setOrdinate(int index2, int ordinateIndex, double value2) {
        switch (ordinateIndex) {
            case 0: {
                this.coordinates[index2].x = value2;
                break;
            }
            case 1: {
                this.coordinates[index2].y = value2;
                break;
            }
            case 2: {
                this.coordinates[index2].z = value2;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid ordinateIndex");
            }
        }
    }

    public Coordinate[] toCoordinateArray() {
        return this.coordinates;
    }

    public Envelope expandEnvelope(Envelope env) {
        for (int i2 = 0; i2 < this.coordinates.length; ++i2) {
            env.expandToInclude(this.coordinates[i2]);
        }
        return env;
    }

    public String toString() {
        if (this.coordinates.length > 0) {
            StringBuffer strBuf = new StringBuffer(17 * this.coordinates.length);
            strBuf.append('(');
            strBuf.append(this.coordinates[0]);
            for (int i2 = 1; i2 < this.coordinates.length; ++i2) {
                strBuf.append(", ");
                strBuf.append(this.coordinates[i2]);
            }
            strBuf.append(')');
            return strBuf.toString();
        }
        return "()";
    }
}

