/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeEnd;
import com.vividsolutions.jts.geomgraph.EdgeRing;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.Position;
import java.io.PrintStream;

public class DirectedEdge
extends EdgeEnd {
    protected boolean isForward;
    private boolean isInResult = false;
    private boolean isVisited = false;
    private DirectedEdge sym;
    private DirectedEdge next;
    private DirectedEdge nextMin;
    private EdgeRing edgeRing;
    private EdgeRing minEdgeRing;
    private int[] depth = new int[]{0, -999, -999};

    public static int depthFactor(int currLocation, int nextLocation) {
        if (currLocation == 2 && nextLocation == 0) {
            return 1;
        }
        if (currLocation == 0 && nextLocation == 2) {
            return -1;
        }
        return 0;
    }

    public DirectedEdge(Edge edge, boolean isForward) {
        super(edge);
        this.isForward = isForward;
        if (isForward) {
            this.init(edge.getCoordinate(0), edge.getCoordinate(1));
        } else {
            int n = edge.getNumPoints() - 1;
            this.init(edge.getCoordinate(n), edge.getCoordinate(n - 1));
        }
        this.computeDirectedLabel();
    }

    public Edge getEdge() {
        return this.edge;
    }

    public void setInResult(boolean isInResult) {
        this.isInResult = isInResult;
    }

    public boolean isInResult() {
        return this.isInResult;
    }

    public boolean isVisited() {
        return this.isVisited;
    }

    public void setVisited(boolean isVisited) {
        this.isVisited = isVisited;
    }

    public void setEdgeRing(EdgeRing edgeRing) {
        this.edgeRing = edgeRing;
    }

    public EdgeRing getEdgeRing() {
        return this.edgeRing;
    }

    public void setMinEdgeRing(EdgeRing minEdgeRing) {
        this.minEdgeRing = minEdgeRing;
    }

    public EdgeRing getMinEdgeRing() {
        return this.minEdgeRing;
    }

    public int getDepth(int position) {
        return this.depth[position];
    }

    public void setDepth(int position, int depthVal) {
        if (this.depth[position] != -999 && this.depth[position] != depthVal) {
            throw new TopologyException("assigned depths do not match", this.getCoordinate());
        }
        this.depth[position] = depthVal;
    }

    public int getDepthDelta() {
        int depthDelta = this.edge.getDepthDelta();
        if (!this.isForward) {
            depthDelta = -depthDelta;
        }
        return depthDelta;
    }

    public void setVisitedEdge(boolean isVisited) {
        this.setVisited(isVisited);
        this.sym.setVisited(isVisited);
    }

    public DirectedEdge getSym() {
        return this.sym;
    }

    public boolean isForward() {
        return this.isForward;
    }

    public void setSym(DirectedEdge de) {
        this.sym = de;
    }

    public DirectedEdge getNext() {
        return this.next;
    }

    public void setNext(DirectedEdge next) {
        this.next = next;
    }

    public DirectedEdge getNextMin() {
        return this.nextMin;
    }

    public void setNextMin(DirectedEdge nextMin) {
        this.nextMin = nextMin;
    }

    public boolean isLineEdge() {
        boolean isLine = this.label.isLine(0) || this.label.isLine(1);
        boolean isExteriorIfArea0 = !this.label.isArea(0) || this.label.allPositionsEqual(0, 2);
        boolean isExteriorIfArea1 = !this.label.isArea(1) || this.label.allPositionsEqual(1, 2);
        return isLine && isExteriorIfArea0 && isExteriorIfArea1;
    }

    public boolean isInteriorAreaEdge() {
        boolean isInteriorAreaEdge = true;
        for (int i2 = 0; i2 < 2; ++i2) {
            if (this.label.isArea(i2) && this.label.getLocation(i2, 1) == 0 && this.label.getLocation(i2, 2) == 0) continue;
            isInteriorAreaEdge = false;
        }
        return isInteriorAreaEdge;
    }

    private void computeDirectedLabel() {
        this.label = new Label(this.edge.getLabel());
        if (!this.isForward) {
            this.label.flip();
        }
    }

    public void setEdgeDepths(int position, int depth) {
        int depthDelta = this.getEdge().getDepthDelta();
        if (!this.isForward) {
            depthDelta = -depthDelta;
        }
        int directionFactor = 1;
        if (position == 1) {
            directionFactor = -1;
        }
        int oppositePos = Position.opposite(position);
        int delta = depthDelta * directionFactor;
        int oppositeDepth = depth + delta;
        this.setDepth(position, depth);
        this.setDepth(oppositePos, oppositeDepth);
    }

    public void print(PrintStream out) {
        super.print(out);
        out.print(" " + this.depth[1] + "/" + this.depth[2]);
        out.print(" (" + this.getDepthDelta() + ")");
        if (this.isInResult) {
            out.print(" inResult");
        }
    }

    public void printEdge(PrintStream out) {
        this.print(out);
        out.print(" ");
        if (this.isForward) {
            this.edge.print(out);
        } else {
            this.edge.printReverse(out);
        }
    }
}

