/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph.index;

import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.index.EdgeSetIntersector;
import com.vividsolutions.jts.geomgraph.index.MonotoneChain;
import com.vividsolutions.jts.geomgraph.index.MonotoneChainEdge;
import com.vividsolutions.jts.geomgraph.index.SegmentIntersector;
import com.vividsolutions.jts.geomgraph.index.SweepLineEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SimpleMCSweepLineIntersector
extends EdgeSetIntersector {
    List events = new ArrayList();
    int nOverlaps;

    public void computeIntersections(List edges, SegmentIntersector si, boolean testAllSegments) {
        if (testAllSegments) {
            this.add(edges, null);
        } else {
            this.add(edges);
        }
        this.computeIntersections(si);
    }

    public void computeIntersections(List edges0, List edges1, SegmentIntersector si) {
        this.add(edges0, (Object)edges0);
        this.add(edges1, (Object)edges1);
        this.computeIntersections(si);
    }

    private void add(List edges) {
        for (Edge edge : edges) {
            this.add(edge, (Object)edge);
        }
    }

    private void add(List edges, Object edgeSet) {
        for (Edge edge : edges) {
            this.add(edge, edgeSet);
        }
    }

    private void add(Edge edge, Object edgeSet) {
        MonotoneChainEdge mce = edge.getMonotoneChainEdge();
        int[] startIndex = mce.getStartIndexes();
        for (int i2 = 0; i2 < startIndex.length - 1; ++i2) {
            MonotoneChain mc = new MonotoneChain(mce, i2);
            SweepLineEvent insertEvent = new SweepLineEvent(edgeSet, mce.getMinX(i2), null, mc);
            this.events.add(insertEvent);
            this.events.add(new SweepLineEvent(edgeSet, mce.getMaxX(i2), insertEvent, mc));
        }
    }

    private void prepareEvents() {
        Collections.sort(this.events);
        for (int i2 = 0; i2 < this.events.size(); ++i2) {
            SweepLineEvent ev = (SweepLineEvent)this.events.get(i2);
            if (!ev.isDelete()) continue;
            ev.getInsertEvent().setDeleteEventIndex(i2);
        }
    }

    private void computeIntersections(SegmentIntersector si) {
        this.nOverlaps = 0;
        this.prepareEvents();
        for (int i2 = 0; i2 < this.events.size(); ++i2) {
            SweepLineEvent ev = (SweepLineEvent)this.events.get(i2);
            if (!ev.isInsert()) continue;
            this.processOverlaps(i2, ev.getDeleteEventIndex(), ev, si);
        }
    }

    private void processOverlaps(int start2, int end2, SweepLineEvent ev0, SegmentIntersector si) {
        MonotoneChain mc0 = (MonotoneChain)ev0.getObject();
        for (int i2 = start2; i2 < end2; ++i2) {
            SweepLineEvent ev1 = (SweepLineEvent)this.events.get(i2);
            if (!ev1.isInsert()) continue;
            MonotoneChain mc1 = (MonotoneChain)ev1.getObject();
            if (ev0.edgeSet != null && ev0.edgeSet == ev1.edgeSet) continue;
            mc0.computeIntersections(mc1, si);
            ++this.nOverlaps;
        }
    }
}

