/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.quadtree;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.quadtree.IntervalSize;
import com.vividsolutions.jts.index.quadtree.Node;
import com.vividsolutions.jts.index.quadtree.NodeBase;
import com.vividsolutions.jts.util.Assert;

public class Root
extends NodeBase {
    private static final Coordinate origin = new Coordinate(0.0, 0.0);

    public void insert(Envelope itemEnv, Object item) {
        int index2 = Root.getSubnodeIndex(itemEnv, origin);
        if (index2 == -1) {
            this.add(item);
            return;
        }
        Node node = this.subnode[index2];
        if (node == null || !node.getEnvelope().contains(itemEnv)) {
            Node largerNode;
            this.subnode[index2] = largerNode = Node.createExpanded(node, itemEnv);
        }
        this.insertContained(this.subnode[index2], itemEnv, item);
    }

    private void insertContained(Node tree, Envelope itemEnv, Object item) {
        Assert.isTrue(tree.getEnvelope().contains(itemEnv));
        boolean isZeroX = IntervalSize.isZeroWidth(itemEnv.getMinX(), itemEnv.getMaxX());
        boolean isZeroY = IntervalSize.isZeroWidth(itemEnv.getMinY(), itemEnv.getMaxY());
        NodeBase node = isZeroX || isZeroY ? tree.find(itemEnv) : tree.getNode(itemEnv);
        node.add(item);
    }

    protected boolean isSearchMatch(Envelope searchEnv) {
        return true;
    }
}

