/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.strtree;

import com.vividsolutions.jts.util.Assert;

public class Interval {
    private double min;
    private double max;

    public Interval(Interval other) {
        this(other.min, other.max);
    }

    public Interval(double min2, double max2) {
        Assert.isTrue(min2 <= max2);
        this.min = min2;
        this.max = max2;
    }

    public double getCentre() {
        return (this.min + this.max) / 2.0;
    }

    public Interval expandToInclude(Interval other) {
        this.max = Math.max(this.max, other.max);
        this.min = Math.min(this.min, other.min);
        return this;
    }

    public boolean intersects(Interval other) {
        return !(other.min > this.max) && !(other.max < this.min);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Interval)) {
            return false;
        }
        Interval other = (Interval)o;
        return this.min == other.min && this.max == other.max;
    }
}

