/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.linearref;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.linearref.LinearGeometryBuilder;
import com.vividsolutions.jts.linearref.LinearIterator;
import com.vividsolutions.jts.linearref.LinearLocation;
import com.vividsolutions.jts.util.Assert;

class ExtractLineByLocation {
    private Geometry line;

    public static Geometry extract(Geometry line, LinearLocation start2, LinearLocation end2) {
        ExtractLineByLocation ls = new ExtractLineByLocation(line);
        return ls.extract(start2, end2);
    }

    public ExtractLineByLocation(Geometry line) {
        this.line = line;
    }

    public Geometry extract(LinearLocation start2, LinearLocation end2) {
        if (end2.compareTo(start2) < 0) {
            return this.reverse(this.computeLinear(end2, start2));
        }
        return this.computeLinear(start2, end2);
    }

    private Geometry reverse(Geometry linear) {
        if (linear instanceof LineString) {
            return ((LineString)linear).reverse();
        }
        if (linear instanceof MultiLineString) {
            return ((MultiLineString)linear).reverse();
        }
        Assert.shouldNeverReachHere("non-linear geometry encountered");
        return null;
    }

    private LineString computeLine(LinearLocation start2, LinearLocation end2) {
        Coordinate[] newCoordinateArray;
        Coordinate[] coordinates = this.line.getCoordinates();
        CoordinateList newCoordinates = new CoordinateList();
        int startSegmentIndex = start2.getSegmentIndex();
        if (start2.getSegmentFraction() > 0.0) {
            ++startSegmentIndex;
        }
        int lastSegmentIndex = end2.getSegmentIndex();
        if (end2.getSegmentFraction() == 1.0) {
            ++lastSegmentIndex;
        }
        if (lastSegmentIndex >= coordinates.length) {
            lastSegmentIndex = coordinates.length - 1;
        }
        if (!start2.isVertex()) {
            newCoordinates.add(start2.getCoordinate(this.line));
        }
        for (int i2 = startSegmentIndex; i2 <= lastSegmentIndex; ++i2) {
            newCoordinates.add(coordinates[i2]);
        }
        if (!end2.isVertex()) {
            newCoordinates.add(end2.getCoordinate(this.line));
        }
        if (newCoordinates.size() <= 0) {
            newCoordinates.add(start2.getCoordinate(this.line));
        }
        if ((newCoordinateArray = newCoordinates.toCoordinateArray()).length <= 1) {
            newCoordinateArray = new Coordinate[]{newCoordinateArray[0], newCoordinateArray[0]};
        }
        return this.line.getFactory().createLineString(newCoordinateArray);
    }

    private Geometry computeLinear(LinearLocation start2, LinearLocation end2) {
        LinearGeometryBuilder builder = new LinearGeometryBuilder(this.line.getFactory());
        builder.setFixInvalidLines(true);
        if (!start2.isVertex()) {
            builder.add(start2.getCoordinate(this.line));
        }
        LinearIterator it = new LinearIterator(this.line, start2);
        while (it.hasNext() && end2.compareLocationValues(it.getComponentIndex(), it.getVertexIndex(), 0.0) >= 0) {
            Coordinate pt = it.getSegmentStart();
            builder.add(pt);
            if (it.isEndOfLine()) {
                builder.endLine();
            }
            it.next();
        }
        if (!end2.isVertex()) {
            builder.add(end2.getCoordinate(this.line));
        }
        return builder.getGeometry();
    }
}

