/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.linearref;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.linearref.ExtractLineByLocation;
import com.vividsolutions.jts.linearref.LengthIndexOfPoint;
import com.vividsolutions.jts.linearref.LengthLocationMap;
import com.vividsolutions.jts.linearref.LinearLocation;
import com.vividsolutions.jts.linearref.LocationIndexOfLine;
import com.vividsolutions.jts.linearref.LocationIndexedLine;

public class LengthIndexedLine {
    private Geometry linearGeom;

    public LengthIndexedLine(Geometry linearGeom) {
        this.linearGeom = linearGeom;
    }

    public Coordinate extractPoint(double index2) {
        LinearLocation loc = LengthLocationMap.getLocation(this.linearGeom, index2);
        return loc.getCoordinate(this.linearGeom);
    }

    public Coordinate extractPoint(double index2, double offsetDistance) {
        LinearLocation loc = LengthLocationMap.getLocation(this.linearGeom, index2);
        return loc.getSegment(this.linearGeom).pointAlongOffset(loc.getSegmentFraction(), offsetDistance);
    }

    public Geometry extractLine(double startIndex, double endIndex) {
        LocationIndexedLine lil = new LocationIndexedLine(this.linearGeom);
        LinearLocation startLoc = this.locationOf(startIndex);
        LinearLocation endLoc = this.locationOf(endIndex);
        return ExtractLineByLocation.extract(this.linearGeom, startLoc, endLoc);
    }

    private LinearLocation locationOf(double index2) {
        return LengthLocationMap.getLocation(this.linearGeom, index2);
    }

    public double indexOf(Coordinate pt) {
        return LengthIndexOfPoint.indexOf(this.linearGeom, pt);
    }

    public double indexOfAfter(Coordinate pt, double minIndex) {
        return LengthIndexOfPoint.indexOfAfter(this.linearGeom, pt, minIndex);
    }

    public double[] indicesOf(Geometry subLine) {
        LinearLocation[] locIndex = LocationIndexOfLine.indicesOf(this.linearGeom, subLine);
        double[] index2 = new double[]{LengthLocationMap.getLength(this.linearGeom, locIndex[0]), LengthLocationMap.getLength(this.linearGeom, locIndex[1])};
        return index2;
    }

    public double project(Coordinate pt) {
        return LengthIndexOfPoint.indexOf(this.linearGeom, pt);
    }

    public double getStartIndex() {
        return 0.0;
    }

    public double getEndIndex() {
        return this.linearGeom.getLength();
    }

    public boolean isValidIndex(double index2) {
        return index2 >= this.getStartIndex() && index2 <= this.getEndIndex();
    }

    public double clampIndex(double index2) {
        double startIndex = this.getStartIndex();
        if (index2 < startIndex) {
            return startIndex;
        }
        double endIndex = this.getEndIndex();
        if (index2 > endIndex) {
            return endIndex;
        }
        return index2;
    }
}

