/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.linearref;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.linearref.ExtractLineByLocation;
import com.vividsolutions.jts.linearref.LinearLocation;
import com.vividsolutions.jts.linearref.LocationIndexOfLine;
import com.vividsolutions.jts.linearref.LocationIndexOfPoint;

public class LocationIndexedLine {
    private Geometry linearGeom;

    public LocationIndexedLine(Geometry linearGeom) {
        this.linearGeom = linearGeom;
        this.checkGeometryType();
    }

    private void checkGeometryType() {
        if (!(this.linearGeom instanceof LineString) && !(this.linearGeom instanceof MultiLineString)) {
            throw new IllegalArgumentException("Input geometry must be linear");
        }
    }

    public Coordinate extractPoint(LinearLocation index2) {
        return index2.getCoordinate(this.linearGeom);
    }

    public Coordinate extractPoint(LinearLocation index2, double offsetDistance) {
        return index2.getSegment(this.linearGeom).pointAlongOffset(index2.getSegmentFraction(), offsetDistance);
    }

    public Geometry extractLine(LinearLocation startIndex, LinearLocation endIndex) {
        return ExtractLineByLocation.extract(this.linearGeom, startIndex, endIndex);
    }

    public LinearLocation indexOf(Coordinate pt) {
        return LocationIndexOfPoint.indexOf(this.linearGeom, pt);
    }

    public LinearLocation indexOfAfter(Coordinate pt, LinearLocation minIndex) {
        return LocationIndexOfPoint.indexOfAfter(this.linearGeom, pt, minIndex);
    }

    public LinearLocation[] indicesOf(Geometry subLine) {
        return LocationIndexOfLine.indicesOf(this.linearGeom, subLine);
    }

    public LinearLocation project(Coordinate pt) {
        return LocationIndexOfPoint.indexOf(this.linearGeom, pt);
    }

    public LinearLocation getStartIndex() {
        return new LinearLocation();
    }

    public LinearLocation getEndIndex() {
        return LinearLocation.getEndLocation(this.linearGeom);
    }

    public boolean isValidIndex(LinearLocation index2) {
        return index2.isValid(this.linearGeom);
    }

    public LinearLocation clampIndex(LinearLocation index2) {
        LinearLocation loc = (LinearLocation)index2.clone();
        loc.clamp(this.linearGeom);
        return loc;
    }
}

