/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.math;

public class Matrix {
    private static void swapRows(double[][] m, int i2, int j) {
        if (i2 == j) {
            return;
        }
        for (int col = 0; col < m[0].length; ++col) {
            double temp = m[i2][col];
            m[i2][col] = m[j][col];
            m[j][col] = temp;
        }
    }

    private static void swapRows(double[] m, int i2, int j) {
        if (i2 == j) {
            return;
        }
        double temp = m[i2];
        m[i2] = m[j];
        m[j] = temp;
    }

    public static double[] solve(double[][] a, double[] b) {
        int n = b.length;
        if (a.length != n || a[0].length != n) {
            throw new IllegalArgumentException("Matrix A is incorrectly sized");
        }
        for (int i2 = 0; i2 < n; ++i2) {
            int j;
            int maxElementRow = i2;
            for (j = i2 + 1; j < n; ++j) {
                if (!(Math.abs(a[j][i2]) > Math.abs(a[maxElementRow][i2]))) continue;
                maxElementRow = j;
            }
            if (a[maxElementRow][i2] == 0.0) {
                return null;
            }
            Matrix.swapRows(a, i2, maxElementRow);
            Matrix.swapRows(b, i2, maxElementRow);
            j = i2 + 1;
            while (j < n) {
                double rowFactor = a[j][i2] / a[i2][i2];
                for (int k = n - 1; k >= i2; --k) {
                    double[] dArray = a[j];
                    int n2 = k;
                    dArray[n2] = dArray[n2] - a[i2][k] * rowFactor;
                }
                int n3 = j++;
                b[n3] = b[n3] - b[i2] * rowFactor;
            }
        }
        double[] solution = new double[n];
        for (int j = n - 1; j >= 0; --j) {
            double t = 0.0;
            for (int k = j + 1; k < n; ++k) {
                t += a[j][k] * solution[k];
            }
            solution[j] = (b[j] - t) / a[j][j];
        }
        return solution;
    }
}

