/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding.snapround;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.noding.IntersectionFinderAdder;
import com.vividsolutions.jts.noding.MCIndexNoder;
import com.vividsolutions.jts.noding.NodedSegmentString;
import com.vividsolutions.jts.noding.Noder;
import com.vividsolutions.jts.noding.NodingValidator;
import com.vividsolutions.jts.noding.SinglePassNoder;
import com.vividsolutions.jts.noding.snapround.HotPixel;
import java.util.Collection;
import java.util.List;

public class SimpleSnapRounder
implements Noder {
    private final PrecisionModel pm;
    private LineIntersector li;
    private final double scaleFactor;
    private Collection nodedSegStrings;

    public SimpleSnapRounder(PrecisionModel pm) {
        this.pm = pm;
        this.li = new RobustLineIntersector();
        this.li.setPrecisionModel(pm);
        this.scaleFactor = pm.getScale();
    }

    public Collection getNodedSubstrings() {
        return NodedSegmentString.getNodedSubstrings(this.nodedSegStrings);
    }

    public void computeNodes(Collection inputSegmentStrings) {
        this.nodedSegStrings = inputSegmentStrings;
        this.snapRound(inputSegmentStrings, this.li);
    }

    private void checkCorrectness(Collection inputSegmentStrings) {
        List resultSegStrings = NodedSegmentString.getNodedSubstrings(inputSegmentStrings);
        NodingValidator nv = new NodingValidator(resultSegStrings);
        try {
            nv.checkValid();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void snapRound(Collection segStrings, LineIntersector li) {
        List intersections = this.findInteriorIntersections(segStrings, li);
        this.computeSnaps(segStrings, (Collection)intersections);
        this.computeVertexSnaps(segStrings);
    }

    private List findInteriorIntersections(Collection segStrings, LineIntersector li) {
        IntersectionFinderAdder intFinderAdder = new IntersectionFinderAdder(li);
        MCIndexNoder noder = new MCIndexNoder();
        noder.setSegmentIntersector(intFinderAdder);
        ((SinglePassNoder)noder).computeNodes(segStrings);
        return intFinderAdder.getInteriorIntersections();
    }

    private void computeSnaps(Collection segStrings, Collection snapPts) {
        for (NodedSegmentString ss : segStrings) {
            this.computeSnaps(ss, snapPts);
        }
    }

    private void computeSnaps(NodedSegmentString ss, Collection snapPts) {
        for (Coordinate snapPt : snapPts) {
            HotPixel hotPixel = new HotPixel(snapPt, this.scaleFactor, this.li);
            for (int i2 = 0; i2 < ss.size() - 1; ++i2) {
                hotPixel.addSnappedNode(ss, i2);
            }
        }
    }

    public void computeVertexSnaps(Collection edges) {
        for (NodedSegmentString edge0 : edges) {
            for (NodedSegmentString edge1 : edges) {
                this.computeVertexSnaps(edge0, edge1);
            }
        }
    }

    private void computeVertexSnaps(NodedSegmentString e0, NodedSegmentString e1) {
        Coordinate[] pts0 = e0.getCoordinates();
        Coordinate[] pts1 = e1.getCoordinates();
        for (int i0 = 0; i0 < pts0.length - 1; ++i0) {
            HotPixel hotPixel = new HotPixel(pts0[i0], this.scaleFactor, this.li);
            for (int i1 = 0; i1 < pts1.length - 1; ++i1) {
                boolean isNodeAdded;
                if (e0 == e1 && i0 == i1 || !(isNodeAdded = hotPixel.addSnappedNode(e1, i1))) continue;
                e0.addIntersection(pts0[i0], i0);
            }
        }
    }
}

