/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation;

import com.vividsolutions.jts.algorithm.BoundaryNodeRule;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.operation.Counter;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

public class BoundaryOp {
    private Geometry geom;
    private GeometryFactory geomFact;
    private BoundaryNodeRule bnRule;
    private Map endpointMap;

    public BoundaryOp(Geometry geom) {
        this(geom, BoundaryNodeRule.MOD2_BOUNDARY_RULE);
    }

    public BoundaryOp(Geometry geom, BoundaryNodeRule bnRule) {
        this.geom = geom;
        this.geomFact = geom.getFactory();
        this.bnRule = bnRule;
    }

    public Geometry getBoundary() {
        if (this.geom instanceof LineString) {
            return this.boundaryLineString((LineString)this.geom);
        }
        if (this.geom instanceof MultiLineString) {
            return this.boundaryMultiLineString((MultiLineString)this.geom);
        }
        return this.geom.getBoundary();
    }

    private MultiPoint getEmptyMultiPoint() {
        return this.geomFact.createMultiPoint((CoordinateSequence)null);
    }

    private Geometry boundaryMultiLineString(MultiLineString mLine) {
        if (this.geom.isEmpty()) {
            return this.getEmptyMultiPoint();
        }
        Coordinate[] bdyPts = this.computeBoundaryCoordinates(mLine);
        if (bdyPts.length == 1) {
            return this.geomFact.createPoint(bdyPts[0]);
        }
        return this.geomFact.createMultiPoint(bdyPts);
    }

    private Coordinate[] computeBoundaryCoordinates(MultiLineString mLine) {
        ArrayList bdyPts = new ArrayList();
        this.endpointMap = new TreeMap();
        for (int i2 = 0; i2 < mLine.getNumGeometries(); ++i2) {
            LineString line = (LineString)mLine.getGeometryN(i2);
            if (line.getNumPoints() == 0) continue;
            this.addEndpoint(line.getCoordinateN(0));
            this.addEndpoint(line.getCoordinateN(line.getNumPoints() - 1));
        }
        for (Map.Entry entry : this.endpointMap.entrySet()) {
            Counter counter = (Counter)entry.getValue();
            int valence = counter.count;
            if (!this.bnRule.isInBoundary(valence)) continue;
            bdyPts.add(entry.getKey());
        }
        return CoordinateArrays.toCoordinateArray(bdyPts);
    }

    private void addEndpoint(Coordinate pt) {
        Counter counter = (Counter)this.endpointMap.get(pt);
        if (counter == null) {
            counter = new Counter();
            this.endpointMap.put(pt, counter);
        }
        ++counter.count;
    }

    private Geometry boundaryLineString(LineString line) {
        if (this.geom.isEmpty()) {
            return this.getEmptyMultiPoint();
        }
        if (line.isClosed()) {
            boolean closedEndpointOnBoundary = this.bnRule.isInBoundary(2);
            if (closedEndpointOnBoundary) {
                return line.getStartPoint();
            }
            return this.geomFact.createMultiPoint((Coordinate[])null);
        }
        return this.geomFact.createMultiPoint(new Point[]{line.getStartPoint(), line.getEndPoint()});
    }
}

