/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.overlay.snap;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;

public class LineStringSnapper {
    private double snapTolerance = 0.0;
    private Coordinate[] srcPts;
    private LineSegment seg = new LineSegment();
    private boolean allowSnappingToSourceVertices = false;
    private boolean isClosed = false;

    public LineStringSnapper(LineString srcLline, double snapTolerance) {
        this(srcLline.getCoordinates(), snapTolerance);
    }

    public LineStringSnapper(Coordinate[] srcPts, double snapTolerance) {
        this.srcPts = srcPts;
        this.isClosed = LineStringSnapper.isClosed(srcPts);
        this.snapTolerance = snapTolerance;
    }

    public void setAllowSnappingToSourceVertices(boolean allowSnappingToSourceVertices) {
        this.allowSnappingToSourceVertices = allowSnappingToSourceVertices;
    }

    private static boolean isClosed(Coordinate[] pts) {
        if (pts.length <= 1) {
            return false;
        }
        return pts[0].equals2D(pts[pts.length - 1]);
    }

    public Coordinate[] snapTo(Coordinate[] snapPts) {
        CoordinateList coordList = new CoordinateList(this.srcPts);
        this.snapVertices(coordList, snapPts);
        this.snapSegments(coordList, snapPts);
        Coordinate[] newPts = coordList.toCoordinateArray();
        return newPts;
    }

    private void snapVertices(CoordinateList srcCoords, Coordinate[] snapPts) {
        int end2 = this.isClosed ? srcCoords.size() - 1 : srcCoords.size();
        for (int i2 = 0; i2 < end2; ++i2) {
            Coordinate srcPt = (Coordinate)srcCoords.get(i2);
            Coordinate snapVert = this.findSnapForVertex(srcPt, snapPts);
            if (snapVert == null) continue;
            srcCoords.set(i2, new Coordinate(snapVert));
            if (i2 != 0 || !this.isClosed) continue;
            srcCoords.set(srcCoords.size() - 1, new Coordinate(snapVert));
        }
    }

    private Coordinate findSnapForVertex(Coordinate pt, Coordinate[] snapPts) {
        for (int i2 = 0; i2 < snapPts.length; ++i2) {
            if (pt.equals2D(snapPts[i2])) {
                return null;
            }
            if (!(pt.distance(snapPts[i2]) < this.snapTolerance)) continue;
            return snapPts[i2];
        }
        return null;
    }

    private void snapSegments(CoordinateList srcCoords, Coordinate[] snapPts) {
        if (snapPts.length == 0) {
            return;
        }
        int distinctPtCount = snapPts.length;
        if (snapPts[0].equals2D(snapPts[snapPts.length - 1])) {
            distinctPtCount = snapPts.length - 1;
        }
        for (int i2 = 0; i2 < distinctPtCount; ++i2) {
            Coordinate snapPt = snapPts[i2];
            int index2 = this.findSegmentIndexToSnap(snapPt, srcCoords);
            if (index2 < 0) continue;
            srcCoords.add(index2 + 1, new Coordinate(snapPt), false);
        }
    }

    private int findSegmentIndexToSnap(Coordinate snapPt, CoordinateList srcCoords) {
        double minDist = Double.MAX_VALUE;
        int snapIndex = -1;
        for (int i2 = 0; i2 < srcCoords.size() - 1; ++i2) {
            this.seg.p0 = (Coordinate)srcCoords.get(i2);
            this.seg.p1 = (Coordinate)srcCoords.get(i2 + 1);
            if (this.seg.p0.equals2D(snapPt) || this.seg.p1.equals2D(snapPt)) {
                if (this.allowSnappingToSourceVertices) continue;
                return -1;
            }
            double dist = this.seg.distance(snapPt);
            if (!(dist < this.snapTolerance) || !(dist < minDist)) continue;
            minDist = dist;
            snapIndex = i2;
        }
        return snapIndex;
    }
}

