/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.union;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.util.GeometryCombiner;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CascadedPolygonUnion {
    private Collection inputPolys;
    private GeometryFactory geomFactory = null;
    private static final int STRTREE_NODE_CAPACITY = 4;

    public static Geometry union(Collection polys) {
        CascadedPolygonUnion op = new CascadedPolygonUnion(polys);
        return op.union();
    }

    public CascadedPolygonUnion(Collection polys) {
        this.inputPolys = polys;
    }

    public Geometry union() {
        if (this.inputPolys.isEmpty()) {
            return null;
        }
        this.geomFactory = ((Geometry)this.inputPolys.iterator().next()).getFactory();
        STRtree index2 = new STRtree(4);
        for (Geometry item : this.inputPolys) {
            index2.insert(item.getEnvelopeInternal(), (Object)item);
        }
        List itemTree = index2.itemsTree();
        Geometry unionAll = this.unionTree(itemTree);
        return unionAll;
    }

    private Geometry unionTree(List geomTree) {
        List geoms = this.reduceToGeometries(geomTree);
        Geometry union2 = this.binaryUnion(geoms);
        return union2;
    }

    private Geometry repeatedUnion(List geoms) {
        Geometry union2 = null;
        for (Geometry g : geoms) {
            if (union2 == null) {
                union2 = (Geometry)g.clone();
                continue;
            }
            union2 = union2.union(g);
        }
        return union2;
    }

    private Geometry bufferUnion(List geoms) {
        GeometryFactory factory = ((Geometry)geoms.get(0)).getFactory();
        Geometry gColl = factory.buildGeometry(geoms);
        Geometry unionAll = gColl.buffer(0.0);
        return unionAll;
    }

    private Geometry bufferUnion(Geometry g0, Geometry g1) {
        GeometryFactory factory = g0.getFactory();
        GeometryCollection gColl = factory.createGeometryCollection(new Geometry[]{g0, g1});
        Geometry unionAll = gColl.buffer(0.0);
        return unionAll;
    }

    private Geometry binaryUnion(List geoms) {
        return this.binaryUnion(geoms, 0, geoms.size());
    }

    private Geometry binaryUnion(List geoms, int start2, int end2) {
        if (end2 - start2 <= 1) {
            Geometry g0 = CascadedPolygonUnion.getGeometry(geoms, start2);
            return this.unionSafe(g0, null);
        }
        if (end2 - start2 == 2) {
            return this.unionSafe(CascadedPolygonUnion.getGeometry(geoms, start2), CascadedPolygonUnion.getGeometry(geoms, start2 + 1));
        }
        int mid = (end2 + start2) / 2;
        Geometry g0 = this.binaryUnion(geoms, start2, mid);
        Geometry g1 = this.binaryUnion(geoms, mid, end2);
        return this.unionSafe(g0, g1);
    }

    private static Geometry getGeometry(List list2, int index2) {
        if (index2 >= list2.size()) {
            return null;
        }
        return (Geometry)list2.get(index2);
    }

    private List reduceToGeometries(List geomTree) {
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        for (Object o : geomTree) {
            Geometry geom = null;
            if (o instanceof List) {
                geom = this.unionTree((List)o);
            } else if (o instanceof Geometry) {
                geom = (Geometry)o;
            }
            geoms.add(geom);
        }
        return geoms;
    }

    private Geometry unionSafe(Geometry g0, Geometry g1) {
        if (g0 == null && g1 == null) {
            return null;
        }
        if (g0 == null) {
            return (Geometry)g1.clone();
        }
        if (g1 == null) {
            return (Geometry)g0.clone();
        }
        return this.unionOptimized(g0, g1);
    }

    private Geometry unionOptimized(Geometry g0, Geometry g1) {
        Envelope g1Env;
        Envelope g0Env = g0.getEnvelopeInternal();
        if (!g0Env.intersects(g1Env = g1.getEnvelopeInternal())) {
            Geometry combo = GeometryCombiner.combine(g0, g1);
            return combo;
        }
        if (g0.getNumGeometries() <= 1 && g1.getNumGeometries() <= 1) {
            return this.unionActual(g0, g1);
        }
        Envelope commonEnv = g0Env.intersection(g1Env);
        return this.unionUsingEnvelopeIntersection(g0, g1, commonEnv);
    }

    private Geometry unionUsingEnvelopeIntersection(Geometry g0, Geometry g1, Envelope common) {
        ArrayList<Geometry> disjointPolys = new ArrayList<Geometry>();
        Geometry g0Int = this.extractByEnvelope(common, g0, disjointPolys);
        Geometry g1Int = this.extractByEnvelope(common, g1, disjointPolys);
        Geometry union2 = this.unionActual(g0Int, g1Int);
        disjointPolys.add(union2);
        Geometry overallUnion = GeometryCombiner.combine(disjointPolys);
        return overallUnion;
    }

    private Geometry extractByEnvelope(Envelope env, Geometry geom, List disjointGeoms) {
        ArrayList<Geometry> intersectingGeoms = new ArrayList<Geometry>();
        for (int i2 = 0; i2 < geom.getNumGeometries(); ++i2) {
            Geometry elem = geom.getGeometryN(i2);
            if (elem.getEnvelopeInternal().intersects(env)) {
                intersectingGeoms.add(elem);
                continue;
            }
            disjointGeoms.add(elem);
        }
        return this.geomFactory.buildGeometry(intersectingGeoms);
    }

    private Geometry unionActual(Geometry g0, Geometry g1) {
        return g0.union(g1);
    }
}

