/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.precision;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;

public class SimpleMinimumClearance {
    private Geometry inputGeom;
    private double minClearance;
    private Coordinate[] minClearancePts;

    public static double getDistance(Geometry g) {
        SimpleMinimumClearance rp = new SimpleMinimumClearance(g);
        return rp.getDistance();
    }

    public static Geometry getLine(Geometry g) {
        SimpleMinimumClearance rp = new SimpleMinimumClearance(g);
        return rp.getLine();
    }

    public SimpleMinimumClearance(Geometry geom) {
        this.inputGeom = geom;
    }

    public double getDistance() {
        this.compute();
        return this.minClearance;
    }

    public LineString getLine() {
        this.compute();
        return this.inputGeom.getFactory().createLineString(this.minClearancePts);
    }

    private void compute() {
        if (this.minClearancePts != null) {
            return;
        }
        this.minClearancePts = new Coordinate[2];
        this.minClearance = Double.MAX_VALUE;
        this.inputGeom.apply(new VertexCoordinateFilter());
    }

    private void updateClearance(double candidateValue, Coordinate p0, Coordinate p1) {
        if (candidateValue < this.minClearance) {
            this.minClearance = candidateValue;
            this.minClearancePts[0] = new Coordinate(p0);
            this.minClearancePts[1] = new Coordinate(p1);
        }
    }

    private void updateClearance(double candidateValue, Coordinate p2, Coordinate seg0, Coordinate seg1) {
        if (candidateValue < this.minClearance) {
            this.minClearance = candidateValue;
            this.minClearancePts[0] = new Coordinate(p2);
            LineSegment seg = new LineSegment(seg0, seg1);
            this.minClearancePts[1] = new Coordinate(seg.closestPoint(p2));
        }
    }

    private class ComputeMCCoordinateSequenceFilter
    implements CoordinateSequenceFilter {
        private Coordinate queryPt;

        public ComputeMCCoordinateSequenceFilter(Coordinate queryPt) {
            this.queryPt = queryPt;
        }

        public void filter(CoordinateSequence seq, int i2) {
            this.checkVertexDistance(seq.getCoordinate(i2));
            if (i2 > 0) {
                this.checkSegmentDistance(seq.getCoordinate(i2 - 1), seq.getCoordinate(i2));
            }
        }

        private void checkVertexDistance(Coordinate vertex) {
            double vertexDist = vertex.distance(this.queryPt);
            if (vertexDist > 0.0) {
                SimpleMinimumClearance.this.updateClearance(vertexDist, this.queryPt, vertex);
            }
        }

        private void checkSegmentDistance(Coordinate seg0, Coordinate seg1) {
            if (this.queryPt.equals2D(seg0) || this.queryPt.equals2D(seg1)) {
                return;
            }
            double segDist = CGAlgorithms.distancePointLine(this.queryPt, seg1, seg0);
            if (segDist > 0.0) {
                SimpleMinimumClearance.this.updateClearance(segDist, this.queryPt, seg1, seg0);
            }
        }

        public boolean isDone() {
            return false;
        }

        public boolean isGeometryChanged() {
            return false;
        }
    }

    private class VertexCoordinateFilter
    implements CoordinateFilter {
        public void filter(Coordinate coord) {
            SimpleMinimumClearance.this.inputGeom.apply(new ComputeMCCoordinateSequenceFilter(coord));
        }
    }
}

