/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.shape.random;

import com.vividsolutions.jts.algorithm.locate.IndexedPointInAreaLocator;
import com.vividsolutions.jts.algorithm.locate.PointOnGeometryLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygonal;
import com.vividsolutions.jts.shape.GeometricShapeBuilder;

public class RandomPointsBuilder
extends GeometricShapeBuilder {
    protected Geometry maskPoly = null;
    private PointOnGeometryLocator extentLocator;

    public RandomPointsBuilder() {
        super(new GeometryFactory());
    }

    public RandomPointsBuilder(GeometryFactory geomFact) {
        super(geomFact);
    }

    public void setExtent(Geometry mask) {
        if (!(mask instanceof Polygonal)) {
            throw new IllegalArgumentException("Only polygonal extents are supported");
        }
        this.maskPoly = mask;
        this.setExtent(mask.getEnvelopeInternal());
        this.extentLocator = new IndexedPointInAreaLocator(mask);
    }

    public Geometry getGeometry() {
        Coordinate[] pts = new Coordinate[this.numPts];
        int i2 = 0;
        while (i2 < this.numPts) {
            Coordinate p2 = this.createRandomCoord(this.getExtent());
            if (this.extentLocator != null && !this.isInExtent(p2)) continue;
            pts[i2++] = p2;
        }
        return this.geomFactory.createMultiPoint(pts);
    }

    protected boolean isInExtent(Coordinate p2) {
        if (this.extentLocator != null) {
            return this.extentLocator.locate(p2) != 2;
        }
        return this.getExtent().contains(p2);
    }

    protected Coordinate createCoord(double x, double y) {
        Coordinate pt = new Coordinate(x, y);
        this.geomFactory.getPrecisionModel().makePrecise(pt);
        return pt;
    }

    protected Coordinate createRandomCoord(Envelope env) {
        double x = env.getMinX() + env.getWidth() * Math.random();
        double y = env.getMinY() + env.getHeight() * Math.random();
        return this.createCoord(x, y);
    }
}

