/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.triangulate;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineSegment;

public class Segment {
    private LineSegment ls;
    private Object data = null;

    public Segment(double x1, double y1, double z1, double x2, double y2, double z2) {
        this(new Coordinate(x1, y1, z1), new Coordinate(x2, y2, z2));
    }

    public Segment(double x1, double y1, double z1, double x2, double y2, double z2, Object data2) {
        this(new Coordinate(x1, y1, z1), new Coordinate(x2, y2, z2), data2);
    }

    public Segment(Coordinate p0, Coordinate p1, Object data2) {
        this.ls = new LineSegment(p0, p1);
        this.data = data2;
    }

    public Segment(Coordinate p0, Coordinate p1) {
        this.ls = new LineSegment(p0, p1);
    }

    public Coordinate getStart() {
        return this.ls.getCoordinate(0);
    }

    public Coordinate getEnd() {
        return this.ls.getCoordinate(1);
    }

    public double getStartX() {
        Coordinate p2 = this.ls.getCoordinate(0);
        return p2.x;
    }

    public double getStartY() {
        Coordinate p2 = this.ls.getCoordinate(0);
        return p2.y;
    }

    public double getStartZ() {
        Coordinate p2 = this.ls.getCoordinate(0);
        return p2.z;
    }

    public double getEndX() {
        Coordinate p2 = this.ls.getCoordinate(1);
        return p2.x;
    }

    public double getEndY() {
        Coordinate p2 = this.ls.getCoordinate(1);
        return p2.y;
    }

    public double getEndZ() {
        Coordinate p2 = this.ls.getCoordinate(1);
        return p2.z;
    }

    public LineSegment getLineSegment() {
        return this.ls;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data2) {
        this.data = data2;
    }

    public boolean equalsTopo(Segment s2) {
        return this.ls.equalsTopo(s2.getLineSegment());
    }

    public Coordinate intersection(Segment s2) {
        return this.ls.intersection(s2.getLineSegment());
    }

    public String toString() {
        return this.ls.toString();
    }
}

