/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtsexample.precision;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.precision.EnhancedPrecisionOp;

public class EnhancedPrecisionOpExample {
    private WKTReader reader = new WKTReader();

    public static void main(String[] args2) throws Exception {
        EnhancedPrecisionOpExample example = new EnhancedPrecisionOpExample();
        try {
            example.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void run() throws Exception {
        Geometry result2;
        String wkt1 = "POLYGON ((708653.498611049 2402311.54647056, 708708.895756966 2402203.47250014, 708280.326454234 2402089.6337791, 708247.896591321 2402252.48269854, 708367.379593851 2402324.00761653, 708248.882609455 2402253.07294874, 708249.523621829 2402244.3124463, 708261.854734465 2402182.39086576, 708262.818392579 2402183.35452387, 708653.498611049 2402311.54647056))";
        String wkt2 = "POLYGON ((708258.754920656 2402197.91172757, 708257.029447455 2402206.56901508, 708652.961095455 2402312.65463437, 708657.068786251 2402304.6356364, 708258.754920656 2402197.91172757))";
        Geometry g1 = this.reader.read(wkt1);
        Geometry g2 = this.reader.read(wkt2);
        System.out.println("This call to intersection will throw a topology exception due to robustness problems:");
        try {
            result2 = g1.intersection(g2);
        }
        catch (TopologyException ex) {
            ex.printStackTrace();
        }
        System.out.println("Using EnhancedPrecisionOp allows the intersection to be performed with no errors:");
        result2 = EnhancedPrecisionOp.intersection(g1, g2);
        System.out.println(result2);
    }
}

