/*
 * Decompiled with CFR 0.152.
 */
package javassist;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassMap;
import javassist.ClassPool;
import javassist.CodeConverter;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMember;
import javassist.CtMethod;
import javassist.FieldInitLink;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.AccessFlag;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.Bytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.ConstantAttribute;
import javassist.bytecode.Descriptor;
import javassist.bytecode.EnclosingMethodAttribute;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.InnerClassesAttribute;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.ParameterAnnotationsAttribute;
import javassist.bytecode.annotation.Annotation;
import javassist.compiler.AccessorMaker;
import javassist.compiler.CompileError;
import javassist.compiler.Javac;
import javassist.expr.ExprEditor;

class CtClassType
extends CtClass {
    ClassPool classPool;
    boolean wasChanged;
    private boolean wasFrozen;
    boolean wasPruned;
    boolean gcConstPool;
    ClassFile classfile;
    byte[] rawClassfile;
    private WeakReference memberCache;
    private AccessorMaker accessors;
    private FieldInitLink fieldInitializers;
    private Hashtable hiddenMethods;
    private int uniqueNumberSeed;
    private boolean doPruning = ClassPool.doPruning;
    private int getCount;
    private static final int GET_THRESHOLD = 2;

    CtClassType(String name2, ClassPool cp) {
        super(name2);
        this.classPool = cp;
        this.gcConstPool = false;
        this.wasPruned = false;
        this.wasFrozen = false;
        this.wasChanged = false;
        this.classfile = null;
        this.rawClassfile = null;
        this.memberCache = null;
        this.accessors = null;
        this.fieldInitializers = null;
        this.hiddenMethods = null;
        this.uniqueNumberSeed = 0;
        this.getCount = 0;
    }

    CtClassType(InputStream ins, ClassPool cp) throws IOException {
        this((String)null, cp);
        this.classfile = new ClassFile(new DataInputStream(ins));
        this.qualifiedName = this.classfile.getName();
    }

    protected void extendToString(StringBuffer buffer) {
        if (this.wasChanged) {
            buffer.append("changed ");
        }
        if (this.wasFrozen) {
            buffer.append("frozen ");
        }
        if (this.wasPruned) {
            buffer.append("pruned ");
        }
        buffer.append(Modifier.toString(this.getModifiers()));
        buffer.append(" class ");
        buffer.append(this.getName());
        try {
            String name2;
            CtClass ext2 = this.getSuperclass();
            if (ext2 != null && !(name2 = ext2.getName()).equals("java.lang.Object")) {
                buffer.append(" extends " + ext2.getName());
            }
        }
        catch (NotFoundException e) {
            buffer.append(" extends ??");
        }
        try {
            CtClass[] intf = this.getInterfaces();
            if (intf.length > 0) {
                buffer.append(" implements ");
            }
            for (int i2 = 0; i2 < intf.length; ++i2) {
                buffer.append(intf[i2].getName());
                buffer.append(", ");
            }
        }
        catch (NotFoundException e) {
            buffer.append(" extends ??");
        }
        CtMember.Cache memCache = this.getMembers();
        this.exToString(buffer, " fields=", memCache.fieldHead(), memCache.lastField());
        this.exToString(buffer, " constructors=", memCache.consHead(), memCache.lastCons());
        this.exToString(buffer, " methods=", memCache.methodHead(), memCache.lastMethod());
    }

    private void exToString(StringBuffer buffer, String msg, CtMember head, CtMember tail) {
        buffer.append(msg);
        while (head != tail) {
            head = head.next();
            buffer.append(head);
            buffer.append(", ");
        }
    }

    public AccessorMaker getAccessorMaker() {
        if (this.accessors == null) {
            this.accessors = new AccessorMaker(this);
        }
        return this.accessors;
    }

    public ClassFile getClassFile2() {
        ClassFile cfile = this.classfile;
        if (cfile != null) {
            return cfile;
        }
        this.classPool.compress();
        if (this.rawClassfile != null) {
            try {
                this.classfile = new ClassFile(new DataInputStream(new ByteArrayInputStream(this.rawClassfile)));
                this.rawClassfile = null;
                this.getCount = 2;
                return this.classfile;
            }
            catch (IOException e) {
                throw new RuntimeException(e.toString(), e);
            }
        }
        InputStream fin = null;
        try {
            fin = this.classPool.openClassfile(this.getName());
            if (fin == null) {
                throw new NotFoundException(this.getName());
            }
            ClassFile cf = new ClassFile(new DataInputStream(fin = new BufferedInputStream(fin)));
            if (!cf.getName().equals(this.qualifiedName)) {
                throw new RuntimeException("cannot find " + this.qualifiedName + ": " + cf.getName() + " found in " + this.qualifiedName.replace('.', '/') + ".class");
            }
            this.classfile = cf;
            ClassFile classFile = cf;
            return classFile;
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e.toString(), e);
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString(), e);
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException e) {}
            }
        }
    }

    final void incGetCounter() {
        ++this.getCount;
    }

    void compress() {
        if (this.getCount < 2) {
            if (!this.isModified() && ClassPool.releaseUnmodifiedClassFile) {
                this.removeClassFile();
            } else if (this.isFrozen() && !this.wasPruned) {
                this.saveClassFile();
            }
        }
        this.getCount = 0;
    }

    private synchronized void saveClassFile() {
        if (this.classfile == null || this.hasMemberCache() != null) {
            return;
        }
        ByteArrayOutputStream barray = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(barray);
        try {
            this.classfile.write(out);
            barray.close();
            this.rawClassfile = barray.toByteArray();
            this.classfile = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private synchronized void removeClassFile() {
        if (this.classfile != null && !this.isModified() && this.hasMemberCache() == null) {
            this.classfile = null;
        }
    }

    public ClassPool getClassPool() {
        return this.classPool;
    }

    void setClassPool(ClassPool cp) {
        this.classPool = cp;
    }

    public URL getURL() throws NotFoundException {
        URL url = this.classPool.find(this.getName());
        if (url == null) {
            throw new NotFoundException(this.getName());
        }
        return url;
    }

    public boolean isModified() {
        return this.wasChanged;
    }

    public boolean isFrozen() {
        return this.wasFrozen;
    }

    public void freeze() {
        this.wasFrozen = true;
    }

    void checkModify() throws RuntimeException {
        if (this.isFrozen()) {
            String msg = this.getName() + " class is frozen";
            if (this.wasPruned) {
                msg = msg + " and pruned";
            }
            throw new RuntimeException(msg);
        }
        this.wasChanged = true;
    }

    public void defrost() {
        this.checkPruned("defrost");
        this.wasFrozen = false;
    }

    public boolean subtypeOf(CtClass clazz) throws NotFoundException {
        int i2;
        String cname = clazz.getName();
        if (this == clazz || this.getName().equals(cname)) {
            return true;
        }
        ClassFile file2 = this.getClassFile2();
        String supername = file2.getSuperclass();
        if (supername != null && supername.equals(cname)) {
            return true;
        }
        String[] ifs = file2.getInterfaces();
        int num = ifs.length;
        for (i2 = 0; i2 < num; ++i2) {
            if (!ifs[i2].equals(cname)) continue;
            return true;
        }
        if (supername != null && this.classPool.get(supername).subtypeOf(clazz)) {
            return true;
        }
        for (i2 = 0; i2 < num; ++i2) {
            if (!this.classPool.get(ifs[i2]).subtypeOf(clazz)) continue;
            return true;
        }
        return false;
    }

    public void setName(String name2) throws RuntimeException {
        String oldname = this.getName();
        if (name2.equals(oldname)) {
            return;
        }
        this.classPool.checkNotFrozen(name2);
        ClassFile cf = this.getClassFile2();
        super.setName(name2);
        cf.setName(name2);
        this.nameReplaced();
        this.classPool.classNameChanged(oldname, this);
    }

    public void replaceClassName(ClassMap classnames) throws RuntimeException {
        String oldClassName = this.getName();
        String newClassName = (String)classnames.get(Descriptor.toJvmName(oldClassName));
        if (newClassName != null) {
            newClassName = Descriptor.toJavaName(newClassName);
            this.classPool.checkNotFrozen(newClassName);
        }
        super.replaceClassName(classnames);
        ClassFile cf = this.getClassFile2();
        cf.renameClass(classnames);
        this.nameReplaced();
        if (newClassName != null) {
            super.setName(newClassName);
            this.classPool.classNameChanged(oldClassName, this);
        }
    }

    public void replaceClassName(String oldname, String newname) throws RuntimeException {
        String thisname = this.getName();
        if (thisname.equals(oldname)) {
            this.setName(newname);
        } else {
            super.replaceClassName(oldname, newname);
            this.getClassFile2().renameClass(oldname, newname);
            this.nameReplaced();
        }
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.getModifiers());
    }

    public boolean isAnnotation() {
        return Modifier.isAnnotation(this.getModifiers());
    }

    public boolean isEnum() {
        return Modifier.isEnum(this.getModifiers());
    }

    public int getModifiers() {
        ClassFile cf = this.getClassFile2();
        int acc = cf.getAccessFlags();
        acc = AccessFlag.clear(acc, 32);
        int inner = cf.getInnerAccessFlags();
        if (inner != -1 && (inner & 8) != 0) {
            acc |= 8;
        }
        return AccessFlag.toModifier(acc);
    }

    public CtClass[] getNestedClasses() throws NotFoundException {
        ClassFile cf = this.getClassFile2();
        InnerClassesAttribute ica = (InnerClassesAttribute)cf.getAttribute("InnerClasses");
        if (ica == null) {
            return new CtClass[0];
        }
        String thisName = cf.getName() + "$";
        int n = ica.tableLength();
        ArrayList<CtClass> list2 = new ArrayList<CtClass>(n);
        for (int i2 = 0; i2 < n; ++i2) {
            String name2 = ica.innerClass(i2);
            if (name2 == null || !name2.startsWith(thisName) || name2.lastIndexOf(36) >= thisName.length()) continue;
            list2.add(this.classPool.get(name2));
        }
        return list2.toArray(new CtClass[list2.size()]);
    }

    public void setModifiers(int mod) {
        ClassFile cf = this.getClassFile2();
        if (Modifier.isStatic(mod)) {
            int flags = cf.getInnerAccessFlags();
            if (flags != -1 && (flags & 8) != 0) {
                mod &= 0xFFFFFFF7;
            } else {
                throw new RuntimeException("cannot change " + this.getName() + " into a static class");
            }
        }
        this.checkModify();
        cf.setAccessFlags(AccessFlag.of(mod));
    }

    public boolean hasAnnotation(Class clz) {
        ClassFile cf = this.getClassFile2();
        AnnotationsAttribute ainfo = (AnnotationsAttribute)cf.getAttribute("RuntimeInvisibleAnnotations");
        AnnotationsAttribute ainfo2 = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
        return CtClassType.hasAnnotationType(clz, this.getClassPool(), ainfo, ainfo2);
    }

    static boolean hasAnnotationType(Class clz, ClassPool cp, AnnotationsAttribute a1, AnnotationsAttribute a2) {
        int i2;
        Annotation[] anno1 = a1 == null ? null : a1.getAnnotations();
        Annotation[] anno2 = a2 == null ? null : a2.getAnnotations();
        String typeName = clz.getName();
        if (anno1 != null) {
            for (i2 = 0; i2 < anno1.length; ++i2) {
                if (!anno1[i2].getTypeName().equals(typeName)) continue;
                return true;
            }
        }
        if (anno2 != null) {
            for (i2 = 0; i2 < anno2.length; ++i2) {
                if (!anno2[i2].getTypeName().equals(typeName)) continue;
                return true;
            }
        }
        return false;
    }

    public Object getAnnotation(Class clz) throws ClassNotFoundException {
        ClassFile cf = this.getClassFile2();
        AnnotationsAttribute ainfo = (AnnotationsAttribute)cf.getAttribute("RuntimeInvisibleAnnotations");
        AnnotationsAttribute ainfo2 = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
        return CtClassType.getAnnotationType(clz, this.getClassPool(), ainfo, ainfo2);
    }

    static Object getAnnotationType(Class clz, ClassPool cp, AnnotationsAttribute a1, AnnotationsAttribute a2) throws ClassNotFoundException {
        int i2;
        Annotation[] anno1 = a1 == null ? null : a1.getAnnotations();
        Annotation[] anno2 = a2 == null ? null : a2.getAnnotations();
        String typeName = clz.getName();
        if (anno1 != null) {
            for (i2 = 0; i2 < anno1.length; ++i2) {
                if (!anno1[i2].getTypeName().equals(typeName)) continue;
                return CtClassType.toAnnoType(anno1[i2], cp);
            }
        }
        if (anno2 != null) {
            for (i2 = 0; i2 < anno2.length; ++i2) {
                if (!anno2[i2].getTypeName().equals(typeName)) continue;
                return CtClassType.toAnnoType(anno2[i2], cp);
            }
        }
        return null;
    }

    public Object[] getAnnotations() throws ClassNotFoundException {
        return this.getAnnotations(false);
    }

    public Object[] getAvailableAnnotations() {
        try {
            return this.getAnnotations(true);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unexpected exception ", e);
        }
    }

    private Object[] getAnnotations(boolean ignoreNotFound) throws ClassNotFoundException {
        ClassFile cf = this.getClassFile2();
        AnnotationsAttribute ainfo = (AnnotationsAttribute)cf.getAttribute("RuntimeInvisibleAnnotations");
        AnnotationsAttribute ainfo2 = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
        return CtClassType.toAnnotationType(ignoreNotFound, this.getClassPool(), ainfo, ainfo2);
    }

    static Object[] toAnnotationType(boolean ignoreNotFound, ClassPool cp, AnnotationsAttribute a1, AnnotationsAttribute a2) throws ClassNotFoundException {
        int size2;
        Annotation[] anno2;
        int size1;
        Annotation[] anno1;
        if (a1 == null) {
            anno1 = null;
            size1 = 0;
        } else {
            anno1 = a1.getAnnotations();
            size1 = anno1.length;
        }
        if (a2 == null) {
            anno2 = null;
            size2 = 0;
        } else {
            anno2 = a2.getAnnotations();
            size2 = anno2.length;
        }
        if (!ignoreNotFound) {
            Object[] result2 = new Object[size1 + size2];
            for (int i2 = 0; i2 < size1; ++i2) {
                result2[i2] = CtClassType.toAnnoType(anno1[i2], cp);
            }
            for (int j = 0; j < size2; ++j) {
                result2[j + size1] = CtClassType.toAnnoType(anno2[j], cp);
            }
            return result2;
        }
        ArrayList<Object> annotations2 = new ArrayList<Object>();
        for (int i3 = 0; i3 < size1; ++i3) {
            try {
                annotations2.add(CtClassType.toAnnoType(anno1[i3], cp));
                continue;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        for (int j = 0; j < size2; ++j) {
            try {
                annotations2.add(CtClassType.toAnnoType(anno2[j], cp));
                continue;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return annotations2.toArray();
    }

    static Object[][] toAnnotationType(boolean ignoreNotFound, ClassPool cp, ParameterAnnotationsAttribute a1, ParameterAnnotationsAttribute a2, MethodInfo minfo) throws ClassNotFoundException {
        int numParameters = 0;
        numParameters = a1 != null ? a1.numParameters() : (a2 != null ? a2.numParameters() : Descriptor.numOfParameters(minfo.getDescriptor()));
        Object[][] result2 = new Object[numParameters][];
        for (int i2 = 0; i2 < numParameters; ++i2) {
            int j;
            int size2;
            Annotation[] anno2;
            int size1;
            Annotation[] anno1;
            if (a1 == null) {
                anno1 = null;
                size1 = 0;
            } else {
                anno1 = a1.getAnnotations()[i2];
                size1 = anno1.length;
            }
            if (a2 == null) {
                anno2 = null;
                size2 = 0;
            } else {
                anno2 = a2.getAnnotations()[i2];
                size2 = anno2.length;
            }
            if (!ignoreNotFound) {
                int j2;
                result2[i2] = new Object[size1 + size2];
                for (j2 = 0; j2 < size1; ++j2) {
                    result2[i2][j2] = CtClassType.toAnnoType(anno1[j2], cp);
                }
                for (j2 = 0; j2 < size2; ++j2) {
                    result2[i2][j2 + size1] = CtClassType.toAnnoType(anno2[j2], cp);
                }
                continue;
            }
            ArrayList<Object> annotations2 = new ArrayList<Object>();
            for (j = 0; j < size1; ++j) {
                try {
                    annotations2.add(CtClassType.toAnnoType(anno1[j], cp));
                    continue;
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            for (j = 0; j < size2; ++j) {
                try {
                    annotations2.add(CtClassType.toAnnoType(anno2[j], cp));
                    continue;
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            result2[i2] = annotations2.toArray();
        }
        return result2;
    }

    private static Object toAnnoType(Annotation anno, ClassPool cp) throws ClassNotFoundException {
        try {
            ClassLoader cl = cp.getClassLoader();
            return anno.toAnnotationType(cl, cp);
        }
        catch (ClassNotFoundException e) {
            ClassLoader cl2 = cp.getClass().getClassLoader();
            return anno.toAnnotationType(cl2, cp);
        }
    }

    public boolean subclassOf(CtClass superclass2) {
        if (superclass2 == null) {
            return false;
        }
        String superName = superclass2.getName();
        try {
            for (CtClass curr = this; curr != null; curr = ((CtClass)curr).getSuperclass()) {
                if (!curr.getName().equals(superName)) continue;
                return true;
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        return false;
    }

    public CtClass getSuperclass() throws NotFoundException {
        String supername = this.getClassFile2().getSuperclass();
        if (supername == null) {
            return null;
        }
        return this.classPool.get(supername);
    }

    public void setSuperclass(CtClass clazz) throws CannotCompileException {
        this.checkModify();
        if (this.isInterface()) {
            this.addInterface(clazz);
        } else {
            this.getClassFile2().setSuperclass(clazz.getName());
        }
    }

    public CtClass[] getInterfaces() throws NotFoundException {
        String[] ifs = this.getClassFile2().getInterfaces();
        int num = ifs.length;
        CtClass[] ifc = new CtClass[num];
        for (int i2 = 0; i2 < num; ++i2) {
            ifc[i2] = this.classPool.get(ifs[i2]);
        }
        return ifc;
    }

    public void setInterfaces(CtClass[] list2) {
        String[] ifs;
        this.checkModify();
        if (list2 == null) {
            ifs = new String[]{};
        } else {
            int num = list2.length;
            ifs = new String[num];
            for (int i2 = 0; i2 < num; ++i2) {
                ifs[i2] = list2[i2].getName();
            }
        }
        this.getClassFile2().setInterfaces(ifs);
    }

    public void addInterface(CtClass anInterface) {
        this.checkModify();
        if (anInterface != null) {
            this.getClassFile2().addInterface(anInterface.getName());
        }
    }

    public CtClass getDeclaringClass() throws NotFoundException {
        ClassFile cf = this.getClassFile2();
        InnerClassesAttribute ica = (InnerClassesAttribute)cf.getAttribute("InnerClasses");
        if (ica == null) {
            return null;
        }
        String name2 = this.getName();
        int n = ica.tableLength();
        for (int i2 = 0; i2 < n; ++i2) {
            if (!name2.equals(ica.innerClass(i2))) continue;
            String outName = ica.outerClass(i2);
            if (outName != null) {
                return this.classPool.get(outName);
            }
            EnclosingMethodAttribute ema = (EnclosingMethodAttribute)cf.getAttribute("EnclosingMethod");
            if (ema == null) continue;
            return this.classPool.get(ema.className());
        }
        return null;
    }

    public CtMethod getEnclosingMethod() throws NotFoundException {
        ClassFile cf = this.getClassFile2();
        EnclosingMethodAttribute ema = (EnclosingMethodAttribute)cf.getAttribute("EnclosingMethod");
        if (ema != null) {
            CtClass enc = this.classPool.get(ema.className());
            return enc.getMethod(ema.methodName(), ema.methodDescriptor());
        }
        return null;
    }

    public CtClass makeNestedClass(String name2, boolean isStatic) {
        if (!isStatic) {
            throw new RuntimeException("sorry, only nested static class is supported");
        }
        this.checkModify();
        CtClass c = this.classPool.makeNestedClass(this.getName() + "$" + name2);
        ClassFile cf = this.getClassFile2();
        ClassFile cf2 = c.getClassFile2();
        InnerClassesAttribute ica = (InnerClassesAttribute)cf.getAttribute("InnerClasses");
        if (ica == null) {
            ica = new InnerClassesAttribute(cf.getConstPool());
            cf.addAttribute(ica);
        }
        ica.append(c.getName(), this.getName(), name2, cf2.getAccessFlags() & 0xFFFFFFDF | 8);
        cf2.addAttribute(ica.copy(cf2.getConstPool(), null));
        return c;
    }

    private void nameReplaced() {
        CtMember.Cache cache = this.hasMemberCache();
        if (cache != null) {
            CtMember tail = cache.lastMethod();
            for (CtMember mth = cache.methodHead(); mth != tail; mth = mth.next()) {
                mth.nameReplaced();
            }
        }
    }

    protected CtMember.Cache hasMemberCache() {
        if (this.memberCache != null) {
            return (CtMember.Cache)this.memberCache.get();
        }
        return null;
    }

    protected synchronized CtMember.Cache getMembers() {
        CtMember.Cache cache = null;
        if (this.memberCache == null || (cache = (CtMember.Cache)this.memberCache.get()) == null) {
            cache = new CtMember.Cache(this);
            this.makeFieldCache(cache);
            this.makeBehaviorCache(cache);
            this.memberCache = new WeakReference<CtMember.Cache>(cache);
        }
        return cache;
    }

    private void makeFieldCache(CtMember.Cache cache) {
        List list2 = this.getClassFile2().getFields();
        int n = list2.size();
        for (int i2 = 0; i2 < n; ++i2) {
            FieldInfo finfo = (FieldInfo)list2.get(i2);
            CtField newField = new CtField(finfo, (CtClass)this);
            cache.addField(newField);
        }
    }

    private void makeBehaviorCache(CtMember.Cache cache) {
        List list2 = this.getClassFile2().getMethods();
        int n = list2.size();
        for (int i2 = 0; i2 < n; ++i2) {
            MethodInfo minfo = (MethodInfo)list2.get(i2);
            if (minfo.isMethod()) {
                CtMethod newMethod = new CtMethod(minfo, this);
                cache.addMethod(newMethod);
                continue;
            }
            CtConstructor newCons = new CtConstructor(minfo, (CtClass)this);
            cache.addConstructor(newCons);
        }
    }

    public CtField[] getFields() {
        ArrayList alist = new ArrayList();
        CtClassType.getFields(alist, this);
        return alist.toArray(new CtField[alist.size()]);
    }

    private static void getFields(ArrayList alist, CtClass cc) {
        if (cc == null) {
            return;
        }
        try {
            CtClassType.getFields(alist, cc.getSuperclass());
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            CtClass[] ifs = cc.getInterfaces();
            int num = ifs.length;
            for (int i2 = 0; i2 < num; ++i2) {
                CtClassType.getFields(alist, ifs[i2]);
            }
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        CtMember.Cache memCache = ((CtClassType)cc).getMembers();
        CtMember field2 = memCache.fieldHead();
        CtMember tail = memCache.lastField();
        while (field2 != tail) {
            if (Modifier.isPrivate((field2 = field2.next()).getModifiers())) continue;
            alist.add(field2);
        }
    }

    public CtField getField(String name2, String desc) throws NotFoundException {
        CtField f = this.getField2(name2, desc);
        return this.checkGetField(f, name2, desc);
    }

    private CtField checkGetField(CtField f, String name2, String desc) throws NotFoundException {
        if (f == null) {
            String msg = "field: " + name2;
            if (desc != null) {
                msg = msg + " type " + desc;
            }
            throw new NotFoundException(msg + " in " + this.getName());
        }
        return f;
    }

    CtField getField2(String name2, String desc) {
        CtField df = this.getDeclaredField2(name2, desc);
        if (df != null) {
            return df;
        }
        try {
            CtClass[] ifs = this.getInterfaces();
            int num = ifs.length;
            for (int i2 = 0; i2 < num; ++i2) {
                CtField f = ifs[i2].getField2(name2, desc);
                if (f == null) continue;
                return f;
            }
            CtClass s2 = this.getSuperclass();
            if (s2 != null) {
                return s2.getField2(name2, desc);
            }
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        return null;
    }

    public CtField[] getDeclaredFields() {
        CtMember field2;
        CtMember.Cache memCache = this.getMembers();
        CtMember tail = memCache.lastField();
        int num = CtMember.Cache.count(field2, tail);
        CtField[] cfs = new CtField[num];
        int i2 = 0;
        for (field2 = memCache.fieldHead(); field2 != tail; field2 = field2.next()) {
            cfs[i2++] = (CtField)field2;
        }
        return cfs;
    }

    public CtField getDeclaredField(String name2) throws NotFoundException {
        return this.getDeclaredField(name2, null);
    }

    public CtField getDeclaredField(String name2, String desc) throws NotFoundException {
        CtField f = this.getDeclaredField2(name2, desc);
        return this.checkGetField(f, name2, desc);
    }

    private CtField getDeclaredField2(String name2, String desc) {
        CtMember.Cache memCache = this.getMembers();
        CtMember field2 = memCache.fieldHead();
        CtMember tail = memCache.lastField();
        while (field2 != tail) {
            if (!(field2 = field2.next()).getName().equals(name2) || desc != null && !desc.equals(field2.getSignature())) continue;
            return (CtField)field2;
        }
        return null;
    }

    public CtBehavior[] getDeclaredBehaviors() {
        CtMember cons;
        CtMember.Cache memCache = this.getMembers();
        CtMember consTail = memCache.lastCons();
        int cnum = CtMember.Cache.count(cons, consTail);
        CtMember mth = memCache.methodHead();
        CtMember mthTail = memCache.lastMethod();
        int mnum = CtMember.Cache.count(mth, mthTail);
        CtBehavior[] cb = new CtBehavior[cnum + mnum];
        int i2 = 0;
        for (cons = memCache.consHead(); cons != consTail; cons = cons.next()) {
            cb[i2++] = (CtBehavior)cons;
        }
        while (mth != mthTail) {
            mth = mth.next();
            cb[i2++] = (CtBehavior)mth;
        }
        return cb;
    }

    public CtConstructor[] getConstructors() {
        CtMember.Cache memCache = this.getMembers();
        CtMember cons = memCache.consHead();
        CtMember consTail = memCache.lastCons();
        int n = 0;
        CtMember mem = cons;
        while (mem != consTail) {
            if (!CtClassType.isPubCons((CtConstructor)(mem = mem.next()))) continue;
            ++n;
        }
        CtConstructor[] result2 = new CtConstructor[n];
        int i2 = 0;
        mem = cons;
        while (mem != consTail) {
            CtConstructor cc = (CtConstructor)(mem = mem.next());
            if (!CtClassType.isPubCons(cc)) continue;
            result2[i2++] = cc;
        }
        return result2;
    }

    private static boolean isPubCons(CtConstructor cons) {
        return !Modifier.isPrivate(cons.getModifiers()) && cons.isConstructor();
    }

    public CtConstructor getConstructor(String desc) throws NotFoundException {
        CtMember.Cache memCache = this.getMembers();
        CtMember cons = memCache.consHead();
        CtMember consTail = memCache.lastCons();
        while (cons != consTail) {
            CtConstructor cc = (CtConstructor)(cons = cons.next());
            if (!cc.getMethodInfo2().getDescriptor().equals(desc) || !cc.isConstructor()) continue;
            return cc;
        }
        return super.getConstructor(desc);
    }

    public CtConstructor[] getDeclaredConstructors() {
        CtMember.Cache memCache = this.getMembers();
        CtMember cons = memCache.consHead();
        CtMember consTail = memCache.lastCons();
        int n = 0;
        CtMember mem = cons;
        while (mem != consTail) {
            CtConstructor cc = (CtConstructor)(mem = mem.next());
            if (!cc.isConstructor()) continue;
            ++n;
        }
        CtConstructor[] result2 = new CtConstructor[n];
        int i2 = 0;
        mem = cons;
        while (mem != consTail) {
            CtConstructor cc = (CtConstructor)(mem = mem.next());
            if (!cc.isConstructor()) continue;
            result2[i2++] = cc;
        }
        return result2;
    }

    public CtConstructor getClassInitializer() {
        CtMember.Cache memCache = this.getMembers();
        CtMember cons = memCache.consHead();
        CtMember consTail = memCache.lastCons();
        while (cons != consTail) {
            CtConstructor cc = (CtConstructor)(cons = cons.next());
            if (!cc.isClassInitializer()) continue;
            return cc;
        }
        return null;
    }

    public CtMethod[] getMethods() {
        HashMap h = new HashMap();
        CtClassType.getMethods0(h, this);
        return h.values().toArray(new CtMethod[h.size()]);
    }

    private static void getMethods0(HashMap h, CtClass cc) {
        try {
            CtClass[] ifs = cc.getInterfaces();
            int size2 = ifs.length;
            for (int i2 = 0; i2 < size2; ++i2) {
                CtClassType.getMethods0(h, ifs[i2]);
            }
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            CtClass s2 = cc.getSuperclass();
            if (s2 != null) {
                CtClassType.getMethods0(h, s2);
            }
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        if (cc instanceof CtClassType) {
            CtMember.Cache memCache = ((CtClassType)cc).getMembers();
            CtMember mth = memCache.methodHead();
            CtMember mthTail = memCache.lastMethod();
            while (mth != mthTail) {
                if (Modifier.isPrivate((mth = mth.next()).getModifiers())) continue;
                h.put(((CtMethod)mth).getStringRep(), mth);
            }
        }
    }

    public CtMethod getMethod(String name2, String desc) throws NotFoundException {
        CtMethod m = CtClassType.getMethod0(this, name2, desc);
        if (m != null) {
            return m;
        }
        throw new NotFoundException(name2 + "(..) is not found in " + this.getName());
    }

    private static CtMethod getMethod0(CtClass cc, String name2, String desc) {
        if (cc instanceof CtClassType) {
            CtMember.Cache memCache = ((CtClassType)cc).getMembers();
            CtMember mth = memCache.methodHead();
            CtMember mthTail = memCache.lastMethod();
            while (mth != mthTail) {
                if (!(mth = mth.next()).getName().equals(name2) || !((CtMethod)mth).getMethodInfo2().getDescriptor().equals(desc)) continue;
                return (CtMethod)mth;
            }
        }
        try {
            CtMethod m;
            CtClass s2 = cc.getSuperclass();
            if (s2 != null && (m = CtClassType.getMethod0(s2, name2, desc)) != null) {
                return m;
            }
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            CtClass[] ifs = cc.getInterfaces();
            int size2 = ifs.length;
            for (int i2 = 0; i2 < size2; ++i2) {
                CtMethod m = CtClassType.getMethod0(ifs[i2], name2, desc);
                if (m == null) continue;
                return m;
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return null;
    }

    public CtMethod[] getDeclaredMethods() {
        CtMember mth;
        CtMember.Cache memCache = this.getMembers();
        CtMember mthTail = memCache.lastMethod();
        int num = CtMember.Cache.count(mth, mthTail);
        CtMethod[] cms = new CtMethod[num];
        int i2 = 0;
        for (mth = memCache.methodHead(); mth != mthTail; mth = mth.next()) {
            cms[i2++] = (CtMethod)mth;
        }
        return cms;
    }

    public CtMethod getDeclaredMethod(String name2) throws NotFoundException {
        CtMember.Cache memCache = this.getMembers();
        CtMember mth = memCache.methodHead();
        CtMember mthTail = memCache.lastMethod();
        while (mth != mthTail) {
            if (!(mth = mth.next()).getName().equals(name2)) continue;
            return (CtMethod)mth;
        }
        throw new NotFoundException(name2 + "(..) is not found in " + this.getName());
    }

    public CtMethod getDeclaredMethod(String name2, CtClass[] params2) throws NotFoundException {
        String desc = Descriptor.ofParameters(params2);
        CtMember.Cache memCache = this.getMembers();
        CtMember mth = memCache.methodHead();
        CtMember mthTail = memCache.lastMethod();
        while (mth != mthTail) {
            if (!(mth = mth.next()).getName().equals(name2) || !((CtMethod)mth).getMethodInfo2().getDescriptor().startsWith(desc)) continue;
            return (CtMethod)mth;
        }
        throw new NotFoundException(name2 + "(..) is not found in " + this.getName());
    }

    public void addField(CtField f, String init) throws CannotCompileException {
        this.addField(f, CtField.Initializer.byExpr(init));
    }

    public void addField(CtField f, CtField.Initializer init) throws CannotCompileException {
        this.checkModify();
        if (f.getDeclaringClass() != this) {
            throw new CannotCompileException("cannot add");
        }
        if (init == null) {
            init = f.getInit();
        }
        if (init != null) {
            init.check(f.getSignature());
            int mod = f.getModifiers();
            if (Modifier.isStatic(mod) && Modifier.isFinal(mod)) {
                try {
                    ConstPool cp = this.getClassFile2().getConstPool();
                    int index2 = init.getConstantValue(cp, f.getType());
                    if (index2 != 0) {
                        f.getFieldInfo2().addAttribute(new ConstantAttribute(cp, index2));
                        init = null;
                    }
                }
                catch (NotFoundException e) {
                    // empty catch block
                }
            }
        }
        this.getMembers().addField(f);
        this.getClassFile2().addField(f.getFieldInfo2());
        if (init != null) {
            FieldInitLink fil = new FieldInitLink(f, init);
            FieldInitLink link2 = this.fieldInitializers;
            if (link2 == null) {
                this.fieldInitializers = fil;
            } else {
                while (link2.next != null) {
                    link2 = link2.next;
                }
                link2.next = fil;
            }
        }
    }

    public void removeField(CtField f) throws NotFoundException {
        this.checkModify();
        FieldInfo fi = f.getFieldInfo2();
        ClassFile cf = this.getClassFile2();
        if (!cf.getFields().remove(fi)) {
            throw new NotFoundException(f.toString());
        }
        this.getMembers().remove(f);
        this.gcConstPool = true;
    }

    public CtConstructor makeClassInitializer() throws CannotCompileException {
        CtConstructor clinit = this.getClassInitializer();
        if (clinit != null) {
            return clinit;
        }
        this.checkModify();
        ClassFile cf = this.getClassFile2();
        Bytecode code = new Bytecode(cf.getConstPool(), 0, 0);
        this.modifyClassConstructor(cf, code, 0, 0);
        return this.getClassInitializer();
    }

    public void addConstructor(CtConstructor c) throws CannotCompileException {
        this.checkModify();
        if (c.getDeclaringClass() != this) {
            throw new CannotCompileException("cannot add");
        }
        this.getMembers().addConstructor(c);
        this.getClassFile2().addMethod(c.getMethodInfo2());
    }

    public void removeConstructor(CtConstructor m) throws NotFoundException {
        this.checkModify();
        MethodInfo mi = m.getMethodInfo2();
        ClassFile cf = this.getClassFile2();
        if (!cf.getMethods().remove(mi)) {
            throw new NotFoundException(m.toString());
        }
        this.getMembers().remove(m);
        this.gcConstPool = true;
    }

    public void addMethod(CtMethod m) throws CannotCompileException {
        this.checkModify();
        if (m.getDeclaringClass() != this) {
            throw new CannotCompileException("bad declaring class");
        }
        int mod = m.getModifiers();
        if ((this.getModifiers() & 0x200) != 0) {
            m.setModifiers(mod | 1);
            if ((mod & 0x400) == 0) {
                throw new CannotCompileException("an interface method must be abstract: " + m.toString());
            }
        }
        this.getMembers().addMethod(m);
        this.getClassFile2().addMethod(m.getMethodInfo2());
        if ((mod & 0x400) != 0) {
            this.setModifiers(this.getModifiers() | 0x400);
        }
    }

    public void removeMethod(CtMethod m) throws NotFoundException {
        this.checkModify();
        MethodInfo mi = m.getMethodInfo2();
        ClassFile cf = this.getClassFile2();
        if (!cf.getMethods().remove(mi)) {
            throw new NotFoundException(m.toString());
        }
        this.getMembers().remove(m);
        this.gcConstPool = true;
    }

    public byte[] getAttribute(String name2) {
        AttributeInfo ai = this.getClassFile2().getAttribute(name2);
        if (ai == null) {
            return null;
        }
        return ai.get();
    }

    public void setAttribute(String name2, byte[] data2) {
        this.checkModify();
        ClassFile cf = this.getClassFile2();
        cf.addAttribute(new AttributeInfo(cf.getConstPool(), name2, data2));
    }

    public void instrument(CodeConverter converter) throws CannotCompileException {
        this.checkModify();
        ClassFile cf = this.getClassFile2();
        ConstPool cp = cf.getConstPool();
        List list2 = cf.getMethods();
        int n = list2.size();
        for (int i2 = 0; i2 < n; ++i2) {
            MethodInfo minfo = (MethodInfo)list2.get(i2);
            converter.doit(this, minfo, cp);
        }
    }

    public void instrument(ExprEditor editor) throws CannotCompileException {
        this.checkModify();
        ClassFile cf = this.getClassFile2();
        List list2 = cf.getMethods();
        int n = list2.size();
        for (int i2 = 0; i2 < n; ++i2) {
            MethodInfo minfo = (MethodInfo)list2.get(i2);
            editor.doit(this, minfo);
        }
    }

    public void prune() {
        if (this.wasPruned) {
            return;
        }
        this.wasFrozen = true;
        this.wasPruned = true;
        this.getClassFile2().prune();
    }

    public void rebuildClassFile() {
        this.gcConstPool = true;
    }

    public void toBytecode(DataOutputStream out) throws CannotCompileException, IOException {
        try {
            if (this.isModified()) {
                this.checkPruned("toBytecode");
                ClassFile cf = this.getClassFile2();
                if (this.gcConstPool) {
                    cf.compact();
                    this.gcConstPool = false;
                }
                this.modifyClassConstructor(cf);
                this.modifyConstructors(cf);
                cf.write(out);
                out.flush();
                this.fieldInitializers = null;
                if (this.doPruning) {
                    cf.prune();
                    this.wasPruned = true;
                }
            } else {
                this.classPool.writeClassfile(this.getName(), out);
            }
            this.getCount = 0;
            this.wasFrozen = true;
        }
        catch (NotFoundException e) {
            throw new CannotCompileException(e);
        }
        catch (IOException e) {
            throw new CannotCompileException(e);
        }
    }

    private void checkPruned(String method2) {
        if (this.wasPruned) {
            throw new RuntimeException(method2 + "(): " + this.getName() + " was pruned.");
        }
    }

    public boolean stopPruning(boolean stop2) {
        boolean prev = !this.doPruning;
        this.doPruning = !stop2;
        return prev;
    }

    private void modifyClassConstructor(ClassFile cf) throws CannotCompileException, NotFoundException {
        if (this.fieldInitializers == null) {
            return;
        }
        Bytecode code = new Bytecode(cf.getConstPool(), 0, 0);
        Javac jv = new Javac(code, this);
        int stacksize = 0;
        boolean doInit = false;
        FieldInitLink fi = this.fieldInitializers;
        while (fi != null) {
            CtField f = fi.field;
            if (Modifier.isStatic(f.getModifiers())) {
                doInit = true;
                int s2 = fi.init.compileIfStatic(f.getType(), f.getName(), code, jv);
                if (stacksize < s2) {
                    stacksize = s2;
                }
            }
            fi = fi.next;
        }
        if (doInit) {
            this.modifyClassConstructor(cf, code, stacksize, 0);
        }
    }

    private void modifyClassConstructor(ClassFile cf, Bytecode code, int stacksize, int localsize) throws CannotCompileException {
        MethodInfo m = cf.getStaticInitializer();
        if (m == null) {
            code.add(177);
            code.setMaxStack(stacksize);
            code.setMaxLocals(localsize);
            m = new MethodInfo(cf.getConstPool(), "<clinit>", "()V");
            m.setAccessFlags(8);
            m.setCodeAttribute(code.toCodeAttribute());
            cf.addMethod(m);
            CtMember.Cache cache = this.hasMemberCache();
            if (cache != null) {
                cache.addConstructor(new CtConstructor(m, (CtClass)this));
            }
        } else {
            CodeAttribute codeAttr = m.getCodeAttribute();
            if (codeAttr == null) {
                throw new CannotCompileException("empty <clinit>");
            }
            try {
                int maxlocals;
                CodeIterator it = codeAttr.iterator();
                int pos2 = it.insertEx(code.get());
                it.insert(code.getExceptionTable(), pos2);
                int maxstack = codeAttr.getMaxStack();
                if (maxstack < stacksize) {
                    codeAttr.setMaxStack(stacksize);
                }
                if ((maxlocals = codeAttr.getMaxLocals()) < localsize) {
                    codeAttr.setMaxLocals(localsize);
                }
            }
            catch (BadBytecode e) {
                throw new CannotCompileException(e);
            }
        }
        try {
            m.rebuildStackMapIf6(this.classPool, cf);
        }
        catch (BadBytecode e) {
            throw new CannotCompileException(e);
        }
    }

    private void modifyConstructors(ClassFile cf) throws CannotCompileException, NotFoundException {
        if (this.fieldInitializers == null) {
            return;
        }
        ConstPool cp = cf.getConstPool();
        List list2 = cf.getMethods();
        int n = list2.size();
        for (int i2 = 0; i2 < n; ++i2) {
            CodeAttribute codeAttr;
            MethodInfo minfo = (MethodInfo)list2.get(i2);
            if (!minfo.isConstructor() || (codeAttr = minfo.getCodeAttribute()) == null) continue;
            try {
                Bytecode init = new Bytecode(cp, 0, codeAttr.getMaxLocals());
                CtClass[] params2 = Descriptor.getParameterTypes(minfo.getDescriptor(), this.classPool);
                int stacksize = this.makeFieldInitializer(init, params2);
                CtClassType.insertAuxInitializer(codeAttr, init, stacksize);
                minfo.rebuildStackMapIf6(this.classPool, cf);
                continue;
            }
            catch (BadBytecode e) {
                throw new CannotCompileException(e);
            }
        }
    }

    private static void insertAuxInitializer(CodeAttribute codeAttr, Bytecode initializer, int stacksize) throws BadBytecode {
        CodeIterator it = codeAttr.iterator();
        int index2 = it.skipSuperConstructor();
        if (index2 < 0 && (index2 = it.skipThisConstructor()) >= 0) {
            return;
        }
        int pos2 = it.insertEx(initializer.get());
        it.insert(initializer.getExceptionTable(), pos2);
        int maxstack = codeAttr.getMaxStack();
        if (maxstack < stacksize) {
            codeAttr.setMaxStack(stacksize);
        }
    }

    private int makeFieldInitializer(Bytecode code, CtClass[] parameters2) throws CannotCompileException, NotFoundException {
        int stacksize = 0;
        Javac jv = new Javac(code, this);
        try {
            jv.recordParams(parameters2, false);
        }
        catch (CompileError e) {
            throw new CannotCompileException(e);
        }
        FieldInitLink fi = this.fieldInitializers;
        while (fi != null) {
            int s2;
            CtField f = fi.field;
            if (!Modifier.isStatic(f.getModifiers()) && stacksize < (s2 = fi.init.compile(f.getType(), f.getName(), code, parameters2, jv))) {
                stacksize = s2;
            }
            fi = fi.next;
        }
        return stacksize;
    }

    Hashtable getHiddenMethods() {
        if (this.hiddenMethods == null) {
            this.hiddenMethods = new Hashtable();
        }
        return this.hiddenMethods;
    }

    int getUniqueNumber() {
        return this.uniqueNumberSeed++;
    }

    public String makeUniqueName(String prefix) {
        String name2;
        HashMap table = new HashMap();
        this.makeMemberList(table);
        Set keys2 = table.keySet();
        String[] methods2 = new String[keys2.size()];
        keys2.toArray(methods2);
        if (CtClassType.notFindInArray(prefix, methods2)) {
            return prefix;
        }
        int i2 = 100;
        do {
            if (i2 <= 999) continue;
            throw new RuntimeException("too many unique name");
        } while (!CtClassType.notFindInArray(name2 = prefix + i2++, methods2));
        return name2;
    }

    private static boolean notFindInArray(String prefix, String[] values2) {
        int len = values2.length;
        for (int i2 = 0; i2 < len; ++i2) {
            if (!values2[i2].startsWith(prefix)) continue;
            return false;
        }
        return true;
    }

    private void makeMemberList(HashMap table) {
        int i2;
        int mod = this.getModifiers();
        if (Modifier.isAbstract(mod) || Modifier.isInterface(mod)) {
            try {
                CtClass[] ifs = this.getInterfaces();
                int size2 = ifs.length;
                for (i2 = 0; i2 < size2; ++i2) {
                    CtClass ic = ifs[i2];
                    if (ic == null || !(ic instanceof CtClassType)) continue;
                    ((CtClassType)ic).makeMemberList(table);
                }
            }
            catch (NotFoundException e) {
                // empty catch block
            }
        }
        try {
            CtClass s2 = this.getSuperclass();
            if (s2 != null && s2 instanceof CtClassType) {
                ((CtClassType)s2).makeMemberList(table);
            }
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        List list2 = this.getClassFile2().getMethods();
        int n = list2.size();
        for (i2 = 0; i2 < n; ++i2) {
            MethodInfo minfo = (MethodInfo)list2.get(i2);
            table.put(minfo.getName(), this);
        }
        list2 = this.getClassFile2().getFields();
        n = list2.size();
        for (i2 = 0; i2 < n; ++i2) {
            FieldInfo finfo = (FieldInfo)list2.get(i2);
            table.put(finfo.getName(), this);
        }
    }
}

