/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ByteArray;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.AnnotationMemberValue;
import javassist.bytecode.annotation.AnnotationsWriter;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.ByteMemberValue;
import javassist.bytecode.annotation.CharMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.DoubleMemberValue;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.FloatMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.LongMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.ShortMemberValue;
import javassist.bytecode.annotation.StringMemberValue;

public class AnnotationsAttribute
extends AttributeInfo {
    public static final String visibleTag = "RuntimeVisibleAnnotations";
    public static final String invisibleTag = "RuntimeInvisibleAnnotations";

    public AnnotationsAttribute(ConstPool cp, String attrname, byte[] info) {
        super(cp, attrname, info);
    }

    public AnnotationsAttribute(ConstPool cp, String attrname) {
        this(cp, attrname, new byte[]{0, 0});
    }

    AnnotationsAttribute(ConstPool cp, int n, DataInputStream in) throws IOException {
        super(cp, n, in);
    }

    public int numAnnotations() {
        return ByteArray.readU16bit(this.info, 0);
    }

    public AttributeInfo copy(ConstPool newCp, Map classnames) {
        Copier copier = new Copier(this.info, this.constPool, newCp, classnames);
        try {
            copier.annotationArray();
            return new AnnotationsAttribute(newCp, this.getName(), copier.close());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Annotation getAnnotation(String type2) {
        Annotation[] annotations2 = this.getAnnotations();
        for (int i2 = 0; i2 < annotations2.length; ++i2) {
            if (!annotations2[i2].getTypeName().equals(type2)) continue;
            return annotations2[i2];
        }
        return null;
    }

    public void addAnnotation(Annotation annotation2) {
        String type2 = annotation2.getTypeName();
        Annotation[] annotations2 = this.getAnnotations();
        for (int i2 = 0; i2 < annotations2.length; ++i2) {
            if (!annotations2[i2].getTypeName().equals(type2)) continue;
            annotations2[i2] = annotation2;
            this.setAnnotations(annotations2);
            return;
        }
        Annotation[] newlist = new Annotation[annotations2.length + 1];
        System.arraycopy(annotations2, 0, newlist, 0, annotations2.length);
        newlist[annotations2.length] = annotation2;
        this.setAnnotations(newlist);
    }

    public Annotation[] getAnnotations() {
        try {
            return new Parser(this.info, this.constPool).parseAnnotations();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setAnnotations(Annotation[] annotations2) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        AnnotationsWriter writer = new AnnotationsWriter(output, this.constPool);
        try {
            int n = annotations2.length;
            writer.numAnnotations(n);
            for (int i2 = 0; i2 < n; ++i2) {
                annotations2[i2].write(writer);
            }
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.set(output.toByteArray());
    }

    public void setAnnotation(Annotation annotation2) {
        this.setAnnotations(new Annotation[]{annotation2});
    }

    void renameClass(String oldname, String newname) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(oldname, newname);
        this.renameClass(map);
    }

    void renameClass(Map classnames) {
        Renamer renamer = new Renamer(this.info, this.getConstPool(), classnames);
        try {
            renamer.annotationArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void getRefClasses(Map classnames) {
        this.renameClass(classnames);
    }

    public String toString() {
        Annotation[] a = this.getAnnotations();
        StringBuilder sbuf = new StringBuilder();
        int i2 = 0;
        while (i2 < a.length) {
            sbuf.append(a[i2++].toString());
            if (i2 == a.length) continue;
            sbuf.append(", ");
        }
        return sbuf.toString();
    }

    static class Parser
    extends Walker {
        ConstPool pool;
        Annotation[][] allParams;
        Annotation[] allAnno;
        Annotation currentAnno;
        MemberValue currentMember;

        Parser(byte[] info, ConstPool cp) {
            super(info);
            this.pool = cp;
        }

        Annotation[][] parseParameters() throws Exception {
            this.parameters();
            return this.allParams;
        }

        Annotation[] parseAnnotations() throws Exception {
            this.annotationArray();
            return this.allAnno;
        }

        MemberValue parseMemberValue() throws Exception {
            this.memberValue(0);
            return this.currentMember;
        }

        void parameters(int numParam, int pos2) throws Exception {
            Annotation[][] params2 = new Annotation[numParam][];
            for (int i2 = 0; i2 < numParam; ++i2) {
                pos2 = this.annotationArray(pos2);
                params2[i2] = this.allAnno;
            }
            this.allParams = params2;
        }

        int annotationArray(int pos2, int num) throws Exception {
            Annotation[] array = new Annotation[num];
            for (int i2 = 0; i2 < num; ++i2) {
                pos2 = this.annotation(pos2);
                array[i2] = this.currentAnno;
            }
            this.allAnno = array;
            return pos2;
        }

        int annotation(int pos2, int type2, int numPairs) throws Exception {
            this.currentAnno = new Annotation(type2, this.pool);
            return super.annotation(pos2, type2, numPairs);
        }

        int memberValuePair(int pos2, int nameIndex) throws Exception {
            pos2 = super.memberValuePair(pos2, nameIndex);
            this.currentAnno.addMemberValue(nameIndex, this.currentMember);
            return pos2;
        }

        void constValueMember(int tag2, int index2) throws Exception {
            MemberValue m;
            ConstPool cp = this.pool;
            switch (tag2) {
                case 66: {
                    m = new ByteMemberValue(index2, cp);
                    break;
                }
                case 67: {
                    m = new CharMemberValue(index2, cp);
                    break;
                }
                case 68: {
                    m = new DoubleMemberValue(index2, cp);
                    break;
                }
                case 70: {
                    m = new FloatMemberValue(index2, cp);
                    break;
                }
                case 73: {
                    m = new IntegerMemberValue(index2, cp);
                    break;
                }
                case 74: {
                    m = new LongMemberValue(index2, cp);
                    break;
                }
                case 83: {
                    m = new ShortMemberValue(index2, cp);
                    break;
                }
                case 90: {
                    m = new BooleanMemberValue(index2, cp);
                    break;
                }
                case 115: {
                    m = new StringMemberValue(index2, cp);
                    break;
                }
                default: {
                    throw new RuntimeException("unknown tag:" + tag2);
                }
            }
            this.currentMember = m;
            super.constValueMember(tag2, index2);
        }

        void enumMemberValue(int pos2, int typeNameIndex, int constNameIndex) throws Exception {
            this.currentMember = new EnumMemberValue(typeNameIndex, constNameIndex, this.pool);
            super.enumMemberValue(pos2, typeNameIndex, constNameIndex);
        }

        void classMemberValue(int pos2, int index2) throws Exception {
            this.currentMember = new ClassMemberValue(index2, this.pool);
            super.classMemberValue(pos2, index2);
        }

        int annotationMemberValue(int pos2) throws Exception {
            Annotation anno = this.currentAnno;
            pos2 = super.annotationMemberValue(pos2);
            this.currentMember = new AnnotationMemberValue(this.currentAnno, this.pool);
            this.currentAnno = anno;
            return pos2;
        }

        int arrayMemberValue(int pos2, int num) throws Exception {
            ArrayMemberValue amv = new ArrayMemberValue(this.pool);
            MemberValue[] elements = new MemberValue[num];
            for (int i2 = 0; i2 < num; ++i2) {
                pos2 = this.memberValue(pos2);
                elements[i2] = this.currentMember;
            }
            amv.setValue(elements);
            this.currentMember = amv;
            return pos2;
        }
    }

    static class Copier
    extends Walker {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        AnnotationsWriter writer;
        ConstPool srcPool;
        ConstPool destPool;
        Map classnames;

        Copier(byte[] info, ConstPool src, ConstPool dest, Map map) {
            super(info);
            this.writer = new AnnotationsWriter(this.output, dest);
            this.srcPool = src;
            this.destPool = dest;
            this.classnames = map;
        }

        byte[] close() throws IOException {
            this.writer.close();
            return this.output.toByteArray();
        }

        void parameters(int numParam, int pos2) throws Exception {
            this.writer.numParameters(numParam);
            super.parameters(numParam, pos2);
        }

        int annotationArray(int pos2, int num) throws Exception {
            this.writer.numAnnotations(num);
            return super.annotationArray(pos2, num);
        }

        int annotation(int pos2, int type2, int numPairs) throws Exception {
            this.writer.annotation(this.copyType(type2), numPairs);
            return super.annotation(pos2, type2, numPairs);
        }

        int memberValuePair(int pos2, int nameIndex) throws Exception {
            this.writer.memberValuePair(this.copy(nameIndex));
            return super.memberValuePair(pos2, nameIndex);
        }

        void constValueMember(int tag2, int index2) throws Exception {
            this.writer.constValueIndex(tag2, this.copy(index2));
            super.constValueMember(tag2, index2);
        }

        void enumMemberValue(int pos2, int typeNameIndex, int constNameIndex) throws Exception {
            this.writer.enumConstValue(this.copyType(typeNameIndex), this.copy(constNameIndex));
            super.enumMemberValue(pos2, typeNameIndex, constNameIndex);
        }

        void classMemberValue(int pos2, int index2) throws Exception {
            this.writer.classInfoIndex(this.copyType(index2));
            super.classMemberValue(pos2, index2);
        }

        int annotationMemberValue(int pos2) throws Exception {
            this.writer.annotationValue();
            return super.annotationMemberValue(pos2);
        }

        int arrayMemberValue(int pos2, int num) throws Exception {
            this.writer.arrayValue(num);
            return super.arrayMemberValue(pos2, num);
        }

        int copy(int srcIndex) {
            return this.srcPool.copy(srcIndex, this.destPool, this.classnames);
        }

        int copyType(int srcIndex) {
            String name2 = this.srcPool.getUtf8Info(srcIndex);
            String newName = Descriptor.rename(name2, this.classnames);
            return this.destPool.addUtf8Info(newName);
        }
    }

    static class Renamer
    extends Walker {
        ConstPool cpool;
        Map classnames;

        Renamer(byte[] info, ConstPool cp, Map map) {
            super(info);
            this.cpool = cp;
            this.classnames = map;
        }

        int annotation(int pos2, int type2, int numPairs) throws Exception {
            this.renameType(pos2 - 4, type2);
            return super.annotation(pos2, type2, numPairs);
        }

        void enumMemberValue(int pos2, int typeNameIndex, int constNameIndex) throws Exception {
            this.renameType(pos2 + 1, typeNameIndex);
            super.enumMemberValue(pos2, typeNameIndex, constNameIndex);
        }

        void classMemberValue(int pos2, int index2) throws Exception {
            this.renameType(pos2 + 1, index2);
            super.classMemberValue(pos2, index2);
        }

        private void renameType(int pos2, int index2) {
            String newName;
            String name2 = this.cpool.getUtf8Info(index2);
            if (!name2.equals(newName = Descriptor.rename(name2, this.classnames))) {
                int index22 = this.cpool.addUtf8Info(newName);
                ByteArray.write16bit(index22, this.info, pos2);
            }
        }
    }

    static class Walker {
        byte[] info;

        Walker(byte[] attrInfo) {
            this.info = attrInfo;
        }

        final void parameters() throws Exception {
            int numParam = this.info[0] & 0xFF;
            this.parameters(numParam, 1);
        }

        void parameters(int numParam, int pos2) throws Exception {
            for (int i2 = 0; i2 < numParam; ++i2) {
                pos2 = this.annotationArray(pos2);
            }
        }

        final void annotationArray() throws Exception {
            this.annotationArray(0);
        }

        final int annotationArray(int pos2) throws Exception {
            int num = ByteArray.readU16bit(this.info, pos2);
            return this.annotationArray(pos2 + 2, num);
        }

        int annotationArray(int pos2, int num) throws Exception {
            for (int i2 = 0; i2 < num; ++i2) {
                pos2 = this.annotation(pos2);
            }
            return pos2;
        }

        final int annotation(int pos2) throws Exception {
            int type2 = ByteArray.readU16bit(this.info, pos2);
            int numPairs = ByteArray.readU16bit(this.info, pos2 + 2);
            return this.annotation(pos2 + 4, type2, numPairs);
        }

        int annotation(int pos2, int type2, int numPairs) throws Exception {
            for (int j = 0; j < numPairs; ++j) {
                pos2 = this.memberValuePair(pos2);
            }
            return pos2;
        }

        final int memberValuePair(int pos2) throws Exception {
            int nameIndex = ByteArray.readU16bit(this.info, pos2);
            return this.memberValuePair(pos2 + 2, nameIndex);
        }

        int memberValuePair(int pos2, int nameIndex) throws Exception {
            return this.memberValue(pos2);
        }

        final int memberValue(int pos2) throws Exception {
            int tag2 = this.info[pos2] & 0xFF;
            if (tag2 == 101) {
                int typeNameIndex = ByteArray.readU16bit(this.info, pos2 + 1);
                int constNameIndex = ByteArray.readU16bit(this.info, pos2 + 3);
                this.enumMemberValue(pos2, typeNameIndex, constNameIndex);
                return pos2 + 5;
            }
            if (tag2 == 99) {
                int index2 = ByteArray.readU16bit(this.info, pos2 + 1);
                this.classMemberValue(pos2, index2);
                return pos2 + 3;
            }
            if (tag2 == 64) {
                return this.annotationMemberValue(pos2 + 1);
            }
            if (tag2 == 91) {
                int num = ByteArray.readU16bit(this.info, pos2 + 1);
                return this.arrayMemberValue(pos2 + 3, num);
            }
            int index3 = ByteArray.readU16bit(this.info, pos2 + 1);
            this.constValueMember(tag2, index3);
            return pos2 + 3;
        }

        void constValueMember(int tag2, int index2) throws Exception {
        }

        void enumMemberValue(int pos2, int typeNameIndex, int constNameIndex) throws Exception {
        }

        void classMemberValue(int pos2, int index2) throws Exception {
        }

        int annotationMemberValue(int pos2) throws Exception {
            return this.annotation(pos2);
        }

        int arrayMemberValue(int pos2, int num) throws Exception {
            for (int i2 = 0; i2 < num; ++i2) {
                pos2 = this.memberValue(pos2);
            }
            return pos2;
        }
    }
}

