/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javassist.bytecode.ConstPool;
import javassist.bytecode.ExceptionTableEntry;

public class ExceptionTable
implements Cloneable {
    private ConstPool constPool;
    private ArrayList entries;

    public ExceptionTable(ConstPool cp) {
        this.constPool = cp;
        this.entries = new ArrayList();
    }

    ExceptionTable(ConstPool cp, DataInputStream in) throws IOException {
        this.constPool = cp;
        int length2 = in.readUnsignedShort();
        ArrayList<ExceptionTableEntry> list2 = new ArrayList<ExceptionTableEntry>(length2);
        for (int i2 = 0; i2 < length2; ++i2) {
            int start2 = in.readUnsignedShort();
            int end2 = in.readUnsignedShort();
            int handle = in.readUnsignedShort();
            int type2 = in.readUnsignedShort();
            list2.add(new ExceptionTableEntry(start2, end2, handle, type2));
        }
        this.entries = list2;
    }

    public Object clone() throws CloneNotSupportedException {
        ExceptionTable r = (ExceptionTable)super.clone();
        r.entries = new ArrayList(this.entries);
        return r;
    }

    public int size() {
        return this.entries.size();
    }

    public int startPc(int nth) {
        ExceptionTableEntry e = (ExceptionTableEntry)this.entries.get(nth);
        return e.startPc;
    }

    public void setStartPc(int nth, int value2) {
        ExceptionTableEntry e = (ExceptionTableEntry)this.entries.get(nth);
        e.startPc = value2;
    }

    public int endPc(int nth) {
        ExceptionTableEntry e = (ExceptionTableEntry)this.entries.get(nth);
        return e.endPc;
    }

    public void setEndPc(int nth, int value2) {
        ExceptionTableEntry e = (ExceptionTableEntry)this.entries.get(nth);
        e.endPc = value2;
    }

    public int handlerPc(int nth) {
        ExceptionTableEntry e = (ExceptionTableEntry)this.entries.get(nth);
        return e.handlerPc;
    }

    public void setHandlerPc(int nth, int value2) {
        ExceptionTableEntry e = (ExceptionTableEntry)this.entries.get(nth);
        e.handlerPc = value2;
    }

    public int catchType(int nth) {
        ExceptionTableEntry e = (ExceptionTableEntry)this.entries.get(nth);
        return e.catchType;
    }

    public void setCatchType(int nth, int value2) {
        ExceptionTableEntry e = (ExceptionTableEntry)this.entries.get(nth);
        e.catchType = value2;
    }

    public void add(int index2, ExceptionTable table, int offset2) {
        int len = table.size();
        while (--len >= 0) {
            ExceptionTableEntry e = (ExceptionTableEntry)table.entries.get(len);
            this.add(index2, e.startPc + offset2, e.endPc + offset2, e.handlerPc + offset2, e.catchType);
        }
    }

    public void add(int index2, int start2, int end2, int handler, int type2) {
        if (start2 < end2) {
            this.entries.add(index2, new ExceptionTableEntry(start2, end2, handler, type2));
        }
    }

    public void add(int start2, int end2, int handler, int type2) {
        if (start2 < end2) {
            this.entries.add(new ExceptionTableEntry(start2, end2, handler, type2));
        }
    }

    public void remove(int index2) {
        this.entries.remove(index2);
    }

    public ExceptionTable copy(ConstPool newCp, Map classnames) {
        ExceptionTable et = new ExceptionTable(newCp);
        ConstPool srcCp = this.constPool;
        int len = this.size();
        for (int i2 = 0; i2 < len; ++i2) {
            ExceptionTableEntry e = (ExceptionTableEntry)this.entries.get(i2);
            int type2 = srcCp.copy(e.catchType, newCp, classnames);
            et.add(e.startPc, e.endPc, e.handlerPc, type2);
        }
        return et;
    }

    void shiftPc(int where, int gapLength, boolean exclusive2) {
        int len = this.size();
        for (int i2 = 0; i2 < len; ++i2) {
            ExceptionTableEntry e = (ExceptionTableEntry)this.entries.get(i2);
            e.startPc = ExceptionTable.shiftPc(e.startPc, where, gapLength, exclusive2);
            e.endPc = ExceptionTable.shiftPc(e.endPc, where, gapLength, exclusive2);
            e.handlerPc = ExceptionTable.shiftPc(e.handlerPc, where, gapLength, exclusive2);
        }
    }

    private static int shiftPc(int pc, int where, int gapLength, boolean exclusive2) {
        if (pc > where || exclusive2 && pc == where) {
            pc += gapLength;
        }
        return pc;
    }

    void write(DataOutputStream out) throws IOException {
        int len = this.size();
        out.writeShort(len);
        for (int i2 = 0; i2 < len; ++i2) {
            ExceptionTableEntry e = (ExceptionTableEntry)this.entries.get(i2);
            out.writeShort(e.startPc);
            out.writeShort(e.endPc);
            out.writeShort(e.handlerPc);
            out.writeShort(e.catchType);
        }
    }
}

