/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import java.io.PrintStream;
import javassist.CtMethod;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.Mnemonic;
import javassist.bytecode.Opcode;

public class InstructionPrinter
implements Opcode {
    private static final String[] opcodes = Mnemonic.OPCODE;
    private final PrintStream stream;

    public InstructionPrinter(PrintStream stream) {
        this.stream = stream;
    }

    public static void print(CtMethod method2, PrintStream stream) {
        new InstructionPrinter(stream).print(method2);
    }

    public void print(CtMethod method2) {
        MethodInfo info = method2.getMethodInfo2();
        ConstPool pool = info.getConstPool();
        CodeAttribute code = info.getCodeAttribute();
        if (code == null) {
            return;
        }
        CodeIterator iterator = code.iterator();
        while (iterator.hasNext()) {
            int pos2;
            try {
                pos2 = iterator.next();
            }
            catch (BadBytecode e) {
                throw new RuntimeException(e);
            }
            this.stream.println(pos2 + ": " + InstructionPrinter.instructionString(iterator, pos2, pool));
        }
    }

    public static String instructionString(CodeIterator iter, int pos2, ConstPool pool) {
        int opcode = iter.byteAt(pos2);
        if (opcode > opcodes.length || opcode < 0) {
            throw new IllegalArgumentException("Invalid opcode, opcode: " + opcode + " pos: " + pos2);
        }
        String opstring = opcodes[opcode];
        switch (opcode) {
            case 16: {
                return opstring + " " + iter.byteAt(pos2 + 1);
            }
            case 17: {
                return opstring + " " + iter.s16bitAt(pos2 + 1);
            }
            case 18: {
                return opstring + " " + InstructionPrinter.ldc(pool, iter.byteAt(pos2 + 1));
            }
            case 19: 
            case 20: {
                return opstring + " " + InstructionPrinter.ldc(pool, iter.u16bitAt(pos2 + 1));
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                return opstring + " " + iter.byteAt(pos2 + 1);
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 198: 
            case 199: {
                return opstring + " " + (iter.s16bitAt(pos2 + 1) + pos2);
            }
            case 132: {
                return opstring + " " + iter.byteAt(pos2 + 1);
            }
            case 167: 
            case 168: {
                return opstring + " " + (iter.s16bitAt(pos2 + 1) + pos2);
            }
            case 169: {
                return opstring + " " + iter.byteAt(pos2 + 1);
            }
            case 170: {
                return InstructionPrinter.tableSwitch(iter, pos2);
            }
            case 171: {
                return InstructionPrinter.lookupSwitch(iter, pos2);
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                return opstring + " " + InstructionPrinter.fieldInfo(pool, iter.u16bitAt(pos2 + 1));
            }
            case 182: 
            case 183: 
            case 184: {
                return opstring + " " + InstructionPrinter.methodInfo(pool, iter.u16bitAt(pos2 + 1));
            }
            case 185: {
                return opstring + " " + InstructionPrinter.interfaceMethodInfo(pool, iter.u16bitAt(pos2 + 1));
            }
            case 186: {
                throw new RuntimeException("Bad opcode 186");
            }
            case 187: {
                return opstring + " " + InstructionPrinter.classInfo(pool, iter.u16bitAt(pos2 + 1));
            }
            case 188: {
                return opstring + " " + InstructionPrinter.arrayInfo(iter.byteAt(pos2 + 1));
            }
            case 189: 
            case 192: {
                return opstring + " " + InstructionPrinter.classInfo(pool, iter.u16bitAt(pos2 + 1));
            }
            case 196: {
                return InstructionPrinter.wide(iter, pos2);
            }
            case 197: {
                return opstring + " " + InstructionPrinter.classInfo(pool, iter.u16bitAt(pos2 + 1));
            }
            case 200: 
            case 201: {
                return opstring + " " + (iter.s32bitAt(pos2 + 1) + pos2);
            }
        }
        return opstring;
    }

    private static String wide(CodeIterator iter, int pos2) {
        int opcode = iter.byteAt(pos2 + 1);
        int index2 = iter.u16bitAt(pos2 + 2);
        switch (opcode) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 132: 
            case 169: {
                return opcodes[opcode] + " " + index2;
            }
        }
        throw new RuntimeException("Invalid WIDE operand");
    }

    private static String arrayInfo(int type2) {
        switch (type2) {
            case 4: {
                return "boolean";
            }
            case 5: {
                return "char";
            }
            case 8: {
                return "byte";
            }
            case 9: {
                return "short";
            }
            case 10: {
                return "int";
            }
            case 11: {
                return "long";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "double";
            }
        }
        throw new RuntimeException("Invalid array type");
    }

    private static String classInfo(ConstPool pool, int index2) {
        return "#" + index2 + " = Class " + pool.getClassInfo(index2);
    }

    private static String interfaceMethodInfo(ConstPool pool, int index2) {
        return "#" + index2 + " = Method " + pool.getInterfaceMethodrefClassName(index2) + "." + pool.getInterfaceMethodrefName(index2) + "(" + pool.getInterfaceMethodrefType(index2) + ")";
    }

    private static String methodInfo(ConstPool pool, int index2) {
        return "#" + index2 + " = Method " + pool.getMethodrefClassName(index2) + "." + pool.getMethodrefName(index2) + "(" + pool.getMethodrefType(index2) + ")";
    }

    private static String fieldInfo(ConstPool pool, int index2) {
        return "#" + index2 + " = Field " + pool.getFieldrefClassName(index2) + "." + pool.getFieldrefName(index2) + "(" + pool.getFieldrefType(index2) + ")";
    }

    private static String lookupSwitch(CodeIterator iter, int pos2) {
        StringBuffer buffer = new StringBuffer("lookupswitch {\n");
        int index2 = (pos2 & 0xFFFFFFFC) + 4;
        buffer.append("\t\tdefault: ").append(pos2 + iter.s32bitAt(index2)).append("\n");
        int npairs = iter.s32bitAt(index2 += 4);
        int end2 = npairs * 8 + (index2 += 4);
        while (index2 < end2) {
            int match2 = iter.s32bitAt(index2);
            int target = iter.s32bitAt(index2 + 4) + pos2;
            buffer.append("\t\t").append(match2).append(": ").append(target).append("\n");
            index2 += 8;
        }
        buffer.setCharAt(buffer.length() - 1, '}');
        return buffer.toString();
    }

    private static String tableSwitch(CodeIterator iter, int pos2) {
        StringBuffer buffer = new StringBuffer("tableswitch {\n");
        int index2 = (pos2 & 0xFFFFFFFC) + 4;
        buffer.append("\t\tdefault: ").append(pos2 + iter.s32bitAt(index2)).append("\n");
        int low = iter.s32bitAt(index2 += 4);
        int high = iter.s32bitAt(index2 += 4);
        int end2 = (high - low + 1) * 4 + (index2 += 4);
        int key2 = low;
        while (index2 < end2) {
            int target = iter.s32bitAt(index2) + pos2;
            buffer.append("\t\t").append(key2).append(": ").append(target).append("\n");
            index2 += 4;
            ++key2;
        }
        buffer.setCharAt(buffer.length() - 1, '}');
        return buffer.toString();
    }

    private static String ldc(ConstPool pool, int index2) {
        int tag2 = pool.getTag(index2);
        switch (tag2) {
            case 8: {
                return "#" + index2 + " = \"" + pool.getStringInfo(index2) + "\"";
            }
            case 3: {
                return "#" + index2 + " = int " + pool.getIntegerInfo(index2);
            }
            case 4: {
                return "#" + index2 + " = float " + pool.getFloatInfo(index2);
            }
            case 5: {
                return "#" + index2 + " = long " + pool.getLongInfo(index2);
            }
            case 6: {
                return "#" + index2 + " = int " + pool.getDoubleInfo(index2);
            }
            case 7: {
                return InstructionPrinter.classInfo(pool, index2);
            }
        }
        throw new RuntimeException("bad LDC: " + tag2);
    }
}

