/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ByteArray;
import javassist.bytecode.ConstPool;

public class StackMap
extends AttributeInfo {
    public static final String tag = "StackMap";
    public static final int TOP = 0;
    public static final int INTEGER = 1;
    public static final int FLOAT = 2;
    public static final int DOUBLE = 3;
    public static final int LONG = 4;
    public static final int NULL = 5;
    public static final int THIS = 6;
    public static final int OBJECT = 7;
    public static final int UNINIT = 8;

    StackMap(ConstPool cp, byte[] newInfo) {
        super(cp, tag, newInfo);
    }

    StackMap(ConstPool cp, int name_id, DataInputStream in) throws IOException {
        super(cp, name_id, in);
    }

    public int numOfEntries() {
        return ByteArray.readU16bit(this.info, 0);
    }

    public AttributeInfo copy(ConstPool newCp, Map classnames) {
        Copier copier = new Copier(this, newCp, classnames);
        copier.visit();
        return copier.getStackMap();
    }

    public void insertLocal(int index2, int tag2, int classInfo) throws BadBytecode {
        byte[] data2 = new InsertLocal(this, index2, tag2, classInfo).doit();
        this.set(data2);
    }

    void shiftPc(int where, int gapSize, boolean exclusive2) throws BadBytecode {
        new Shifter(this, where, gapSize, exclusive2).visit();
    }

    public void removeNew(int where) throws CannotCompileException {
        byte[] data2 = new NewRemover(this, where).doit();
        this.set(data2);
    }

    public void print(PrintWriter out) {
        new Printer(this, out).print();
    }

    public static class Writer {
        private ByteArrayOutputStream output = new ByteArrayOutputStream();

        public byte[] toByteArray() {
            return this.output.toByteArray();
        }

        public StackMap toStackMap(ConstPool cp) {
            return new StackMap(cp, this.output.toByteArray());
        }

        public void writeVerifyTypeInfo(int tag2, int data2) {
            this.output.write(tag2);
            if (tag2 == 7 || tag2 == 8) {
                this.write16bit(data2);
            }
        }

        public void write16bit(int value2) {
            this.output.write(value2 >>> 8 & 0xFF);
            this.output.write(value2 & 0xFF);
        }
    }

    static class Printer
    extends Walker {
        private PrintWriter writer;

        public Printer(StackMap map, PrintWriter out) {
            super(map);
            this.writer = out;
        }

        public void print() {
            int num = ByteArray.readU16bit(this.info, 0);
            this.writer.println(num + " entries");
            this.visit();
        }

        public int locals(int pos2, int offset2, int num) {
            this.writer.println("  * offset " + offset2);
            return super.locals(pos2, offset2, num);
        }
    }

    static class NewRemover
    extends SimpleCopy {
        int posOfNew;

        NewRemover(StackMap map, int where) {
            super(map);
            this.posOfNew = where;
        }

        public int stack(int pos2, int offset2, int num) {
            return this.stackTypeInfoArray(pos2, offset2, num);
        }

        private int stackTypeInfoArray(int pos2, int offset2, int num) {
            int offsetOfNew;
            byte tag2;
            int k;
            int p2 = pos2;
            int count2 = 0;
            for (k = 0; k < num; ++k) {
                tag2 = this.info[p2];
                if (tag2 == 7) {
                    p2 += 3;
                    continue;
                }
                if (tag2 == 8) {
                    offsetOfNew = ByteArray.readU16bit(this.info, p2 + 1);
                    if (offsetOfNew == this.posOfNew) {
                        ++count2;
                    }
                    p2 += 3;
                    continue;
                }
                ++p2;
            }
            this.writer.write16bit(num - count2);
            for (k = 0; k < num; ++k) {
                tag2 = this.info[pos2];
                if (tag2 == 7) {
                    int clazz = ByteArray.readU16bit(this.info, pos2 + 1);
                    this.objectVariable(pos2, clazz);
                    pos2 += 3;
                    continue;
                }
                if (tag2 == 8) {
                    offsetOfNew = ByteArray.readU16bit(this.info, pos2 + 1);
                    if (offsetOfNew != this.posOfNew) {
                        this.uninitialized(pos2, offsetOfNew);
                    }
                    pos2 += 3;
                    continue;
                }
                this.typeInfo(pos2, tag2);
                ++pos2;
            }
            return pos2;
        }
    }

    static class Shifter
    extends Walker {
        private int where;
        private int gap;
        private boolean exclusive;

        public Shifter(StackMap smt, int where, int gap, boolean exclusive2) {
            super(smt);
            this.where = where;
            this.gap = gap;
            this.exclusive = exclusive2;
        }

        public int locals(int pos2, int offset2, int num) {
            if (this.exclusive ? this.where <= offset2 : this.where < offset2) {
                ByteArray.write16bit(offset2 + this.gap, this.info, pos2 - 4);
            }
            return super.locals(pos2, offset2, num);
        }
    }

    static class InsertLocal
    extends SimpleCopy {
        private int varIndex;
        private int varTag;
        private int varData;

        InsertLocal(StackMap map, int varIndex, int varTag, int varData) {
            super(map);
            this.varIndex = varIndex;
            this.varTag = varTag;
            this.varData = varData;
        }

        public int typeInfoArray(int pos2, int offset2, int num, boolean isLocals) {
            if (!isLocals || num < this.varIndex) {
                return super.typeInfoArray(pos2, offset2, num, isLocals);
            }
            this.writer.write16bit(num + 1);
            for (int k = 0; k < num; ++k) {
                if (k == this.varIndex) {
                    this.writeVarTypeInfo();
                }
                pos2 = this.typeInfoArray2(k, pos2);
            }
            if (num == this.varIndex) {
                this.writeVarTypeInfo();
            }
            return pos2;
        }

        private void writeVarTypeInfo() {
            if (this.varTag == 7) {
                this.writer.writeVerifyTypeInfo(7, this.varData);
            } else if (this.varTag == 8) {
                this.writer.writeVerifyTypeInfo(8, this.varData);
            } else {
                this.writer.writeVerifyTypeInfo(this.varTag, 0);
            }
        }
    }

    static class SimpleCopy
    extends Walker {
        Writer writer = new Writer();

        SimpleCopy(StackMap map) {
            super(map);
        }

        byte[] doit() {
            this.visit();
            return this.writer.toByteArray();
        }

        public void visit() {
            int num = ByteArray.readU16bit(this.info, 0);
            this.writer.write16bit(num);
            super.visit();
        }

        public int locals(int pos2, int offset2, int num) {
            this.writer.write16bit(offset2);
            return super.locals(pos2, offset2, num);
        }

        public int typeInfoArray(int pos2, int offset2, int num, boolean isLocals) {
            this.writer.write16bit(num);
            return super.typeInfoArray(pos2, offset2, num, isLocals);
        }

        public void typeInfo(int pos2, byte tag2) {
            this.writer.writeVerifyTypeInfo(tag2, 0);
        }

        public void objectVariable(int pos2, int clazz) {
            this.writer.writeVerifyTypeInfo(7, clazz);
        }

        public void uninitialized(int pos2, int offset2) {
            this.writer.writeVerifyTypeInfo(8, offset2);
        }
    }

    static class Copier
    extends Walker {
        byte[] dest;
        ConstPool srcCp;
        ConstPool destCp;
        Map classnames;

        Copier(StackMap map, ConstPool newCp, Map classnames) {
            super(map);
            this.srcCp = map.getConstPool();
            this.dest = new byte[this.info.length];
            this.destCp = newCp;
            this.classnames = classnames;
        }

        public void visit() {
            int num = ByteArray.readU16bit(this.info, 0);
            ByteArray.write16bit(num, this.dest, 0);
            super.visit();
        }

        public int locals(int pos2, int offset2, int num) {
            ByteArray.write16bit(offset2, this.dest, pos2 - 4);
            return super.locals(pos2, offset2, num);
        }

        public int typeInfoArray(int pos2, int offset2, int num, boolean isLocals) {
            ByteArray.write16bit(num, this.dest, pos2 - 2);
            return super.typeInfoArray(pos2, offset2, num, isLocals);
        }

        public void typeInfo(int pos2, byte tag2) {
            this.dest[pos2] = tag2;
        }

        public void objectVariable(int pos2, int clazz) {
            this.dest[pos2] = 7;
            int newClazz = this.srcCp.copy(clazz, this.destCp, this.classnames);
            ByteArray.write16bit(newClazz, this.dest, pos2 + 1);
        }

        public void uninitialized(int pos2, int offset2) {
            this.dest[pos2] = 8;
            ByteArray.write16bit(offset2, this.dest, pos2 + 1);
        }

        public StackMap getStackMap() {
            return new StackMap(this.destCp, this.dest);
        }
    }

    public static class Walker {
        byte[] info;

        public Walker(StackMap sm) {
            this.info = sm.get();
        }

        public void visit() {
            int num = ByteArray.readU16bit(this.info, 0);
            int pos2 = 2;
            for (int i2 = 0; i2 < num; ++i2) {
                int offset2 = ByteArray.readU16bit(this.info, pos2);
                int numLoc = ByteArray.readU16bit(this.info, pos2 + 2);
                pos2 = this.locals(pos2 + 4, offset2, numLoc);
                int numStack = ByteArray.readU16bit(this.info, pos2);
                pos2 = this.stack(pos2 + 2, offset2, numStack);
            }
        }

        public int locals(int pos2, int offset2, int num) {
            return this.typeInfoArray(pos2, offset2, num, true);
        }

        public int stack(int pos2, int offset2, int num) {
            return this.typeInfoArray(pos2, offset2, num, false);
        }

        public int typeInfoArray(int pos2, int offset2, int num, boolean isLocals) {
            for (int k = 0; k < num; ++k) {
                pos2 = this.typeInfoArray2(k, pos2);
            }
            return pos2;
        }

        int typeInfoArray2(int k, int pos2) {
            byte tag2 = this.info[pos2];
            if (tag2 == 7) {
                int clazz = ByteArray.readU16bit(this.info, pos2 + 1);
                this.objectVariable(pos2, clazz);
                pos2 += 3;
            } else if (tag2 == 8) {
                int offsetOfNew = ByteArray.readU16bit(this.info, pos2 + 1);
                this.uninitialized(pos2, offsetOfNew);
                pos2 += 3;
            } else {
                this.typeInfo(pos2, tag2);
                ++pos2;
            }
            return pos2;
        }

        public void typeInfo(int pos2, byte tag2) {
        }

        public void objectVariable(int pos2, int clazz) {
        }

        public void uninitialized(int pos2, int offset2) {
        }
    }
}

