/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode.analysis;

import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.bytecode.analysis.MultiType;
import javassist.bytecode.analysis.Type;

public class MultiArrayType
extends Type {
    private MultiType component;
    private int dims;

    public MultiArrayType(MultiType component, int dims) {
        super(null);
        this.component = component;
        this.dims = dims;
    }

    public CtClass getCtClass() {
        CtClass clazz = this.component.getCtClass();
        if (clazz == null) {
            return null;
        }
        ClassPool pool = clazz.getClassPool();
        if (pool == null) {
            pool = ClassPool.getDefault();
        }
        String name2 = this.arrayName(clazz.getName(), this.dims);
        try {
            return pool.get(name2);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    boolean popChanged() {
        return this.component.popChanged();
    }

    public int getDimensions() {
        return this.dims;
    }

    public Type getComponent() {
        return this.dims == 1 ? this.component : new MultiArrayType(this.component, this.dims - 1);
    }

    public int getSize() {
        return 1;
    }

    public boolean isArray() {
        return true;
    }

    public boolean isAssignableFrom(Type type2) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isReference() {
        return true;
    }

    public boolean isAssignableTo(Type type2) {
        if (MultiArrayType.eq(type2.getCtClass(), Type.OBJECT.getCtClass())) {
            return true;
        }
        if (MultiArrayType.eq(type2.getCtClass(), Type.CLONEABLE.getCtClass())) {
            return true;
        }
        if (MultiArrayType.eq(type2.getCtClass(), Type.SERIALIZABLE.getCtClass())) {
            return true;
        }
        if (!type2.isArray()) {
            return false;
        }
        Type typeRoot = this.getRootComponent(type2);
        int typeDims = type2.getDimensions();
        if (typeDims > this.dims) {
            return false;
        }
        if (typeDims < this.dims) {
            if (MultiArrayType.eq(typeRoot.getCtClass(), Type.OBJECT.getCtClass())) {
                return true;
            }
            if (MultiArrayType.eq(typeRoot.getCtClass(), Type.CLONEABLE.getCtClass())) {
                return true;
            }
            return MultiArrayType.eq(typeRoot.getCtClass(), Type.SERIALIZABLE.getCtClass());
        }
        return this.component.isAssignableTo(typeRoot);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MultiArrayType)) {
            return false;
        }
        MultiArrayType multi = (MultiArrayType)o;
        return this.component.equals(multi.component) && this.dims == multi.dims;
    }

    public String toString() {
        return this.arrayName(this.component.toString(), this.dims);
    }
}

