/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode.annotation;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationDefaultAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.MemberValue;

public class AnnotationImpl
implements InvocationHandler {
    private static final String JDK_ANNOTATION_CLASS_NAME = "java.lang.annotation.Annotation";
    private static Method JDK_ANNOTATION_TYPE_METHOD = null;
    private Annotation annotation;
    private ClassPool pool;
    private ClassLoader classLoader;
    private transient Class annotationType;
    private transient int cachedHashCode = Integer.MIN_VALUE;

    public static Object make(ClassLoader cl, Class clazz, ClassPool cp, Annotation anon) {
        AnnotationImpl handler = new AnnotationImpl(anon, cp, cl);
        return Proxy.newProxyInstance(cl, new Class[]{clazz}, (InvocationHandler)handler);
    }

    private AnnotationImpl(Annotation a, ClassPool cp, ClassLoader loader) {
        this.annotation = a;
        this.pool = cp;
        this.classLoader = loader;
    }

    public String getTypeName() {
        return this.annotation.getTypeName();
    }

    private Class getAnnotationType() {
        if (this.annotationType == null) {
            String typeName = this.annotation.getTypeName();
            try {
                this.annotationType = this.classLoader.loadClass(typeName);
            }
            catch (ClassNotFoundException e) {
                NoClassDefFoundError error2 = new NoClassDefFoundError("Error loading annotation class: " + typeName);
                error2.setStackTrace(e.getStackTrace());
                throw error2;
            }
        }
        return this.annotationType;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public Object invoke(Object proxy2, Method method2, Object[] args2) throws Throwable {
        MemberValue mv;
        String name2 = method2.getName();
        if (Object.class == method2.getDeclaringClass()) {
            if ("equals".equals(name2)) {
                Object obj = args2[0];
                return new Boolean(this.checkEquals(obj));
            }
            if ("toString".equals(name2)) {
                return this.annotation.toString();
            }
            if ("hashCode".equals(name2)) {
                return new Integer(this.hashCode());
            }
        } else if ("annotationType".equals(name2) && method2.getParameterTypes().length == 0) {
            return this.getAnnotationType();
        }
        if ((mv = this.annotation.getMemberValue(name2)) == null) {
            return this.getDefault(name2, method2);
        }
        return mv.getValue(this.classLoader, this.pool, method2);
    }

    private Object getDefault(String name2, Method method2) throws ClassNotFoundException, RuntimeException {
        String classname = this.annotation.getTypeName();
        if (this.pool != null) {
            try {
                AnnotationDefaultAttribute ainfo;
                CtClass cc = this.pool.get(classname);
                ClassFile cf = cc.getClassFile2();
                MethodInfo minfo = cf.getMethod(name2);
                if (minfo != null && (ainfo = (AnnotationDefaultAttribute)minfo.getAttribute("AnnotationDefault")) != null) {
                    MemberValue mv = ainfo.getDefaultValue();
                    return mv.getValue(this.classLoader, this.pool, method2);
                }
            }
            catch (NotFoundException e) {
                throw new RuntimeException("cannot find a class file: " + classname);
            }
        }
        throw new RuntimeException("no default value: " + classname + "." + name2 + "()");
    }

    public int hashCode() {
        if (this.cachedHashCode == Integer.MIN_VALUE) {
            int hashCode = 0;
            this.getAnnotationType();
            Method[] methods2 = this.annotationType.getDeclaredMethods();
            for (int i2 = 0; i2 < methods2.length; ++i2) {
                String name2 = methods2[i2].getName();
                int valueHashCode = 0;
                MemberValue mv = this.annotation.getMemberValue(name2);
                Object value2 = null;
                try {
                    if (mv != null) {
                        value2 = mv.getValue(this.classLoader, this.pool, methods2[i2]);
                    }
                    if (value2 == null) {
                        value2 = this.getDefault(name2, methods2[i2]);
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException("Error retrieving value " + name2 + " for annotation " + this.annotation.getTypeName(), e);
                }
                if (value2 != null) {
                    valueHashCode = value2.getClass().isArray() ? AnnotationImpl.arrayHashCode(value2) : value2.hashCode();
                }
                hashCode += 127 * name2.hashCode() ^ valueHashCode;
            }
            this.cachedHashCode = hashCode;
        }
        return this.cachedHashCode;
    }

    private boolean checkEquals(Object obj) throws Exception {
        InvocationHandler ih;
        if (obj == null) {
            return false;
        }
        if (obj instanceof Proxy && (ih = Proxy.getInvocationHandler(obj)) instanceof AnnotationImpl) {
            AnnotationImpl other = (AnnotationImpl)ih;
            return this.annotation.equals(other.annotation);
        }
        Class otherAnnotationType = (Class)JDK_ANNOTATION_TYPE_METHOD.invoke(obj, (Object[])null);
        if (!this.getAnnotationType().equals(otherAnnotationType)) {
            return false;
        }
        Method[] methods2 = this.annotationType.getDeclaredMethods();
        for (int i2 = 0; i2 < methods2.length; ++i2) {
            String name2 = methods2[i2].getName();
            MemberValue mv = this.annotation.getMemberValue(name2);
            Object value2 = null;
            Object otherValue = null;
            try {
                if (mv != null) {
                    value2 = mv.getValue(this.classLoader, this.pool, methods2[i2]);
                }
                if (value2 == null) {
                    value2 = this.getDefault(name2, methods2[i2]);
                }
                otherValue = methods2[i2].invoke(obj, (Object[])null);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("Error retrieving value " + name2 + " for annotation " + this.annotation.getTypeName(), e);
            }
            if (value2 == null && otherValue != null) {
                return false;
            }
            if (value2 == null || value2.equals(otherValue)) continue;
            return false;
        }
        return true;
    }

    private static int arrayHashCode(Object object) {
        if (object == null) {
            return 0;
        }
        int result2 = 1;
        Object[] array = (Object[])object;
        for (int i2 = 0; i2 < array.length; ++i2) {
            int elementHashCode = 0;
            if (array[i2] != null) {
                elementHashCode = array[i2].hashCode();
            }
            result2 = 31 * result2 + elementHashCode;
        }
        return result2;
    }

    static {
        try {
            Class<?> clazz = Class.forName(JDK_ANNOTATION_CLASS_NAME);
            JDK_ANNOTATION_TYPE_METHOD = clazz.getMethod("annotationType", null);
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }
}

