/*
 * Decompiled with CFR 0.152.
 */
package javassist.convert;

import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.Bytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.convert.TransformCall;
import javassist.convert.Transformer;

public class TransformBefore
extends TransformCall {
    protected CtClass[] parameterTypes;
    protected int locals;
    protected int maxLocals;
    protected byte[] saveCode;
    protected byte[] loadCode;

    public TransformBefore(Transformer next, CtMethod origMethod, CtMethod beforeMethod) throws NotFoundException {
        super(next, origMethod, beforeMethod);
        this.methodDescriptor = origMethod.getMethodInfo2().getDescriptor();
        this.parameterTypes = origMethod.getParameterTypes();
        this.locals = 0;
        this.maxLocals = 0;
        this.loadCode = null;
        this.saveCode = null;
    }

    public void initialize(ConstPool cp, CodeAttribute attr2) {
        super.initialize(cp, attr2);
        this.locals = 0;
        this.maxLocals = attr2.getMaxLocals();
        this.loadCode = null;
        this.saveCode = null;
    }

    protected int match(int c, int pos2, CodeIterator iterator, int typedesc, ConstPool cp) throws BadBytecode {
        if (this.newIndex == 0) {
            String desc = Descriptor.ofParameters(this.parameterTypes) + 'V';
            desc = Descriptor.insertParameter(this.classname, desc);
            int nt = cp.addNameAndTypeInfo(this.newMethodname, desc);
            int ci = cp.addClassInfo(this.newClassname);
            this.newIndex = cp.addMethodrefInfo(ci, nt);
            this.constPool = cp;
        }
        if (this.saveCode == null) {
            this.makeCode(this.parameterTypes, cp);
        }
        return this.match2(pos2, iterator);
    }

    protected int match2(int pos2, CodeIterator iterator) throws BadBytecode {
        iterator.move(pos2);
        iterator.insert(this.saveCode);
        iterator.insert(this.loadCode);
        int p2 = iterator.insertGap(3);
        iterator.writeByte(184, p2);
        iterator.write16bit(this.newIndex, p2 + 1);
        iterator.insert(this.loadCode);
        return iterator.next();
    }

    public int extraLocals() {
        return this.locals;
    }

    protected void makeCode(CtClass[] paramTypes, ConstPool cp) {
        Bytecode save = new Bytecode(cp, 0, 0);
        Bytecode load2 = new Bytecode(cp, 0, 0);
        int var = this.maxLocals;
        int len = paramTypes == null ? 0 : paramTypes.length;
        load2.addAload(var);
        this.makeCode2(save, load2, 0, len, paramTypes, var + 1);
        save.addAstore(var);
        this.saveCode = save.get();
        this.loadCode = load2.get();
    }

    private void makeCode2(Bytecode save, Bytecode load2, int i2, int n, CtClass[] paramTypes, int var) {
        if (i2 < n) {
            int size2 = load2.addLoad(var, paramTypes[i2]);
            this.makeCode2(save, load2, i2 + 1, n, paramTypes, var + size2);
            save.addStore(var, paramTypes[i2]);
        } else {
            this.locals = var - this.maxLocals;
        }
    }
}

