/*
 * Decompiled with CFR 0.152.
 */
package javassist.util.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import javassist.util.proxy.ProxyFactory;

public class ProxyObjectInputStream
extends ObjectInputStream {
    private ClassLoader loader = Thread.currentThread().getContextClassLoader();

    public ProxyObjectInputStream(InputStream in) throws IOException {
        super(in);
        if (this.loader == null) {
            this.loader = ClassLoader.getSystemClassLoader();
        }
    }

    public void setClassLoader(ClassLoader loader) {
        if (loader != null) {
            this.loader = loader;
        } else {
            loader = ClassLoader.getSystemClassLoader();
        }
    }

    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        boolean isProxy = this.readBoolean();
        if (isProxy) {
            String name2 = (String)this.readObject();
            Class<?> superClass = this.loader.loadClass(name2);
            int length2 = this.readInt();
            Class[] interfaces2 = new Class[length2];
            for (int i2 = 0; i2 < length2; ++i2) {
                name2 = (String)this.readObject();
                interfaces2[i2] = this.loader.loadClass(name2);
            }
            length2 = this.readInt();
            byte[] signature = new byte[length2];
            this.read(signature);
            ProxyFactory factory = new ProxyFactory();
            factory.setUseCache(true);
            factory.setUseWriteReplace(false);
            factory.setSuperclass(superClass);
            factory.setInterfaces(interfaces2);
            Class proxyClass = factory.createClass(signature);
            return ObjectStreamClass.lookup(proxyClass);
        }
        return super.readClassDescriptor();
    }
}

