/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Arrays;
import jnr.ffi.Runtime;
import jnr.ffi.provider.AbstractMemoryIO;
import jnr.ffi.util.BufferUtil;

public abstract class AbstractArrayMemoryIO
extends AbstractMemoryIO {
    private final ArrayIO io;
    protected final byte[] buffer;
    protected final int offset;
    protected final int length;

    protected AbstractArrayMemoryIO(Runtime runtime, byte[] buffer, int offset2, int length2) {
        super(runtime);
        this.io = ArrayIO.getArrayIO(runtime);
        this.buffer = buffer;
        this.offset = offset2;
        this.length = length2;
    }

    protected AbstractArrayMemoryIO(Runtime runtime, byte[] buffer) {
        this(runtime, buffer, 0, buffer.length);
    }

    protected AbstractArrayMemoryIO(Runtime runtime, int size2) {
        this(runtime, new byte[size2], 0, size2);
    }

    protected final ArrayIO getArrayIO() {
        return this.io;
    }

    public final byte[] array() {
        return this.buffer;
    }

    public final int offset() {
        return this.offset;
    }

    public final int length() {
        return this.length;
    }

    public final int arrayLength() {
        return this.length;
    }

    public final int arrayOffset() {
        return this.offset;
    }

    public final boolean hasArray() {
        return true;
    }

    public final boolean isDirect() {
        return false;
    }

    public final long address() {
        return 0L;
    }

    public final long size() {
        return this.length;
    }

    protected final int index(long off) {
        return this.offset + (int)off;
    }

    protected final int remaining(long offset2) {
        return this.length - (int)offset2;
    }

    public final boolean isNull() {
        return false;
    }

    public String getString(long offset2) {
        return BufferUtil.getString(ByteBuffer.wrap(this.buffer, this.index(offset2), this.length - (int)offset2), Charset.defaultCharset());
    }

    public String getString(long offset2, int maxLength, Charset cs) {
        return BufferUtil.getString(ByteBuffer.wrap(this.buffer, this.index(offset2), Math.min(this.length - (int)offset2, maxLength)), cs);
    }

    public void putString(long offset2, String string2, int maxLength, Charset cs) {
        ByteBuffer buf = cs.encode(string2);
        int len = Math.min(maxLength - 1, Math.min(buf.remaining(), this.remaining(offset2)));
        buf.get(this.buffer, this.index(offset2), len);
        this.buffer[this.index((long)offset2) + len] = 0;
    }

    public void putZeroTerminatedByteArray(long offset2, byte[] src, int off, int len) {
        System.arraycopy(src, off, this.buffer, this.index(offset2), this.length - (int)offset2);
        this.buffer[this.index((long)offset2) + len] = 0;
    }

    public final byte getByte(long offset2) {
        return (byte)(this.buffer[this.index(offset2)] & 0xFF);
    }

    public final short getShort(long offset2) {
        return this.io.getInt16(this.buffer, this.index(offset2));
    }

    public final int getInt(long offset2) {
        return this.io.getInt32(this.buffer, this.index(offset2));
    }

    public final long getLongLong(long offset2) {
        return this.io.getInt64(this.buffer, this.index(offset2));
    }

    public final long getAddress(long offset2) {
        return this.io.getAddress(this.buffer, this.index(offset2));
    }

    public final float getFloat(long offset2) {
        return this.io.getFloat32(this.buffer, this.index(offset2));
    }

    public final double getDouble(long offset2) {
        return this.io.getFloat64(this.buffer, this.index(offset2));
    }

    public final void putByte(long offset2, byte value2) {
        this.buffer[this.index((long)offset2)] = value2;
    }

    public final void putShort(long offset2, short value2) {
        this.io.putInt16(this.buffer, this.index(offset2), value2);
    }

    public final void putInt(long offset2, int value2) {
        this.io.putInt32(this.buffer, this.index(offset2), value2);
    }

    public final void putLongLong(long offset2, long value2) {
        this.io.putInt64(this.buffer, this.index(offset2), value2);
    }

    public final void putAddress(long offset2, long value2) {
        this.io.putAddress(this.buffer, this.index(offset2), value2);
    }

    public final void putFloat(long offset2, float value2) {
        this.io.putFloat32(this.buffer, this.index(offset2), value2);
    }

    public final void putDouble(long offset2, double value2) {
        this.io.putFloat64(this.buffer, this.index(offset2), value2);
    }

    public final void get(long offset2, byte[] dst, int off, int len) {
        System.arraycopy(this.buffer, this.index(offset2), dst, off, len);
    }

    public final void put(long offset2, byte[] src, int off, int len) {
        System.arraycopy(src, off, this.buffer, this.index(offset2), len);
    }

    public final void get(long offset2, short[] dst, int off, int len) {
        int begin2 = this.index(offset2);
        for (int i2 = 0; i2 < len; ++i2) {
            dst[off + i2] = this.io.getInt16(this.buffer, begin2 + (i2 << 1));
        }
    }

    public final void put(long offset2, short[] src, int off, int len) {
        int begin2 = this.index(offset2);
        for (int i2 = 0; i2 < len; ++i2) {
            this.io.putInt16(this.buffer, begin2 + (i2 << 1), src[off + i2]);
        }
    }

    public final void get(long offset2, int[] dst, int off, int len) {
        int begin2 = this.index(offset2);
        for (int i2 = 0; i2 < len; ++i2) {
            dst[off + i2] = this.io.getInt32(this.buffer, begin2 + (i2 << 2));
        }
    }

    public final void put(long offset2, int[] src, int off, int len) {
        int begin2 = this.index(offset2);
        for (int i2 = 0; i2 < len; ++i2) {
            this.io.putInt32(this.buffer, begin2 + (i2 << 2), src[off + i2]);
        }
    }

    public final void get(long offset2, long[] dst, int off, int len) {
        int begin2 = this.index(offset2);
        for (int i2 = 0; i2 < len; ++i2) {
            dst[off + i2] = this.io.getInt64(this.buffer, begin2 + (i2 << 3));
        }
    }

    public final void put(long offset2, long[] src, int off, int len) {
        int begin2 = this.index(offset2);
        for (int i2 = 0; i2 < len; ++i2) {
            this.io.putInt64(this.buffer, begin2 + (i2 << 3), src[off + i2]);
        }
    }

    public final void get(long offset2, float[] dst, int off, int len) {
        int begin2 = this.index(offset2);
        for (int i2 = 0; i2 < len; ++i2) {
            dst[off + i2] = this.io.getFloat32(this.buffer, begin2 + (i2 << 2));
        }
    }

    public final void put(long offset2, float[] src, int off, int len) {
        int begin2 = this.index(offset2);
        for (int i2 = 0; i2 < len; ++i2) {
            this.io.putFloat32(this.buffer, begin2 + (i2 << 2), src[off + i2]);
        }
    }

    public final void get(long offset2, double[] dst, int off, int len) {
        int begin2 = this.index(offset2);
        for (int i2 = 0; i2 < len; ++i2) {
            dst[off + i2] = this.io.getFloat64(this.buffer, begin2 + (i2 << 3));
        }
    }

    public final void put(long offset2, double[] src, int off, int len) {
        int begin2 = this.index(offset2);
        for (int i2 = 0; i2 < len; ++i2) {
            this.io.putFloat64(this.buffer, begin2 + (i2 << 3), src[off + i2]);
        }
    }

    public final int indexOf(long offset2, byte value2) {
        int off = this.index(offset2);
        for (int i2 = 0; i2 < this.length; ++i2) {
            if (this.buffer[off + i2] != value2) continue;
            return i2;
        }
        return -1;
    }

    public final int indexOf(long offset2, byte value2, int maxlen) {
        int off = this.index(offset2);
        for (int i2 = 0; i2 < Math.min(this.length, maxlen); ++i2) {
            if (this.buffer[off + i2] != value2) continue;
            return i2;
        }
        return -1;
    }

    public final void setMemory(long offset2, long size2, byte value2) {
        Arrays.fill(this.buffer, this.index(offset2), (int)size2, value2);
    }

    public final void clear() {
        Arrays.fill(this.buffer, this.offset, this.length, (byte)0);
    }

    private static final class BE64ArrayIO
    extends BigEndianArrayIO {
        public static final ArrayIO INSTANCE = new BE64ArrayIO();

        private BE64ArrayIO() {
        }

        public final long getAddress(byte[] buffer, int offset2) {
            return this.getInt64(buffer, offset2);
        }

        public final void putAddress(byte[] buffer, int offset2, long value2) {
            this.putInt64(buffer, offset2, value2);
        }
    }

    private static final class BE32ArrayIO
    extends BigEndianArrayIO {
        public static final ArrayIO INSTANCE = new BE32ArrayIO();

        private BE32ArrayIO() {
        }

        public final long getAddress(byte[] buffer, int offset2) {
            return (long)this.getInt32(buffer, offset2) & 0xFFFFFFFFL;
        }

        public final void putAddress(byte[] buffer, int offset2, long value2) {
            this.putInt32(buffer, offset2, (int)value2);
        }
    }

    private static final class LE64ArrayIO
    extends LittleEndianArrayIO {
        public static final ArrayIO INSTANCE = new LE64ArrayIO();

        private LE64ArrayIO() {
        }

        public final long getAddress(byte[] buffer, int offset2) {
            return this.getInt64(buffer, offset2);
        }

        public final void putAddress(byte[] buffer, int offset2, long value2) {
            this.putInt64(buffer, offset2, value2);
        }
    }

    private static final class LE32ArrayIO
    extends LittleEndianArrayIO {
        public static final ArrayIO INSTANCE = new LE32ArrayIO();

        private LE32ArrayIO() {
        }

        public final long getAddress(byte[] buffer, int offset2) {
            return (long)this.getInt32(buffer, offset2) & 0xFFFFFFFFL;
        }

        public final void putAddress(byte[] buffer, int offset2, long value2) {
            this.putInt32(buffer, offset2, (int)value2);
        }
    }

    private static abstract class BigEndianArrayIO
    extends ArrayIO {
        private BigEndianArrayIO() {
        }

        public short getInt16(byte[] array, int offset2) {
            return (short)((array[offset2 + 0] & 0xFF) << 8 | array[offset2 + 1] & 0xFF);
        }

        public int getInt32(byte[] array, int offset2) {
            return (array[offset2 + 0] & 0xFF) << 24 | (array[offset2 + 1] & 0xFF) << 16 | (array[offset2 + 2] & 0xFF) << 8 | (array[offset2 + 3] & 0xFF) << 0;
        }

        public long getInt64(byte[] array, int offset2) {
            return ((long)array[offset2 + 0] & 0xFFL) << 56 | ((long)array[offset2 + 1] & 0xFFL) << 48 | ((long)array[offset2 + 2] & 0xFFL) << 40 | ((long)array[offset2 + 3] & 0xFFL) << 32 | ((long)array[offset2 + 4] & 0xFFL) << 24 | ((long)array[offset2 + 5] & 0xFFL) << 16 | ((long)array[offset2 + 6] & 0xFFL) << 8 | ((long)array[offset2 + 7] & 0xFFL) << 0;
        }

        public final void putInt16(byte[] buffer, int offset2, int value2) {
            buffer[offset2 + 0] = (byte)(value2 >> 8);
            buffer[offset2 + 1] = (byte)(value2 >> 0);
        }

        public final void putInt32(byte[] buffer, int offset2, int value2) {
            buffer[offset2 + 0] = (byte)(value2 >> 24);
            buffer[offset2 + 1] = (byte)(value2 >> 16);
            buffer[offset2 + 2] = (byte)(value2 >> 8);
            buffer[offset2 + 3] = (byte)(value2 >> 0);
        }

        public final void putInt64(byte[] buffer, int offset2, long value2) {
            buffer[offset2 + 0] = (byte)(value2 >> 56);
            buffer[offset2 + 1] = (byte)(value2 >> 48);
            buffer[offset2 + 2] = (byte)(value2 >> 40);
            buffer[offset2 + 3] = (byte)(value2 >> 32);
            buffer[offset2 + 4] = (byte)(value2 >> 24);
            buffer[offset2 + 5] = (byte)(value2 >> 16);
            buffer[offset2 + 6] = (byte)(value2 >> 8);
            buffer[offset2 + 7] = (byte)(value2 >> 0);
        }
    }

    private static abstract class LittleEndianArrayIO
    extends ArrayIO {
        private LittleEndianArrayIO() {
        }

        public final short getInt16(byte[] array, int offset2) {
            return (short)(array[offset2] & 0xFF | (array[offset2 + 1] & 0xFF) << 8);
        }

        public final int getInt32(byte[] array, int offset2) {
            return (array[offset2 + 0] & 0xFF) << 0 | (array[offset2 + 1] & 0xFF) << 8 | (array[offset2 + 2] & 0xFF) << 16 | (array[offset2 + 3] & 0xFF) << 24;
        }

        public final long getInt64(byte[] array, int offset2) {
            return ((long)array[offset2 + 0] & 0xFFL) << 0 | ((long)array[offset2 + 1] & 0xFFL) << 8 | ((long)array[offset2 + 2] & 0xFFL) << 16 | ((long)array[offset2 + 3] & 0xFFL) << 24 | ((long)array[offset2 + 4] & 0xFFL) << 32 | ((long)array[offset2 + 5] & 0xFFL) << 40 | ((long)array[offset2 + 6] & 0xFFL) << 48 | ((long)array[offset2 + 7] & 0xFFL) << 56;
        }

        public final void putInt16(byte[] buffer, int offset2, int value2) {
            buffer[offset2 + 0] = (byte)(value2 >> 0);
            buffer[offset2 + 1] = (byte)(value2 >> 8);
        }

        public final void putInt32(byte[] buffer, int offset2, int value2) {
            buffer[offset2 + 0] = (byte)(value2 >> 0);
            buffer[offset2 + 1] = (byte)(value2 >> 8);
            buffer[offset2 + 2] = (byte)(value2 >> 16);
            buffer[offset2 + 3] = (byte)(value2 >> 24);
        }

        public final void putInt64(byte[] buffer, int offset2, long value2) {
            buffer[offset2 + 0] = (byte)(value2 >> 0);
            buffer[offset2 + 1] = (byte)(value2 >> 8);
            buffer[offset2 + 2] = (byte)(value2 >> 16);
            buffer[offset2 + 3] = (byte)(value2 >> 24);
            buffer[offset2 + 4] = (byte)(value2 >> 32);
            buffer[offset2 + 5] = (byte)(value2 >> 40);
            buffer[offset2 + 6] = (byte)(value2 >> 48);
            buffer[offset2 + 7] = (byte)(value2 >> 56);
        }
    }

    protected static abstract class ArrayIO {
        protected ArrayIO() {
        }

        public static final ArrayIO getArrayIO(Runtime runtime) {
            if (runtime.byteOrder().equals(ByteOrder.BIG_ENDIAN)) {
                return runtime.addressSize() == 8 ? BE64ArrayIO.INSTANCE : BE32ArrayIO.INSTANCE;
            }
            return runtime.addressSize() == 8 ? LE64ArrayIO.INSTANCE : LE32ArrayIO.INSTANCE;
        }

        public abstract short getInt16(byte[] var1, int var2);

        public abstract int getInt32(byte[] var1, int var2);

        public abstract long getInt64(byte[] var1, int var2);

        public abstract long getAddress(byte[] var1, int var2);

        public abstract void putInt16(byte[] var1, int var2, int var3);

        public abstract void putInt32(byte[] var1, int var2, int var3);

        public abstract void putInt64(byte[] var1, int var2, long var3);

        public abstract void putAddress(byte[] var1, int var2, long var3);

        public final float getFloat32(byte[] buffer, int offset2) {
            return Float.intBitsToFloat(this.getInt32(buffer, offset2));
        }

        public final void putFloat32(byte[] buffer, int offset2, float value2) {
            this.putInt32(buffer, offset2, Float.floatToRawIntBits(value2));
        }

        public final double getFloat64(byte[] buffer, int offset2) {
            return Double.longBitsToDouble(this.getInt64(buffer, offset2));
        }

        public final void putFloat64(byte[] buffer, int offset2, double value2) {
            this.putInt64(buffer, offset2, Double.doubleToRawLongBits(value2));
        }
    }
}

