/*
 * Decompiled with CFR 0.152.
 */
package json.ext;

import json.ext.ByteListTranscoder;
import json.ext.Utils;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.ThreadContext;
import org.jruby.util.ByteList;

final class StringDecoder
extends ByteListTranscoder {
    private int surrogatePairStart = -1;
    private final byte[] aux = new byte[4];

    StringDecoder(ThreadContext threadContext) {
        super(threadContext);
    }

    ByteList decode(ByteList byteList, int n, int n2) {
        ByteList byteList2 = new ByteList(n2 - n);
        byteList2.setEncoding(byteList.getEncoding());
        this.init(byteList, n, n2, byteList2);
        while (this.hasNext()) {
            this.handleChar(this.readUtf8Char());
        }
        this.quoteStop(this.pos);
        return byteList2;
    }

    private void handleChar(int n) {
        if (n == 92) {
            this.quoteStop(this.charStart);
            this.handleEscapeSequence();
        } else {
            this.quoteStart();
        }
    }

    private void handleEscapeSequence() {
        this.ensureMin(1);
        switch (this.readUtf8Char()) {
            case 98: {
                this.append(8);
                break;
            }
            case 102: {
                this.append(12);
                break;
            }
            case 110: {
                this.append(10);
                break;
            }
            case 114: {
                this.append(13);
                break;
            }
            case 116: {
                this.append(9);
                break;
            }
            case 117: {
                this.ensureMin(4);
                int n = this.readHex();
                if (Character.isHighSurrogate((char)n)) {
                    this.handleLowSurrogate((char)n);
                    break;
                }
                if (Character.isLowSurrogate((char)n)) {
                    throw this.invalidUtf8();
                }
                this.writeUtf8Char(n);
                break;
            }
            default: {
                this.quoteStart();
            }
        }
    }

    private void handleLowSurrogate(char c) {
        this.surrogatePairStart = this.charStart;
        this.ensureMin(1);
        int n = this.readUtf8Char();
        if (n == 92) {
            this.ensureMin(5);
            if (this.readUtf8Char() != 117) {
                throw this.invalidUtf8();
            }
            n = this.readHex();
        }
        if (!Character.isLowSurrogate((char)n)) {
            throw this.invalidUtf8();
        }
        this.writeUtf8Char(Character.toCodePoint(c, (char)n));
        this.surrogatePairStart = -1;
    }

    private void writeUtf8Char(int n) {
        if (n < 128) {
            this.append(n);
        } else if (n < 2048) {
            this.aux[0] = (byte)(0xC0 | n >>> 6);
            this.aux[1] = this.tailByte(n & 0x3F);
            this.append(this.aux, 0, 2);
        } else if (n < 65536) {
            this.aux[0] = (byte)(0xE0 | n >>> 12);
            this.aux[1] = this.tailByte(n >>> 6);
            this.aux[2] = this.tailByte(n);
            this.append(this.aux, 0, 3);
        } else {
            this.aux[0] = (byte)(0xF0 | n >>> 18);
            this.aux[1] = this.tailByte(n >>> 12);
            this.aux[2] = this.tailByte(n >>> 6);
            this.aux[3] = this.tailByte(n);
            this.append(this.aux, 0, 4);
        }
    }

    private byte tailByte(int n) {
        return (byte)(0x80 | n & 0x3F);
    }

    private int readHex() {
        int n = this.pos;
        int n2 = 0;
        int n3 = 4;
        for (int j = 0; j < n3; ++j) {
            int n4;
            int n5 = this.readUtf8Char();
            if (n5 >= 48 && n5 <= 57) {
                n4 = n5 - 48;
            } else if (n5 >= 97 && n5 <= 102) {
                n4 = 10 + n5 - 97;
            } else if (n5 >= 65 && n5 <= 70) {
                n4 = 10 + n5 - 65;
            } else {
                throw new NumberFormatException("Invalid base 16 number " + this.src.subSequence(n, n + n3));
            }
            n2 = n2 * 16 + n4;
        }
        return n2;
    }

    protected RaiseException invalidUtf8() {
        ByteList byteList = new ByteList(ByteList.plain("partial character in source, but hit end near "));
        int n = this.surrogatePairStart != -1 ? this.surrogatePairStart : this.charStart;
        byteList.append(this.src, n, this.srcEnd - n);
        return Utils.newException(this.context, "ParserError", this.context.getRuntime().newString(byteList));
    }
}

