/*
 * Decompiled with CFR 0.152.
 */
package nokogiri.internals;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import nokogiri.internals.ClosedStreamException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NokogiriBlockingQueueInputStream
extends InputStream {
    private final LinkedBlockingQueue<Task> queue = new LinkedBlockingQueue();
    protected Task currentTask;
    protected ByteArrayInputStream currentStream;
    protected int position;
    protected boolean closed = false;
    public static final ByteArrayInputStream END = new ByteArrayInputStream(new byte[0]);

    @Override
    public synchronized void close() {
        this.closed = true;
        LinkedList<Task> linkedList = new LinkedList<Task>();
        this.queue.drainTo(linkedList);
        linkedList.add(this.currentTask);
        for (Task task : linkedList) {
            task.set(null);
        }
    }

    public synchronized Future<Void> addChunk(ByteArrayInputStream byteArrayInputStream) throws ClosedStreamException {
        if (this.closed) {
            throw new ClosedStreamException("Cannot add a chunk to a closed stream");
        }
        Task task = new Task(byteArrayInputStream);
        this.queue.add(task);
        return task;
    }

    @Override
    public int read() throws IOException {
        if ((this.currentTask == null || this.currentStream.available() == 0) && this.getNextTask() == -1) {
            return -1;
        }
        return this.currentStream.read();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        if ((this.currentTask == null || this.currentStream.available() == 0) && this.getNextTask() == -1) {
            this.currentTask.set(null);
            return -1;
        }
        return this.currentStream.read(byArray, n, n2);
    }

    protected int getNextTask() {
        while (true) {
            try {
                if (this.currentTask != null) {
                    this.currentTask.set(null);
                }
                this.currentTask = this.queue.take();
                this.currentStream = this.currentTask.getStream();
                return this.currentStream.available() == 0 ? -1 : this.currentStream.available();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Task
    extends FutureTask<Void> {
        private final ByteArrayInputStream stream;

        public Task(ByteArrayInputStream byteArrayInputStream) {
            super(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    return null;
                }
            });
            this.stream = byteArrayInputStream;
        }

        public ByteArrayInputStream getStream() {
            return this.stream;
        }

        @Override
        public void run() {
        }

        @Override
        public boolean runAndReset() {
            return true;
        }

        @Override
        public void set(Void void_) {
            super.set(void_);
        }
    }
}

