/*
 * Decompiled with CFR 0.152.
 */
package nokogiri.internals;

import java.io.InputStream;
import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class NokogiriEncodingReaderWrapper
extends InputStream {
    private final ThreadContext context;
    private final IRubyObject encodingReader;
    private final Ruby ruby;
    private IRubyObject detectedEncoding;
    private final byte[] firstChunk = new byte[1024];
    private int firstChunkOff = 0;
    private int firstChunkLength = 0;

    public NokogiriEncodingReaderWrapper(ThreadContext threadContext, RubyObject rubyObject) {
        this.context = threadContext;
        this.encodingReader = rubyObject;
        this.ruby = threadContext.getRuntime();
        if (!RuntimeHelpers.invoke(threadContext, (IRubyObject)rubyObject, "respond_to?", this.ruby.newSymbol("read").to_sym()).isTrue() || rubyObject.getInstanceVariable("@io") == null) {
            throw this.ruby.newArgumentError("Argument doesn't respond to read or doesn't have instance variable @io");
        }
    }

    public boolean detectEncoding() {
        try {
            this.firstChunkLength = this.read(this.firstChunk);
        }
        catch (RaiseException raiseException) {
            this.detectedEncoding = raiseException.getException().getInstanceVariable("@found_encoding");
            return true;
        }
        this.detectedEncoding = this.context.nil;
        return false;
    }

    public IRubyObject getEncoding() {
        return this.detectedEncoding;
    }

    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = Math.min(this.firstChunkLength - this.firstChunkOff, n2);
        if (n3 > 0) {
            System.arraycopy(this.firstChunk, this.firstChunkOff, byArray, n, n3);
            n2 -= n3;
            this.firstChunkOff += n3;
        }
        if (n2 <= 0) {
            return n3;
        }
        IRubyObject iRubyObject = this.encodingReader.callMethod(this.context, "read", this.ruby.newFixnum(n2));
        if (iRubyObject.isNil()) {
            return -1;
        }
        ByteList byteList = iRubyObject.asString().getByteList();
        int n4 = byteList.length();
        System.arraycopy(byteList.unsafeBytes(), byteList.getBegin(), byArray, n + n3, n4);
        return n4 + n3;
    }

    public int read() {
        byte[] byArray = new byte[1];
        int n = this.read(byArray, 0, 1);
        if (n < 1) {
            return n;
        }
        return byArray[0];
    }
}

