/*
 * Decompiled with CFR 0.152.
 */
package nokogiri.internals;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nokogiri.HtmlDocument;
import nokogiri.NokogiriService;
import nokogiri.XmlAttr;
import nokogiri.XmlCdata;
import nokogiri.XmlComment;
import nokogiri.XmlDocument;
import nokogiri.XmlDtd;
import nokogiri.XmlElement;
import nokogiri.XmlEntityReference;
import nokogiri.XmlNamespace;
import nokogiri.XmlNode;
import nokogiri.XmlProcessingInstruction;
import nokogiri.XmlText;
import nokogiri.internals.NokogiriNamespaceCache;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyString;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NokogiriHelpers {
    public static final String CACHED_NODE = "NOKOGIRI_CACHED_NODE";
    public static final String VALID_ROOT_NODE = "NOKOGIRI_VALIDE_ROOT_NODE";
    public static final String ENCODED_STRING = "NOKOGIRI_ENCODED_STRING";
    private static Charset utf8 = null;
    private static Pattern encoded_pattern = Pattern.compile("&amp;|&gt;|&lt;|&#13;");
    private static Pattern decoded_pattern = Pattern.compile("&|>|<|\r");
    private static String[] encoded = new String[]{"&amp;", "&gt;", "&lt;", "&#13;"};
    private static String[] decoded = new String[]{"&", ">", "<", "\r"};
    public static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    private static Set<String> charsetNames = Charset.availableCharsets().keySet();
    private static Charset shift_jis = Charset.forName("Shift_JIS");
    private static Charset jis = Charset.forName("ISO-2022-JP");
    private static Charset euc_jp = Charset.forName("EUC-JP");

    public static XmlNode getCachedNode(Node node) {
        return (XmlNode)node.getUserData(CACHED_NODE);
    }

    public static IRubyObject getCachedNodeOrCreate(Ruby ruby2, Node node) {
        XmlNode xmlNode;
        if (node == null) {
            return ruby2.getNil();
        }
        if (node.getNodeType() == 2 && NokogiriHelpers.isNamespace(node.getNodeName()) && !((xmlNode = (XmlDocument)node.getOwnerDocument().getUserData(CACHED_NODE)) instanceof HtmlDocument)) {
            String string2 = NokogiriHelpers.getLocalNameForNamespace(((Attr)node).getName());
            string2 = string2 != null ? string2 : "";
            String string3 = ((Attr)node).getValue();
            XmlNamespace xmlNamespace = ((XmlDocument)xmlNode).getNamespaceCache().get(string2, string3);
            if (xmlNamespace != null) {
                return xmlNamespace;
            }
            return XmlNamespace.createFromAttr(ruby2, (Attr)node);
        }
        xmlNode = NokogiriHelpers.getCachedNode(node);
        if (xmlNode == null) {
            xmlNode = (XmlNode)NokogiriHelpers.constructNode(ruby2, node);
            node.setUserData(CACHED_NODE, xmlNode, null);
        }
        return xmlNode;
    }

    public static IRubyObject constructNode(Ruby ruby2, Node node) {
        if (node == null) {
            return ruby2.getNil();
        }
        switch (node.getNodeType()) {
            case 1: {
                XmlElement xmlElement = (XmlElement)NokogiriService.XML_ELEMENT_ALLOCATOR.allocate(ruby2, NokogiriHelpers.getNokogiriClass(ruby2, "Nokogiri::XML::Element"));
                xmlElement.setNode(ruby2.getCurrentContext(), node);
                return xmlElement;
            }
            case 2: {
                XmlAttr xmlAttr = (XmlAttr)NokogiriService.XML_ATTR_ALLOCATOR.allocate(ruby2, NokogiriHelpers.getNokogiriClass(ruby2, "Nokogiri::XML::Attr"));
                xmlAttr.setNode(ruby2.getCurrentContext(), node);
                return xmlAttr;
            }
            case 3: {
                XmlText xmlText = (XmlText)NokogiriService.XML_TEXT_ALLOCATOR.allocate(ruby2, NokogiriHelpers.getNokogiriClass(ruby2, "Nokogiri::XML::Text"));
                xmlText.setNode(ruby2.getCurrentContext(), node);
                return xmlText;
            }
            case 8: {
                XmlComment xmlComment = (XmlComment)NokogiriService.XML_COMMENT_ALLOCATOR.allocate(ruby2, NokogiriHelpers.getNokogiriClass(ruby2, "Nokogiri::XML::Comment"));
                xmlComment.setNode(ruby2.getCurrentContext(), node);
                return xmlComment;
            }
            case 6: {
                return new XmlNode(ruby2, NokogiriHelpers.getNokogiriClass(ruby2, "Nokogiri::XML::EntityDecl"), node);
            }
            case 5: {
                XmlEntityReference xmlEntityReference = (XmlEntityReference)NokogiriService.XML_ENTITY_REFERENCE_ALLOCATOR.allocate(ruby2, NokogiriHelpers.getNokogiriClass(ruby2, "Nokogiri::XML::EntityReference"));
                xmlEntityReference.setNode(ruby2.getCurrentContext(), node);
                return xmlEntityReference;
            }
            case 7: {
                XmlProcessingInstruction xmlProcessingInstruction = (XmlProcessingInstruction)NokogiriService.XML_PROCESSING_INSTRUCTION_ALLOCATOR.allocate(ruby2, NokogiriHelpers.getNokogiriClass(ruby2, "Nokogiri::XML::ProcessingInstruction"));
                xmlProcessingInstruction.setNode(ruby2.getCurrentContext(), node);
                return xmlProcessingInstruction;
            }
            case 4: {
                XmlCdata xmlCdata = (XmlCdata)NokogiriService.XML_CDATA_ALLOCATOR.allocate(ruby2, NokogiriHelpers.getNokogiriClass(ruby2, "Nokogiri::XML::CDATA"));
                xmlCdata.setNode(ruby2.getCurrentContext(), node);
                return xmlCdata;
            }
            case 9: {
                XmlDocument xmlDocument = (XmlDocument)NokogiriService.XML_DOCUMENT_ALLOCATOR.allocate(ruby2, NokogiriHelpers.getNokogiriClass(ruby2, "Nokogiri::XML::Document"));
                xmlDocument.setDocumentNode(ruby2.getCurrentContext(), node);
                return xmlDocument;
            }
            case 10: {
                XmlDtd xmlDtd = (XmlDtd)NokogiriService.XML_DTD_ALLOCATOR.allocate(ruby2, NokogiriHelpers.getNokogiriClass(ruby2, "Nokogiri::XML::DTD"));
                xmlDtd.setNode(ruby2, node);
                return xmlDtd;
            }
        }
        XmlNode xmlNode = (XmlNode)NokogiriService.XML_NODE_ALLOCATOR.allocate(ruby2, NokogiriHelpers.getNokogiriClass(ruby2, "Nokogiri::XML::Node"));
        xmlNode.setNode(ruby2.getCurrentContext(), node);
        return xmlNode;
    }

    public static RubyClass getNokogiriClass(Ruby ruby2, String string2) {
        return NokogiriService.nokogiriClassCache.get(string2);
    }

    public static IRubyObject stringOrNil(Ruby ruby2, String string2) {
        if (string2 == null) {
            return ruby2.getNil();
        }
        return NokogiriHelpers.convertJavaStringToRuby(ruby2, string2);
    }

    public static IRubyObject stringOrNil(Ruby ruby2, byte[] byArray) {
        if (byArray == null) {
            return ruby2.getNil();
        }
        return RubyString.newString(ruby2, byArray);
    }

    public static IRubyObject stringOrBlank(Ruby ruby2, String string2) {
        if (string2 == null) {
            return ruby2.newString();
        }
        return NokogiriHelpers.convertJavaStringToRuby(ruby2, string2);
    }

    private static IRubyObject convertJavaStringToRuby(Ruby ruby2, String string2) {
        if (ruby2.is1_9()) {
            ByteList byteList = new ByteList(string2.getBytes(RubyEncoding.UTF8), UTF8Encoding.INSTANCE);
            return RubyString.newString(ruby2, byteList);
        }
        return RubyString.newString(ruby2, string2);
    }

    public static IRubyObject nonEmptyStringOrNil(Ruby ruby2, String string2) {
        if (string2 == null || string2.length() == 0) {
            return ruby2.getNil();
        }
        return RubyString.newString(ruby2, string2);
    }

    public static String getPrefix(String string2) {
        if (string2 == null) {
            return null;
        }
        int n = string2.indexOf(58);
        if (n > 0) {
            return string2.substring(0, n);
        }
        return null;
    }

    public static String getLocalPart(String string2) {
        if (string2 == null) {
            return null;
        }
        int n = string2.indexOf(58);
        if (n > 0) {
            return string2.substring(n + 1);
        }
        return string2;
    }

    public static String getLocalNameForNamespace(String string2) {
        String string3 = NokogiriHelpers.getLocalPart(string2);
        return "xmlns".equals(string3) ? null : string3;
    }

    private static Charset getCharsetUTF8() {
        if (utf8 == null) {
            utf8 = Charset.forName("UTF-8");
        }
        return utf8;
    }

    public static String rubyStringToString(IRubyObject iRubyObject) {
        if (iRubyObject.isNil()) {
            return null;
        }
        return NokogiriHelpers.toJavaString(iRubyObject.convertToString());
    }

    private static String toJavaString(RubyString rubyString) {
        ByteList byteList = rubyString.getByteList();
        try {
            if (rubyString.getRuntime().is1_9()) {
                return new String(byteList.getUnsafeBytes(), byteList.begin(), byteList.length(), rubyString.getEncoding().toString());
            }
            return RubyEncoding.decodeUTF8(byteList.getUnsafeBytes(), byteList.begin(), byteList.length());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return rubyString.toString();
        }
    }

    public static String rubyStringToString(RubyString rubyString) {
        ByteList byteList = rubyString.getByteList();
        byte[] byArray = byteList.unsafeBytes();
        int n = byteList.begin();
        int n2 = byteList.length();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        return NokogiriHelpers.getCharsetUTF8().decode(byteBuffer).toString();
    }

    public static List<String> rubyStringArrayToJavaList(RubyArray rubyArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int j = 0; j < rubyArray.getLength(); ++j) {
            Object object = rubyArray.get(j);
            if (object == null) continue;
            arrayList.add(object.toString());
        }
        return arrayList;
    }

    public static String getNodeCompletePath(Node node) {
        Node node2;
        String string2 = "";
        int n = 0;
        Node node3 = node;
        do {
            Node node4;
            String string3 = "";
            String string4 = "?";
            n = 0;
            boolean bl = false;
            if (node3.getNodeType() == 9) {
                if (string2.startsWith("/")) break;
                string4 = "/";
                node2 = null;
            } else if (node3.getNodeType() == 1) {
                bl = false;
                string4 = "/";
                string3 = node3.getLocalName();
                if (string3 == null) {
                    string3 = node3.getNodeName();
                }
                if (node3.getNamespaceURI() != null) {
                    if (node3.getPrefix() != null) {
                        string3 = node3.getPrefix() + ":" + string3;
                    } else {
                        bl = true;
                        string3 = "*";
                    }
                }
                node2 = node3.getParentNode();
                for (node4 = node3.getPreviousSibling(); node4 != null; node4 = node4.getPreviousSibling()) {
                    if (node4.getNodeType() != 1 || !bl && !NokogiriHelpers.fullNamesMatch(node4, node3)) continue;
                    ++n;
                }
                if (n == 0) {
                    for (node4 = node3.getNextSibling(); node4 != null && n == 0; node4 = node4.getNextSibling()) {
                        if (node4.getNodeType() != 1 || !bl && !NokogiriHelpers.fullNamesMatch(node4, node3)) continue;
                        ++n;
                    }
                    if (n != 0) {
                        n = 1;
                    }
                } else {
                    ++n;
                }
            } else if (node3.getNodeType() == 8) {
                string4 = "/";
                string3 = "comment()";
                node2 = node3.getParentNode();
                for (node4 = node3.getPreviousSibling(); node4 != null; node4 = node4.getPreviousSibling()) {
                    if (node4.getNodeType() != 8) continue;
                    ++n;
                }
                if (n == 0) {
                    for (node4 = node3.getNextSibling(); node4 != null && n == 0; node4 = node4.getNextSibling()) {
                        if (node4.getNodeType() != 8) continue;
                        ++n;
                    }
                    if (n != 0) {
                        n = 1;
                    }
                } else {
                    n = 1;
                }
            } else if (node3.getNodeType() == 3 || node3.getNodeType() == 4) {
                string4 = "/";
                string3 = "text()";
                node2 = node3.getParentNode();
                for (node4 = node3.getPreviousSibling(); node4 != null; node4 = node4.getPreviousSibling()) {
                    if (node4.getNodeType() != 3 && node4.getNodeType() != 4) continue;
                    ++n;
                }
                if (n == 0) {
                    for (node4 = node3.getNextSibling(); node4 != null && n == 0; node4 = node4.getNextSibling()) {
                        if (node4.getNodeType() != 3 && node4.getNodeType() != 4) continue;
                        ++n;
                    }
                } else {
                    ++n;
                }
            } else if (node3.getNodeType() == 7) {
                string4 = "/";
                string3 = "processing-instruction('" + node3.getLocalName() + "')";
                node2 = node3.getParentNode();
                for (node4 = node3.getParentNode(); node4 != null; node4 = node4.getPreviousSibling()) {
                    if (node4.getNodeType() != 7 || !node4.getLocalName().equals(node3.getLocalName())) continue;
                    ++n;
                }
                if (n == 0) {
                    for (node4 = node3.getNextSibling(); node4 != null && n == 0; node4 = node4.getNextSibling()) {
                        if (node4.getNodeType() != 7 || !node4.getLocalName().equals(node3.getLocalName())) continue;
                        ++n;
                    }
                    if (n != 0) {
                        n = 1;
                    }
                } else {
                    ++n;
                }
            } else if (node3.getNodeType() == 2) {
                string4 = "/@";
                string3 = node3.getLocalName();
                if (node3.getNamespaceURI() != null && node3.getPrefix() != null) {
                    string3 = node3.getPrefix() + ":" + string3;
                }
                node2 = ((Attr)node3).getOwnerElement();
            } else {
                node2 = node3.getParentNode();
            }
            string2 = n == 0 ? string4 + string3 + string2 : string4 + string3 + "[" + n + "]" + string2;
        } while ((node3 = node2) != null);
        return string2;
    }

    protected static boolean compareTwoNodes(Node node, Node node2) {
        return NokogiriHelpers.nodesAreEqual(node.getLocalName(), node2.getLocalName()) && NokogiriHelpers.nodesAreEqual(node.getPrefix(), node2.getPrefix());
    }

    protected static boolean fullNamesMatch(Node node, Node node2) {
        return node.getNodeName().equals(node2.getNodeName());
    }

    protected static String getFullName(Node node) {
        String string2 = node.getLocalName();
        String string3 = node.getPrefix();
        if (string2 != null) {
            if (string3 != null) {
                return string3 + ":" + string2;
            }
            return string2;
        }
        return node.getNodeName();
    }

    private static boolean nodesAreEqual(Object object, Object object2) {
        return object == null && object == null || object != null && object2 != null && object2.equals(object);
    }

    private static String convert(Pattern pattern, String string2, String[] stringArray, String[] stringArray2) {
        Matcher matcher = pattern.matcher(string2);
        boolean bl = matcher.find();
        StringBuffer stringBuffer = new StringBuffer();
        while (bl) {
            String string3 = matcher.group();
            String string4 = "";
            for (int j = 0; j < stringArray.length; ++j) {
                if (!string3.contains(stringArray[j])) continue;
                string4 = string3.replace(stringArray[j], stringArray2[j]);
                break;
            }
            matcher.appendReplacement(stringBuffer, string4);
            bl = matcher.find();
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public static String encodeJavaString(String string2) {
        return NokogiriHelpers.convert(decoded_pattern, string2, decoded, encoded);
    }

    public static String decodeJavaString(String string2) {
        return NokogiriHelpers.convert(encoded_pattern, string2, encoded, decoded);
    }

    public static String getNodeName(Node node) {
        if (node == null) {
            System.out.println("node is null");
            return "";
        }
        String string2 = node.getNodeName();
        if (string2 == null) {
            System.out.println("name is null");
            return "";
        }
        if (string2.equals("#document")) {
            return "document";
        }
        if (string2.equals("#text")) {
            return "text";
        }
        return (string2 = NokogiriHelpers.getLocalPart(string2)) == null ? "" : string2;
    }

    public static boolean isNamespace(Node node) {
        return XMLNS_URI.equals(node.getNamespaceURI()) || NokogiriHelpers.isNamespace(node.getNodeName());
    }

    public static boolean isNamespace(String string2) {
        return string2.startsWith("xmlns");
    }

    public static boolean isNonDefaultNamespace(Node node) {
        return NokogiriHelpers.isNamespace(node) && !"xmlns".equals(node.getNodeName());
    }

    public static boolean isXmlBase(String string2) {
        return "xml:base".equals(string2) || "xlink:href".equals(string2);
    }

    public static boolean isWhitespaceText(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject == null || iRubyObject.isNil()) {
            return false;
        }
        XmlNode xmlNode = (XmlNode)iRubyObject;
        if (!(xmlNode instanceof XmlText)) {
            return false;
        }
        String string2 = NokogiriHelpers.rubyStringToString(xmlNode.content(threadContext));
        return string2.trim().length() == 0;
    }

    public static boolean isWhitespaceText(String string2) {
        return string2.trim().length() == 0;
    }

    public static String canonicalizeWhitespce(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = string2.toCharArray();
        boolean bl = false;
        for (int j = 0; j < cArray.length; ++j) {
            if (cArray[j] == '\n') {
                if (bl) continue;
                stringBuilder.append(cArray[j]);
                bl = true;
                continue;
            }
            stringBuilder.append(cArray[j]);
        }
        return stringBuilder.toString();
    }

    public static String newQName(String string2, Node node) {
        String string3 = NokogiriHelpers.getLocalPart(node.getNodeName());
        if (string2 == null) {
            return string3;
        }
        return string2 + ":" + string3;
    }

    public static RubyArray nodeListToRubyArray(Ruby ruby2, NodeList nodeList) {
        RubyArray rubyArray = RubyArray.newArray(ruby2, nodeList.getLength());
        return NokogiriHelpers.nodeListToRubyArray(ruby2, nodeList, rubyArray);
    }

    public static RubyArray nodeListToRubyArray(Ruby ruby2, NodeList nodeList, RubyArray rubyArray) {
        for (int j = 0; j < nodeList.getLength(); ++j) {
            rubyArray.append(NokogiriHelpers.getCachedNodeOrCreate(ruby2, nodeList.item(j)));
        }
        return rubyArray;
    }

    public static RubyArray nodeArrayToRubyArray(Ruby ruby2, Node[] nodeArray) {
        RubyArray rubyArray = RubyArray.newArray(ruby2, nodeArray.length);
        for (int j = 0; j < nodeArray.length; ++j) {
            rubyArray.append(NokogiriHelpers.getCachedNodeOrCreate(ruby2, nodeArray[j]));
        }
        return rubyArray;
    }

    public static RubyArray namedNodeMapToRubyArray(Ruby ruby2, NamedNodeMap namedNodeMap) {
        RubyArray rubyArray = RubyArray.newArray(ruby2, namedNodeMap.getLength());
        for (int j = 0; j < namedNodeMap.getLength(); ++j) {
            rubyArray.append(NokogiriHelpers.getCachedNodeOrCreate(ruby2, namedNodeMap.item(j)));
        }
        return rubyArray;
    }

    public static String getValidEncoding(Ruby ruby2, IRubyObject iRubyObject) {
        if (iRubyObject.isNil()) {
            return NokogiriHelpers.guessEncoding();
        }
        return NokogiriHelpers.ignoreInvalidEncoding(ruby2, iRubyObject);
    }

    private static String guessEncoding() {
        String string2 = null;
        if (string2 == null) {
            string2 = System.getProperty("file.encoding");
        }
        if (string2 == null) {
            string2 = "UTF-8";
        }
        return string2;
    }

    private static String ignoreInvalidEncoding(Ruby ruby2, IRubyObject iRubyObject) {
        String string2 = NokogiriHelpers.rubyStringToString(iRubyObject);
        if (charsetNames.contains(string2)) {
            return string2;
        }
        return NokogiriHelpers.guessEncoding();
    }

    public static String adjustSystemIdIfNecessary(String string2, String string3, String string4, String string5) {
        if (string5 == null) {
            return string5;
        }
        File file2 = new File(string5);
        if (file2.isAbsolute()) {
            return string5;
        }
        String string6 = NokogiriHelpers.resolveSystemId(string4, string5);
        if (string6 != null) {
            return string6;
        }
        string6 = NokogiriHelpers.resolveSystemId(string2, string5);
        if (string6 != null) {
            return string6;
        }
        return NokogiriHelpers.resolveSystemId(string3, string5);
    }

    private static String resolveSystemId(String string2, String string3) {
        File file2;
        if (string2 == null || string2.length() < 1) {
            return null;
        }
        String string4 = null;
        File file3 = new File(string2 = string2.replaceAll("%20", " "));
        string4 = file3.isDirectory() ? string2 : file3.getParent();
        if (string4.toLowerCase().startsWith("file:")) {
            string4 = string4.substring("file:".length());
        }
        if ((file2 = new File(string4 + "/" + string3)).exists()) {
            return file2.getPath();
        }
        return null;
    }

    public static boolean isUTF8(String string2) {
        if (string2 == null) {
            return true;
        }
        int n = Charset.forName(string2).compareTo(Charset.forName("UTF-8"));
        return n == 0;
    }

    public static byte[] convertEncoding(Charset charset, String string2) throws CharacterCodingException {
        CharsetEncoder charsetEncoder = charset.newEncoder();
        CharBuffer charBuffer = CharBuffer.wrap(string2);
        ByteBuffer byteBuffer = charsetEncoder.encode(charBuffer);
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        return byArray;
    }

    public static String convertEncodingByNKFIfNecessary(Ruby ruby2, XmlDocument xmlDocument, String string2) {
        if (!(xmlDocument instanceof HtmlDocument)) {
            return string2;
        }
        String string3 = ((HtmlDocument)xmlDocument).getPraedEncoding();
        if (string3 == null) {
            return string2;
        }
        String string4 = NokogiriHelpers.rubyStringToString(xmlDocument.getEncoding());
        if (string4 == null) {
            return string2;
        }
        if (Charset.forName(string3).compareTo(Charset.forName(string4)) == 0) {
            return string2;
        }
        return NokogiriHelpers.nkf(ruby2, string4, string2);
    }

    public static String nkf(Ruby ruby2, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer("-");
        Charset charset = Charset.forName(string2);
        if (shift_jis.compareTo(charset) == 0) {
            stringBuffer.append("S");
        } else if (jis.compareTo(charset) == 0) {
            stringBuffer.append("J");
        } else if (euc_jp.compareTo(charset) == 0) {
            stringBuffer.append("E");
        } else {
            stringBuffer.append("W");
        }
        stringBuffer.append("w");
        Class<?> clazz = null;
        try {
            clazz = ruby2.getClassLoader().loadClass("org.jruby.ext.nkf.RubyNKF");
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz = ruby2.getClassLoader().loadClass("org.jruby.RubyNKF");
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return string3;
            }
        }
        try {
            Method method2 = clazz.getMethod("nkf", ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class);
            RubyString rubyString = (RubyString)method2.invoke(null, ruby2.getCurrentContext(), null, ruby2.newString(new String(stringBuffer)), ruby2.newString(string3));
            return NokogiriHelpers.rubyStringToString(rubyString);
        }
        catch (SecurityException securityException) {
            return string3;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return string3;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return string3;
        }
        catch (IllegalAccessException illegalAccessException) {
            return string3;
        }
        catch (InvocationTargetException invocationTargetException) {
            return string3;
        }
    }

    public static boolean shouldEncode(Node node) {
        return node.getUserData(ENCODED_STRING) == null || (Boolean)node.getUserData(ENCODED_STRING) == false;
    }

    public static boolean shouldDecode(Node node) {
        return !NokogiriHelpers.shouldEncode(node);
    }

    public static Node renameNode(Node node, String string2, String string3) throws DOMException {
        Document document = node.getOwnerDocument();
        XmlDocument xmlDocument = (XmlDocument)NokogiriHelpers.getCachedNode(document);
        NokogiriNamespaceCache nokogiriNamespaceCache = xmlDocument.getNamespaceCache();
        int n = node.hashCode();
        Node node2 = document.renameNode(node, string2, string3);
        if (node2 != node) {
            nokogiriNamespaceCache.replaceNode(node, node2);
        }
        return node2;
    }
}

