/*
 * Decompiled with CFR 0.152.
 */
package nokogiri.internals;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nokogiri.XmlNamespace;
import nokogiri.internals.NokogiriHelpers;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NokogiriNamespaceCache {
    private List<Long> keys = new ArrayList<Long>();
    private Map<Integer, CacheEntry> cache = new LinkedHashMap<Integer, CacheEntry>();
    private XmlNamespace defaultNamespace = null;

    private Long hashCode(String string2, String string3) {
        long l = string2.hashCode();
        long l2 = string3.hashCode();
        return l << 31 | l2;
    }

    public XmlNamespace get(String string2, String string3) {
        if (string2 == null || string3 == null) {
            return null;
        }
        Long l = this.hashCode(string2, string3);
        Integer n = this.keys.indexOf(l);
        if (n != -1) {
            return this.cache.get(n).namespace;
        }
        return null;
    }

    public XmlNamespace getDefault() {
        return this.defaultNamespace;
    }

    public XmlNamespace get(String string2) {
        if (string2 == null) {
            return this.defaultNamespace;
        }
        long l = string2.hashCode();
        Long l2 = l << 31;
        Long l3 = 65280L;
        for (int j = 0; j < this.keys.size(); ++j) {
            if ((this.keys.get(j) & l3) != l2) continue;
            return this.cache.get(j).namespace;
        }
        return null;
    }

    public List<XmlNamespace> get(Node node) {
        ArrayList<XmlNamespace> arrayList = new ArrayList<XmlNamespace>();
        for (int j = 0; j < this.keys.size(); ++j) {
            CacheEntry cacheEntry = this.cache.get(j);
            if (!cacheEntry.isOwner(node).booleanValue()) continue;
            arrayList.add(cacheEntry.namespace);
        }
        return arrayList;
    }

    public void put(XmlNamespace xmlNamespace, Node node) {
        String string2;
        String string3 = xmlNamespace.getPrefix();
        Long l = this.hashCode(string3, string2 = xmlNamespace.getHref());
        Integer n = this.keys.indexOf(l);
        if (n != -1) {
            return;
        }
        this.keys.add(l);
        n = this.keys.size() - 1;
        CacheEntry cacheEntry = new CacheEntry(xmlNamespace, node);
        this.cache.put(n, cacheEntry);
        if ("".equals(string3)) {
            this.defaultNamespace = xmlNamespace;
        }
    }

    public void remove(String string2, String string3) {
        if (string2 == null || string3 == null) {
            return;
        }
        Long l = this.hashCode(string2, string3);
        Integer n = this.keys.indexOf(l);
        if (n != -1) {
            this.cache.remove(n);
        }
        this.keys.remove(n);
    }

    public void clear() {
        for (int j = 0; j < this.keys.size(); ++j) {
            CacheEntry cacheEntry = this.cache.get(j);
            NamedNodeMap namedNodeMap = cacheEntry.ownerNode.getAttributes();
            for (int k = 0; k < namedNodeMap.getLength(); ++k) {
                String string2 = ((Attr)namedNodeMap.item(k)).getName();
                if (!NokogiriHelpers.isNamespace(string2)) continue;
                namedNodeMap.removeNamedItem(string2);
            }
        }
        this.keys.clear();
        this.cache.clear();
        this.defaultNamespace = null;
    }

    public void replaceNode(Node node, Node node2) {
        for (int j = 0; j < this.keys.size(); ++j) {
            CacheEntry cacheEntry = this.cache.get(j);
            if (!cacheEntry.isOwner(node).booleanValue()) continue;
            cacheEntry.replaceOwner(node2);
        }
    }

    private class CacheEntry {
        private XmlNamespace namespace;
        private Node ownerNode;

        CacheEntry(XmlNamespace xmlNamespace, Node node) {
            this.namespace = xmlNamespace;
            this.ownerNode = node;
        }

        public Boolean isOwner(Node node) {
            return this.ownerNode.isSameNode(node);
        }

        public void replaceOwner(Node node) {
            this.ownerNode = node;
        }
    }
}

