/*
 * Decompiled with CFR 0.152.
 */
package nokogiri.internals;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NokogiriNamespaceContext
implements NamespaceContext {
    private static NokogiriNamespaceContext namespaceContext;
    public static final String NOKOGIRI_PREFIX = "nokogiri";
    public static final String NOKOGIRI_URI = "http://www.nokogiri.org/default_ns/ruby/extensions_functions";
    public static final String NOKOGIRI_TEMPORARY_ROOT_TAG = "nokogiri-temporary-root-tag";
    private Hashtable<String, String> register = new Hashtable();

    public static NokogiriNamespaceContext create() {
        if (namespaceContext == null) {
            namespaceContext = new NokogiriNamespaceContext();
        }
        try {
            NokogiriNamespaceContext nokogiriNamespaceContext = (NokogiriNamespaceContext)namespaceContext.clone();
            return nokogiriNamespaceContext;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            NokogiriNamespaceContext nokogiriNamespaceContext = new NokogiriNamespaceContext();
            return nokogiriNamespaceContext;
        }
    }

    private NokogiriNamespaceContext() {
        this.register.put(NOKOGIRI_PREFIX, NOKOGIRI_URI);
        this.register.put("xml", "http://www.w3.org/XML/1998/namespace");
        this.register.put("xhtml", "http://www.w3.org/1999/xhtml");
    }

    @Override
    public String getNamespaceURI(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        String string3 = this.register.get(string2);
        if (string3 != null) {
            return string3;
        }
        if (string2.equals("xmlns")) {
            string3 = this.register.get("xmlns");
            return string3 == null ? "http://www.w3.org/2000/xmlns/" : string3;
        }
        return "";
    }

    @Override
    public String getPrefix(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("uri is null");
        }
        Set<Map.Entry<String, String>> set = this.register.entrySet();
        for (Map.Entry<String, String> entry : set) {
            if (!string2.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public Iterator<String> getPrefixes(String string2) {
        if (this.register == null) {
            return null;
        }
        Set<Map.Entry<String, String>> set = this.register.entrySet();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, String> entry : set) {
            if (!string2.equals(entry.getValue())) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList.iterator();
    }

    public Set<String> getAllPrefixes() {
        if (this.register == null) {
            return null;
        }
        return this.register.keySet();
    }

    public void registerNamespace(String string2, String string3) {
        if ("xmlns".equals(string2)) {
            string2 = "";
        }
        this.register.put(string2, string3);
    }
}

