/*
 * Decompiled with CFR 0.152.
 */
package nokogiri.internals;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import nokogiri.NokogiriService;
import nokogiri.XmlDocument;
import nokogiri.XmlDtd;
import nokogiri.XmlSyntaxError;
import nokogiri.internals.NokogiriDomParser;
import nokogiri.internals.NokogiriEntityResolver;
import nokogiri.internals.NokogiriErrorHandler;
import nokogiri.internals.NokogiriHelpers;
import nokogiri.internals.NokogiriNonStrictErrorHandler;
import nokogiri.internals.NokogiriStrictErrorHandler;
import nokogiri.internals.ParserContext;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.util.SecurityManager;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlDomParserContext
extends ParserContext {
    protected static final String FEATURE_LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    protected static final String FEATURE_LOAD_DTD_GRAMMAR = "http://apache.org/xml/features/nonvalidating/load-dtd-grammar";
    protected static final String FEATURE_INCLUDE_IGNORABLE_WHITESPACE = "http://apache.org/xml/features/dom/include-ignorable-whitespace";
    protected static final String CONTINUE_AFTER_FATAL_ERROR = "http://apache.org/xml/features/continue-after-fatal-error";
    protected static final String FEATURE_NOT_EXPAND_ENTITY = "http://apache.org/xml/features/dom/create-entity-ref-nodes";
    protected static final String FEATURE_VALIDATION = "http://xml.org/sax/features/validation";
    private static final String XINCLUDE_FEATURE_ID = "http://apache.org/xml/features/xinclude";
    private static final String SECURITY_MANAGER = "http://apache.org/xml/properties/security-manager";
    protected ParserContext.Options options;
    protected DOMParser parser;
    protected NokogiriErrorHandler errorHandler;
    protected String java_encoding;
    protected IRubyObject ruby_encoding;

    public XmlDomParserContext(Ruby ruby2, IRubyObject iRubyObject) {
        this(ruby2, ruby2.getNil(), iRubyObject);
    }

    public XmlDomParserContext(Ruby ruby2, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        super(ruby2);
        this.options = new ParserContext.Options((Long)iRubyObject2.toJava(Long.class));
        this.java_encoding = NokogiriHelpers.getValidEncoding(ruby2, iRubyObject);
        this.ruby_encoding = iRubyObject;
        this.initErrorHandler();
        this.initParser(ruby2);
    }

    protected void initErrorHandler() {
        this.errorHandler = this.options.recover ? new NokogiriNonStrictErrorHandler(this.options.noError, this.options.noWarning) : new NokogiriStrictErrorHandler(this.options.noError, this.options.noWarning);
    }

    protected void initParser(Ruby ruby2) {
        if (this.options.xInclude) {
            System.setProperty("org.apache.xerces.xni.parser.XMLParserConfiguration", "org.apache.xerces.parsers.XIncludeParserConfiguration");
        }
        this.parser = new NokogiriDomParser(this.options);
        this.parser.setErrorHandler(this.errorHandler);
        this.setProperty(SECURITY_MANAGER, new SecurityManager());
        if (this.options.noBlanks) {
            this.setFeature(FEATURE_INCLUDE_IGNORABLE_WHITESPACE, false);
        }
        if (this.options.recover) {
            this.setFeature(CONTINUE_AFTER_FATAL_ERROR, true);
        }
        if (this.options.dtdValid) {
            this.setFeature(FEATURE_VALIDATION, true);
        }
        if (!this.options.noEnt) {
            this.setFeature(FEATURE_NOT_EXPAND_ENTITY, true);
        }
        if (this.options.dtdLoad) {
            this.setFeature(FEATURE_LOAD_EXTERNAL_DTD, true);
            this.setFeature(FEATURE_LOAD_DTD_GRAMMAR, true);
        }
        this.parser.setEntityResolver(new NokogiriEntityResolver(ruby2, this.errorHandler, this.options));
    }

    protected void setFeature(String string2, boolean bl) {
        try {
            this.parser.setFeature(string2, bl);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    protected void setProperty(String string2, Object object) {
        try {
            this.parser.setProperty(string2, object);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public void addErrorsIfNecessary(ThreadContext threadContext, XmlDocument xmlDocument) {
        Ruby ruby2 = threadContext.getRuntime();
        RubyArray rubyArray = ruby2.newArray(this.errorHandler.getErrorsReadyForRuby(threadContext));
        xmlDocument.setInstanceVariable("@errors", rubyArray);
    }

    public XmlDocument getDocumentWithErrorsOrRaiseException(ThreadContext threadContext, RubyClass rubyClass, Exception exception2) {
        if (this.options.recover) {
            XmlDocument xmlDocument = this.getInterruptedOrNewXmlDocument(threadContext, rubyClass);
            this.addErrorsIfNecessary(threadContext, xmlDocument);
            XmlSyntaxError xmlSyntaxError = (XmlSyntaxError)NokogiriService.XML_SYNTAXERROR_ALLOCATOR.allocate(threadContext.getRuntime(), NokogiriHelpers.getNokogiriClass(threadContext.getRuntime(), "Nokogiri::XML::SyntaxError"));
            xmlSyntaxError.setException(exception2);
            ((RubyArray)xmlDocument.getInstanceVariable("@errors")).append(xmlSyntaxError);
            return xmlDocument;
        }
        XmlSyntaxError xmlSyntaxError = (XmlSyntaxError)NokogiriService.XML_SYNTAXERROR_ALLOCATOR.allocate(threadContext.getRuntime(), NokogiriHelpers.getNokogiriClass(threadContext.getRuntime(), "Nokogiri::XML::SyntaxError"));
        xmlSyntaxError.setException(exception2);
        throw new RaiseException(xmlSyntaxError);
    }

    private XmlDocument getInterruptedOrNewXmlDocument(ThreadContext threadContext, RubyClass rubyClass) {
        Document document = this.parser.getDocument();
        XmlDocument xmlDocument = (XmlDocument)NokogiriService.XML_DOCUMENT_ALLOCATOR.allocate(threadContext.getRuntime(), rubyClass);
        if (document != null) {
            xmlDocument.setDocumentNode(threadContext, document);
        }
        xmlDocument.setEncoding(this.ruby_encoding);
        return xmlDocument;
    }

    protected XmlDocument getNewEmptyDocument(ThreadContext threadContext) {
        IRubyObject[] iRubyObjectArray = new IRubyObject[]{};
        return (XmlDocument)XmlDocument.rbNew(threadContext, NokogiriHelpers.getNokogiriClass(threadContext.getRuntime(), "Nokogiri::XML::Document"), iRubyObjectArray);
    }

    protected XmlDocument wrapDocument(ThreadContext threadContext, RubyClass rubyClass, Document document) {
        IRubyObject iRubyObject;
        XmlDocument xmlDocument = (XmlDocument)NokogiriService.XML_DOCUMENT_ALLOCATOR.allocate(threadContext.getRuntime(), rubyClass);
        xmlDocument.setDocumentNode(threadContext, document);
        xmlDocument.setEncoding(this.ruby_encoding);
        if (this.options.dtdLoad && !(iRubyObject = XmlDtd.newFromExternalSubset(threadContext.getRuntime(), document)).isNil()) {
            XmlDtd xmlDtd = (XmlDtd)iRubyObject;
            document.setUserData("DTD_EXTERNAL_SUBSET", xmlDtd, null);
        }
        return xmlDocument;
    }

    public XmlDocument parse(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        try {
            Document document = this.do_parse();
            XmlDocument xmlDocument = this.wrapDocument(threadContext, (RubyClass)iRubyObject, document);
            xmlDocument.setUrl(iRubyObject2);
            this.addErrorsIfNecessary(threadContext, xmlDocument);
            return xmlDocument;
        }
        catch (SAXException sAXException) {
            return this.getDocumentWithErrorsOrRaiseException(threadContext, (RubyClass)iRubyObject, sAXException);
        }
        catch (IOException iOException) {
            return this.getDocumentWithErrorsOrRaiseException(threadContext, (RubyClass)iRubyObject, iOException);
        }
    }

    protected Document do_parse() throws SAXException, IOException {
        try {
            this.parser.parse(this.getInputSource());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (this.options.noBlanks) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            this.findEmptyTexts(this.parser.getDocument(), arrayList);
            if (arrayList.size() > 0) {
                for (Node node : arrayList) {
                    node.getParentNode().removeChild(node);
                }
            }
        }
        return this.parser.getDocument();
    }

    private void findEmptyTexts(Node node, List<Node> list2) {
        if (node.getNodeType() == 3 && "".equals(node.getTextContent().trim())) {
            list2.add(node);
        } else {
            NodeList nodeList = node.getChildNodes();
            for (int j = 0; j < nodeList.getLength(); ++j) {
                this.findEmptyTexts(nodeList.item(j), list2);
            }
        }
    }
}

