/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Stack;
import org.apache.http.HttpHost;
import org.apache.http.annotation.Immutable;

@Immutable
public class URIUtils {
    public static URI createURI(String scheme, String host, int port, String path2, String query, String fragment) throws URISyntaxException {
        StringBuilder buffer = new StringBuilder();
        if (host != null) {
            if (scheme != null) {
                buffer.append(scheme);
                buffer.append("://");
            }
            buffer.append(host);
            if (port > 0) {
                buffer.append(':');
                buffer.append(port);
            }
        }
        if (path2 == null || !path2.startsWith("/")) {
            buffer.append('/');
        }
        if (path2 != null) {
            buffer.append(path2);
        }
        if (query != null) {
            buffer.append('?');
            buffer.append(query);
        }
        if (fragment != null) {
            buffer.append('#');
            buffer.append(fragment);
        }
        return new URI(buffer.toString());
    }

    public static URI rewriteURI(URI uri, HttpHost target, boolean dropFragment) throws URISyntaxException {
        if (uri == null) {
            throw new IllegalArgumentException("URI may nor be null");
        }
        if (target != null) {
            return URIUtils.createURI(target.getSchemeName(), target.getHostName(), target.getPort(), URIUtils.normalizePath(uri.getRawPath()), uri.getRawQuery(), dropFragment ? null : uri.getRawFragment());
        }
        return URIUtils.createURI(null, null, -1, URIUtils.normalizePath(uri.getRawPath()), uri.getRawQuery(), dropFragment ? null : uri.getRawFragment());
    }

    private static String normalizePath(String path2) {
        int n;
        if (path2 == null) {
            return null;
        }
        for (n = 0; n < path2.length() && path2.charAt(n) == '/'; ++n) {
        }
        if (n > 1) {
            path2 = path2.substring(n - 1);
        }
        return path2;
    }

    public static URI rewriteURI(URI uri, HttpHost target) throws URISyntaxException {
        return URIUtils.rewriteURI(uri, target, false);
    }

    public static URI resolve(URI baseURI, String reference2) {
        return URIUtils.resolve(baseURI, URI.create(reference2));
    }

    public static URI resolve(URI baseURI, URI reference2) {
        boolean emptyReference;
        if (baseURI == null) {
            throw new IllegalArgumentException("Base URI may nor be null");
        }
        if (reference2 == null) {
            throw new IllegalArgumentException("Reference URI may nor be null");
        }
        String s2 = reference2.toString();
        if (s2.startsWith("?")) {
            return URIUtils.resolveReferenceStartingWithQueryString(baseURI, reference2);
        }
        boolean bl = emptyReference = s2.length() == 0;
        if (emptyReference) {
            reference2 = URI.create("#");
        }
        URI resolved = baseURI.resolve(reference2);
        if (emptyReference) {
            String resolvedString = resolved.toString();
            resolved = URI.create(resolvedString.substring(0, resolvedString.indexOf(35)));
        }
        return URIUtils.removeDotSegments(resolved);
    }

    private static URI resolveReferenceStartingWithQueryString(URI baseURI, URI reference2) {
        String baseUri = baseURI.toString();
        baseUri = baseUri.indexOf(63) > -1 ? baseUri.substring(0, baseUri.indexOf(63)) : baseUri;
        return URI.create(baseUri + reference2.toString());
    }

    private static URI removeDotSegments(URI uri) {
        String path2 = uri.getPath();
        if (path2 == null || path2.indexOf("/.") == -1) {
            return uri;
        }
        String[] inputSegments = path2.split("/");
        Stack<String> outputSegments = new Stack<String>();
        for (int i2 = 0; i2 < inputSegments.length; ++i2) {
            if (inputSegments[i2].length() == 0 || ".".equals(inputSegments[i2])) continue;
            if ("..".equals(inputSegments[i2])) {
                if (outputSegments.isEmpty()) continue;
                outputSegments.pop();
                continue;
            }
            outputSegments.push(inputSegments[i2]);
        }
        StringBuilder outputBuffer = new StringBuilder();
        for (String outputSegment : outputSegments) {
            outputBuffer.append('/').append(outputSegment);
        }
        try {
            return new URI(uri.getScheme(), uri.getAuthority(), outputBuffer.toString(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static HttpHost extractHost(URI uri) {
        if (uri == null) {
            return null;
        }
        HttpHost target = null;
        if (uri.isAbsolute()) {
            int port = uri.getPort();
            String host = uri.getHost();
            if (host == null && (host = uri.getAuthority()) != null) {
                int colon;
                int at2 = host.indexOf(64);
                if (at2 >= 0) {
                    host = host.length() > at2 + 1 ? host.substring(at2 + 1) : null;
                }
                if (host != null && (colon = host.indexOf(58)) >= 0) {
                    if (colon + 1 < host.length()) {
                        port = Integer.parseInt(host.substring(colon + 1));
                    }
                    host = host.substring(0, colon);
                }
            }
            String scheme = uri.getScheme();
            if (host != null) {
                target = new HttpHost(host, port, scheme);
            }
        }
        return target;
    }

    private URIUtils() {
    }
}

