/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.params;

import java.net.InetAddress;
import org.apache.http.HttpHost;
import org.apache.http.annotation.Immutable;
import org.apache.http.conn.params.ConnRoutePNames;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.params.HttpParams;

@Immutable
public class ConnRouteParams
implements ConnRoutePNames {
    public static final HttpHost NO_HOST = new HttpHost("127.0.0.255", 0, "no-host");
    public static final HttpRoute NO_ROUTE = new HttpRoute(NO_HOST);

    private ConnRouteParams() {
    }

    public static HttpHost getDefaultProxy(HttpParams params2) {
        if (params2 == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        HttpHost proxy2 = (HttpHost)params2.getParameter("http.route.default-proxy");
        if (proxy2 != null && NO_HOST.equals(proxy2)) {
            proxy2 = null;
        }
        return proxy2;
    }

    public static void setDefaultProxy(HttpParams params2, HttpHost proxy2) {
        if (params2 == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        params2.setParameter("http.route.default-proxy", proxy2);
    }

    public static HttpRoute getForcedRoute(HttpParams params2) {
        if (params2 == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        HttpRoute route = (HttpRoute)params2.getParameter("http.route.forced-route");
        if (route != null && NO_ROUTE.equals(route)) {
            route = null;
        }
        return route;
    }

    public static void setForcedRoute(HttpParams params2, HttpRoute route) {
        if (params2 == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        params2.setParameter("http.route.forced-route", route);
    }

    public static InetAddress getLocalAddress(HttpParams params2) {
        if (params2 == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        InetAddress local = (InetAddress)params2.getParameter("http.route.local-address");
        return local;
    }

    public static void setLocalAddress(HttpParams params2, InetAddress local) {
        if (params2 == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        params2.setParameter("http.route.local-address", local);
    }
}

