/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity.mime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.http.entity.mime.MinimalField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Header
implements Iterable<MinimalField> {
    private final List<MinimalField> fields = new LinkedList<MinimalField>();
    private final Map<String, List<MinimalField>> fieldMap = new HashMap<String, List<MinimalField>>();

    public void addField(MinimalField field2) {
        if (field2 == null) {
            return;
        }
        String key2 = field2.getName().toLowerCase(Locale.US);
        List<MinimalField> values2 = this.fieldMap.get(key2);
        if (values2 == null) {
            values2 = new LinkedList<MinimalField>();
            this.fieldMap.put(key2, values2);
        }
        values2.add(field2);
        this.fields.add(field2);
    }

    public List<MinimalField> getFields() {
        return new ArrayList<MinimalField>(this.fields);
    }

    public MinimalField getField(String name2) {
        if (name2 == null) {
            return null;
        }
        String key2 = name2.toLowerCase(Locale.US);
        List<MinimalField> list2 = this.fieldMap.get(key2);
        if (list2 != null && !list2.isEmpty()) {
            return list2.get(0);
        }
        return null;
    }

    public List<MinimalField> getFields(String name2) {
        if (name2 == null) {
            return null;
        }
        String key2 = name2.toLowerCase(Locale.US);
        List<MinimalField> list2 = this.fieldMap.get(key2);
        if (list2 == null || list2.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<MinimalField>(list2);
    }

    public int removeFields(String name2) {
        if (name2 == null) {
            return 0;
        }
        String key2 = name2.toLowerCase(Locale.US);
        List<MinimalField> removed = this.fieldMap.remove(key2);
        if (removed == null || removed.isEmpty()) {
            return 0;
        }
        this.fields.removeAll(removed);
        return removed.size();
    }

    public void setField(MinimalField field2) {
        if (field2 == null) {
            return;
        }
        String key2 = field2.getName().toLowerCase(Locale.US);
        List<MinimalField> list2 = this.fieldMap.get(key2);
        if (list2 == null || list2.isEmpty()) {
            this.addField(field2);
            return;
        }
        list2.clear();
        list2.add(field2);
        int firstOccurrence = -1;
        int index2 = 0;
        Iterator<MinimalField> it = this.fields.iterator();
        while (it.hasNext()) {
            MinimalField f = it.next();
            if (f.getName().equalsIgnoreCase(field2.getName())) {
                it.remove();
                if (firstOccurrence == -1) {
                    firstOccurrence = index2;
                }
            }
            ++index2;
        }
        this.fields.add(firstOccurrence, field2);
    }

    @Override
    public Iterator<MinimalField> iterator() {
        return Collections.unmodifiableList(this.fields).iterator();
    }

    public String toString() {
        return this.fields.toString();
    }
}

